

<?php $__env->startSection('title', 'Tax Rates'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">Tax Rates Management</h3>
                    <a href="<?php echo e(route('admin.tax-rates.create')); ?>" class="btn btn-primary">
                        <i class="fas fa-plus"></i> Add New Tax Rate
                    </a>
                </div>
                
                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show mx-3 mt-3" role="alert">
                        <?php echo e(session('success')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>City</th>
                                    <th>State</th>
                                    <th>Tax Name</th>
                                    <th>Rate</th>
                                    <th>Type</th>
                                    <th>Status</th>
                                    <th width="150">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $taxRates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><strong><?php echo e($rate->city); ?></strong></td>
                                    <td><?php echo e($rate->state); ?></td>
                                    <td><?php echo e($rate->tax_name); ?></td>
                                    <td>
                                        <span class="badge bg-info">
                                            <?php echo e($rate->formatted_rate); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <?php if($rate->is_percentage): ?>
                                            <span class="badge bg-secondary">Percentage</span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary">Fixed</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="form-check form-switch">
                                            <input class="form-check-input toggle-active" 
                                                   type="checkbox" 
                                                   data-id="<?php echo e($rate->id); ?>"
                                                   <?php echo e($rate->is_active ? 'checked' : ''); ?>>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="<?php echo e(route('admin.tax-rates.edit', $rate)); ?>" 
                                               class="btn btn-sm btn-outline-primary">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <?php if(!($rate->city === 'Other' && $rate->state === 'ALL')): ?>
                                            <form action="<?php echo e(route('admin.tax-rates.destroy', $rate)); ?>" 
                                                  method="POST" 
                                                  onsubmit="return confirm('Are you sure?')"
                                                  style="display: inline;">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-sm btn-outline-danger">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="7" class="text-center py-4">
                                        <p class="mb-0">No tax rates found</p>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <?php echo e($taxRates->links()); ?>

                </div>
            </div>

            <!-- Information Card -->
            <div class="card mt-4">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0"><i class="fas fa-info-circle"></i> Australian Tax Information</h5>
                </div>
                <div class="card-body">
                    <p>The Goods and Services Tax (GST) in Australia is a broad-based tax of 10% on most goods, services, and other items sold or consumed in Australia.</p>
                    <ul>
                        <li>Standard GST rate: <strong>10%</strong></li>
                        <li>GST-free items may include basic food, some education and health services, etc.</li>
                        <li>All prices should be displayed as GST-inclusive for consumers</li>
                        <li>Businesses with annual turnover of $75,000+ must register for GST</li>
                    </ul>
                    <p class="mb-0"><small>Note: This system allows you to configure different tax rates for different cities if needed, though GST is typically uniform across Australia.</small></p>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.querySelectorAll('.toggle-active').forEach(function(toggle) {
    toggle.addEventListener('change', function() {
        const rateId = this.dataset.id;
        
        fetch(`/admin/tax-rates/${rateId}/toggle-active`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'Content-Type': 'application/json',
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (!data.success) {
                this.checked = !this.checked;
                alert('Failed to update status');
            }
        });
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\export-portfolio7\resources\views/admin/tax-rates/index.blade.php ENDPATH**/ ?>