<?php $__env->startSection('title', 'Community Spotlight - Featured Style Stars | Edition By Punjab'); ?>

<?php $__env->startSection('meta'); ?>
<meta name="description" content="Discover our monthly featured community members who showcase exceptional style with Edition By Punjab streetwear across Australia.">
<meta name="keywords" content="community spotlight, featured customers, style stars, streetwear influencers, edition by punjab community">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php if (isset($component)) { $__componentOriginal269900abaed345884ce342681cdc99f6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal269900abaed345884ce342681cdc99f6 = $attributes; } ?>
<?php $component = App\View\Components\Breadcrumb::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Breadcrumb::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal269900abaed345884ce342681cdc99f6)): ?>
<?php $attributes = $__attributesOriginal269900abaed345884ce342681cdc99f6; ?>
<?php unset($__attributesOriginal269900abaed345884ce342681cdc99f6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal269900abaed345884ce342681cdc99f6)): ?>
<?php $component = $__componentOriginal269900abaed345884ce342681cdc99f6; ?>
<?php unset($__componentOriginal269900abaed345884ce342681cdc99f6); ?>
<?php endif; ?>

<!-- Premium Spotlight Hero -->
<section class="spotlight-hero-premium">
    <div class="hero-pattern"></div>
    <div class="container">
        <div class="hero-content-center" data-aos="fade-up">
            <span class="hero-label">SPOTLIGHT</span>
            <h1 class="hero-title-premium">COMMUNITY STARS</h1>
            <p class="hero-subtitle">Celebrating the most inspiring style creators in our Australian community</p>
        </div>
    </div>
    <div class="scroll-indicator">
        <span></span>
    </div>
</section>

<!-- Featured Customer Spotlights -->
<?php $__currentLoopData = $spotlights; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $spotlight): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<section class="customer-spotlight-premium <?php echo e($index % 2 == 0 ? 'left-spotlight' : 'right-spotlight'); ?>">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6 <?php echo e($index % 2 == 0 ? '' : 'order-lg-2'); ?>" data-aos="fade-<?php echo e($index % 2 == 0 ? 'right' : 'left'); ?>">
                <div class="spotlight-image-wrapper">
                    <div class="spotlight-badge">
                        <span class="badge-text">FEATURED</span>
                        <div class="badge-icon">
                            <i class="fas fa-star"></i>
                        </div>
                    </div>
                    <?php if (isset($component)) { $__componentOriginal1238c9c115275474af734e9c338ceaf4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1238c9c115275474af734e9c338ceaf4 = $attributes; } ?>
<?php $component = App\View\Components\LazyImage::resolve(['src' => ''.e($spotlight['image']).'','alt' => ''.e($spotlight['name']).' - Community Spotlight','class' => 'spotlight-image'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('lazy-image'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\LazyImage::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['loading' => 'lazy']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $attributes = $__attributesOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__attributesOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $component = $__componentOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__componentOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
                    <div class="image-frame"></div>
                </div>
            </div>
            
            <div class="col-lg-6 <?php echo e($index % 2 == 0 ? '' : 'order-lg-1'); ?>" data-aos="fade-<?php echo e($index % 2 == 0 ? 'left' : 'right'); ?>">
                <div class="spotlight-content">
                    <div class="spotlight-header">
                        <h2 class="spotlight-name"><?php echo e($spotlight['name']); ?></h2>
                        <p class="spotlight-location">
                            <i class="fas fa-map-marker-alt"></i><?php echo e($spotlight['location']); ?>

                        </p>
                        <?php if(isset($spotlight['instagram'])): ?>
                            <a href="https://instagram.com/<?php echo e(ltrim($spotlight['instagram'], '@')); ?>" class="instagram-handle" target="_blank" rel="noopener">
                                <i class="fab fa-instagram"></i><?php echo e($spotlight['instagram']); ?>

                            </a>
                        <?php endif; ?>
                    </div>
                    
                    <div class="spotlight-story">
                        <h3 class="story-title">Their Story</h3>
                        <p class="story-text"><?php echo e($spotlight['story']); ?></p>
                    </div>
                    
                    <div class="spotlight-details">
                        <div class="detail-item">
                            <h4 class="detail-title">Favorite Piece</h4>
                            <p class="detail-text"><?php echo e($spotlight['favorite_piece']); ?></p>
                        </div>
                        
                        <div class="detail-item">
                            <h4 class="detail-title">Style Tip</h4>
                            <p class="detail-text">"<?php echo e($spotlight['style_tip']); ?>"</p>
                        </div>
                    </div>
                    
                    <div class="spotlight-actions">
                        <a href="<?php echo e(route('community.submit')); ?>" class="btn-spotlight-action primary">
                            <span>SUBMIT YOUR STYLE</span>
                            <i class="fas fa-upload"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<!-- Monthly Winner Banner -->
<section class="winner-banner-premium">
    <div class="container">
        <div class="banner-content" data-aos="zoom-in">
            <div class="winner-trophy">
                <i class="fas fa-trophy"></i>
            </div>
            <h2 class="banner-title">Monthly Style Champion</h2>
            <p class="banner-subtitle">Each month we celebrate one outstanding community member who embodies the Edition By Punjab spirit</p>
            <div class="winner-stats">
                <div class="stat-item">
                    <span class="stat-number">$500</span>
                    <span class="stat-label">Voucher Prize</span>
                </div>
                <div class="stat-item">
                    <span class="stat-number">50K+</span>
                    <span class="stat-label">Social Reach</span>
                </div>
                <div class="stat-item">
                    <span class="stat-number">1 Year</span>
                    <span class="stat-label">Free Products</span>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- How to Get Featured -->
<section class="featured-guide-premium">
    <div class="container">
        <div class="section-header-premium" data-aos="fade-up">
            <span class="section-label-premium">GET FEATURED</span>
            <h2 class="section-title-premium">How to Become a Style Star</h2>
            <p class="section-subtitle">Follow these steps to increase your chances of being featured in our spotlight</p>
        </div>
        
        <div class="guide-steps-premium">
            <div class="step-item-premium" data-aos="fade-up" data-aos-delay="0">
                <div class="step-icon-premium">
                    <span class="step-number">1</span>
                    <i class="fas fa-camera-retro"></i>
                </div>
                <div class="step-content-premium">
                    <h4 class="step-title">Share Authentic Style</h4>
                    <p class="step-text">Post genuine photos showcasing your unique way of styling Edition By Punjab pieces. Authenticity beats perfection every time.</p>
                </div>
            </div>
            
            <div class="step-item-premium" data-aos="fade-up" data-aos-delay="100">
                <div class="step-icon-premium">
                    <span class="step-number">2</span>
                    <i class="fas fa-hashtag"></i>
                </div>
                <div class="step-content-premium">
                    <h4 class="step-title">Use Our Hashtag</h4>
                    <p class="step-text">Tag your posts with #EditionByPunjabStyle and mention @editionbypunjab to get noticed by our community team.</p>
                </div>
            </div>
            
            <div class="step-item-premium" data-aos="fade-up" data-aos-delay="200">
                <div class="step-icon-premium">
                    <span class="step-number">3</span>
                    <i class="fas fa-users"></i>
                </div>
                <div class="step-content-premium">
                    <h4 class="step-title">Engage with Community</h4>
                    <p class="step-text">Like, comment, and support other community members. We love featuring people who actively engage with our family.</p>
                </div>
            </div>
            
            <div class="step-item-premium" data-aos="fade-up" data-aos-delay="300">
                <div class="step-icon-premium">
                    <span class="step-number">4</span>
                    <i class="fas fa-heart"></i>
                </div>
                <div class="step-content-premium">
                    <h4 class="step-title">Tell Your Story</h4>
                    <p class="step-text">Share the story behind your style. What inspired your look? How does Edition By Punjab fit into your lifestyle?</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Community Stats -->
<section class="community-stats-premium">
    <div class="container">
        <div class="stats-wrapper" data-aos="fade-up">
            <h2 class="stats-title">Our Growing Community</h2>
            <div class="stats-grid">
                <div class="stat-card-premium" data-aos="zoom-in" data-aos-delay="0">
                    <div class="stat-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="stat-number" data-count="2500">0</div>
                    <div class="stat-label">Active Members</div>
                </div>
                
                <div class="stat-card-premium" data-aos="zoom-in" data-aos-delay="100">
                    <div class="stat-icon">
                        <i class="fas fa-images"></i>
                    </div>
                    <div class="stat-number" data-count="847">0</div>
                    <div class="stat-label">Photos Shared</div>
                </div>
                
                <div class="stat-card-premium" data-aos="zoom-in" data-aos-delay="200">
                    <div class="stat-icon">
                        <i class="fas fa-heart"></i>
                    </div>
                    <div class="stat-number" data-count="15600">0</div>
                    <div class="stat-label">Likes Given</div>
                </div>
                
                <div class="stat-card-premium" data-aos="zoom-in" data-aos-delay="300">
                    <div class="stat-icon">
                        <i class="fas fa-star"></i>
                    </div>
                    <div class="stat-number" data-count="24">0</div>
                    <div class="stat-label">Featured Stars</div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Join Community CTA -->
<section class="join-community-premium">
    <div class="container">
        <div class="cta-wrapper" data-aos="fade-up">
            <div class="cta-content">
                <div class="cta-icon">
                    <i class="fas fa-rocket"></i>
                </div>
                <h2 class="cta-title">Ready to Shine?</h2>
                <p class="cta-text">Join our community of style innovators and show Australia how Edition By Punjab fits into your unique story</p>
                <div class="cta-buttons">
                    <a href="<?php echo e(route('community.submit')); ?>" class="btn-spotlight-cta primary">
                        <span>SUBMIT YOUR STYLE</span>
                        <i class="fas fa-paper-plane"></i>
                    </a>
                    <a href="<?php echo e(route('community.gallery')); ?>" class="btn-spotlight-cta secondary">
                        <span>BROWSE GALLERY</span>
                        <i class="fas fa-images"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<?php $__env->startPush('styles'); ?>
<style>
    /* Premium Spotlight Hero */
    .spotlight-hero-premium {
        min-height: 80vh;
        background: linear-gradient(135deg, var(--primary-black) 0%, var(--secondary-black) 100%);
        position: relative;
        display: flex;
        align-items: center;
        overflow: hidden;
    }
    
    .spotlight-hero-premium .hero-pattern::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: 
            radial-gradient(circle at 20% 80%, rgba(255, 215, 0, 0.2) 0%, transparent 50%),
            radial-gradient(circle at 80% 20%, rgba(255, 119, 198, 0.2) 0%, transparent 50%);
    }
    
    .hero-content-center {
        text-align: center;
        position: relative;
        z-index: 2;
    }
    
    .hero-label {
        display: inline-block;
        font-size: 0.8rem;
        font-weight: 700;
        letter-spacing: 0.2em;
        color: rgba(255,255,255,0.7);
        text-transform: uppercase;
        margin-bottom: 1rem;
    }
    
    .hero-title-premium {
        font-size: clamp(2.5rem, 6vw, 4.5rem);
        font-weight: 900;
        color: white;
        margin-bottom: 1.5rem;
        line-height: 0.9;
        text-shadow: 0 4px 20px rgba(0,0,0,0.3);
        font-family: 'Space Grotesk', sans-serif;
        letter-spacing: -0.02em;
    }
    
    .hero-subtitle {
        font-size: 1.1rem;
        color: rgba(255,255,255,0.8);
        margin-bottom: 2rem;
        line-height: 1.6;
        max-width: 600px;
        margin-left: auto;
        margin-right: auto;
    }
    
    .scroll-indicator {
        position: absolute;
        bottom: 2rem;
        left: 50%;
        transform: translateX(-50%);
        color: white;
    }
    
    .scroll-indicator span {
        display: block;
        width: 2px;
        height: 30px;
        background: white;
        animation: scroll-bounce 2s infinite;
    }
    
    @keyframes scroll-bounce {
        0%, 20%, 50%, 80%, 100% {
            transform: translateY(0);
        }
        40% {
            transform: translateY(-10px);
        }
        60% {
            transform: translateY(-5px);
        }
    }
    
    /* Customer Spotlight Sections */
    .customer-spotlight-premium {
        padding: 120px 0;
        position: relative;
    }
    
    .customer-spotlight-premium.left-spotlight {
        background: white;
    }
    
    .customer-spotlight-premium.right-spotlight {
        background: var(--bg-gray);
    }
    
    .spotlight-image-wrapper {
        position: relative;
        max-width: 500px;
        margin: 0 auto;
    }
    
    .spotlight-badge {
        position: absolute;
        top: -20px;
        right: -20px;
        background: linear-gradient(135deg, #ffd700, #ffb347);
        color: var(--primary-black);
        padding: 1rem 2rem;
        font-weight: 700;
        font-size: 0.9rem;
        text-transform: uppercase;
        letter-spacing: 0.05em;
        z-index: 2;
        display: flex;
        align-items: center;
        gap: 0.5rem;
        box-shadow: var(--shadow-lg);
    }
    
    .badge-icon {
        font-size: 1.2rem;
    }
    
    .spotlight-image {
        width: 100%;
        height: 600px;
        object-fit: cover;
        position: relative;
        z-index: 1;
        filter: grayscale(20%);
        transition: all var(--transition-slow);
    }
    
    .spotlight-image-wrapper:hover .spotlight-image {
        filter: grayscale(0%);
        transform: scale(1.02);
    }
    
    .image-frame {
        position: absolute;
        top: 20px;
        left: 20px;
        right: 20px;
        bottom: 20px;
        border: 3px solid rgba(255,255,255,0.3);
        pointer-events: none;
        z-index: 2;
        transition: all var(--transition-base);
    }
    
    .spotlight-image-wrapper:hover .image-frame {
        border-color: rgba(255,255,255,0.6);
        transform: translate(-10px, -10px);
    }
    
    .spotlight-content {
        padding: 2rem 0;
    }
    
    .spotlight-header {
        margin-bottom: 3rem;
    }
    
    .spotlight-name {
        font-size: 3rem;
        font-weight: 900;
        color: var(--primary-black);
        margin-bottom: 1rem;
        font-family: 'Space Grotesk', sans-serif;
    }
    
    .spotlight-location {
        font-size: 1.1rem;
        color: var(--medium-gray);
        margin-bottom: 1rem;
    }
    
    .spotlight-location i {
        margin-right: 0.5rem;
        color: var(--accent-red);
    }
    
    .instagram-handle {
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
        color: #e4405f;
        text-decoration: none;
        font-weight: 600;
        transition: opacity var(--transition-base);
    }
    
    .instagram-handle:hover {
        opacity: 0.8;
        color: #e4405f;
    }
    
    .spotlight-story {
        margin-bottom: 3rem;
    }
    
    .story-title {
        font-size: 1.5rem;
        font-weight: 700;
        color: var(--primary-black);
        margin-bottom: 1rem;
        font-family: 'Space Grotesk', sans-serif;
    }
    
    .story-text {
        font-size: 1.1rem;
        color: var(--medium-gray);
        line-height: 1.8;
    }
    
    .spotlight-details {
        margin-bottom: 3rem;
    }
    
    .detail-item {
        margin-bottom: 2rem;
        padding: 1.5rem 0;
        border-left: 4px solid var(--primary-black);
        padding-left: 2rem;
    }
    
    .detail-title {
        font-size: 1.2rem;
        font-weight: 700;
        color: var(--primary-black);
        margin-bottom: 0.5rem;
        font-family: 'Space Grotesk', sans-serif;
    }
    
    .detail-text {
        color: var(--medium-gray);
        line-height: 1.6;
        font-style: italic;
    }
    
    .spotlight-actions {
        margin-top: 3rem;
    }
    
    /* Winner Banner */
    .winner-banner-premium {
        padding: 120px 0;
        background: linear-gradient(135deg, var(--primary-black) 0%, var(--secondary-black) 100%);
        color: white;
        text-align: center;
    }
    
    .winner-trophy {
        font-size: 4rem;
        color: #ffd700;
        margin-bottom: 2rem;
        animation: trophy-glow 2s ease-in-out infinite alternate;
    }
    
    @keyframes trophy-glow {
        from {
            text-shadow: 0 0 20px rgba(255, 215, 0, 0.5);
        }
        to {
            text-shadow: 0 0 30px rgba(255, 215, 0, 0.8), 0 0 40px rgba(255, 215, 0, 0.6);
        }
    }
    
    .banner-title {
        font-size: 3rem;
        font-weight: 900;
        margin-bottom: 1.5rem;
        font-family: 'Space Grotesk', sans-serif;
    }
    
    .banner-subtitle {
        font-size: 1.2rem;
        color: rgba(255,255,255,0.8);
        margin-bottom: 3rem;
        max-width: 600px;
        margin-left: auto;
        margin-right: auto;
    }
    
    .winner-stats {
        display: flex;
        justify-content: center;
        gap: 4rem;
        flex-wrap: wrap;
    }
    
    .winner-stats .stat-item {
        text-align: center;
    }
    
    .winner-stats .stat-number {
        font-size: 2.5rem;
        font-weight: 900;
        color: #ffd700;
        display: block;
        font-family: 'Space Grotesk', sans-serif;
    }
    
    .winner-stats .stat-label {
        font-size: 0.9rem;
        font-weight: 600;
        color: rgba(255,255,255,0.8);
        text-transform: uppercase;
        letter-spacing: 0.1em;
    }
    
    /* Featured Guide */
    .featured-guide-premium {
        padding: 120px 0;
        background: white;
    }
    
    .section-header-premium {
        text-align: center;
        margin-bottom: 80px;
    }
    
    .section-label-premium {
        display: inline-block;
        font-size: 0.8rem;
        font-weight: 700;
        letter-spacing: 0.2em;
        color: var(--medium-gray);
        text-transform: uppercase;
        margin-bottom: 1rem;
    }
    
    .section-title-premium {
        font-size: clamp(2.5rem, 5vw, 4rem);
        font-weight: 800;
        color: var(--primary-black);
        margin-bottom: 1.5rem;
        line-height: 1.2;
        font-family: 'Space Grotesk', sans-serif;
    }
    
    .section-subtitle {
        font-size: 1.1rem;
        color: var(--medium-gray);
        line-height: 1.6;
        max-width: 600px;
        margin: 0 auto;
    }
    
    .guide-steps-premium {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 3rem;
    }
    
    .step-item-premium {
        text-align: center;
        padding: 3rem 2rem;
        background: var(--bg-gray);
        transition: all var(--transition-base);
        position: relative;
    }
    
    .step-item-premium:hover {
        transform: translateY(-10px);
        box-shadow: var(--shadow-lg);
        background: white;
    }
    
    .step-icon-premium {
        position: relative;
        margin-bottom: 2rem;
    }
    
    .step-number {
        position: absolute;
        top: -10px;
        right: -10px;
        background: var(--primary-black);
        color: white;
        width: 30px;
        height: 30px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 700;
        font-size: 0.9rem;
        z-index: 2;
    }
    
    .step-icon-premium i {
        font-size: 3rem;
        color: var(--primary-black);
    }
    
    .step-title {
        font-size: 1.3rem;
        font-weight: 700;
        color: var(--primary-black);
        margin-bottom: 1rem;
        font-family: 'Space Grotesk', sans-serif;
    }
    
    .step-text {
        color: var(--medium-gray);
        line-height: 1.6;
    }
    
    /* Community Stats */
    .community-stats-premium {
        padding: 120px 0;
        background: var(--bg-gray);
    }
    
    .stats-title {
        text-align: center;
        font-size: 2.5rem;
        font-weight: 800;
        color: var(--primary-black);
        margin-bottom: 4rem;
        font-family: 'Space Grotesk', sans-serif;
    }
    
    .stats-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 3rem;
    }
    
    .stat-card-premium {
        background: white;
        padding: 3rem 2rem;
        text-align: center;
        box-shadow: var(--shadow-md);
        transition: all var(--transition-base);
    }
    
    .stat-card-premium:hover {
        transform: translateY(-10px);
        box-shadow: var(--shadow-xl);
    }
    
    .stat-icon {
        font-size: 3rem;
        color: var(--primary-black);
        margin-bottom: 2rem;
    }
    
    .stat-number {
        font-size: 3rem;
        font-weight: 900;
        color: var(--primary-black);
        display: block;
        font-family: 'Space Grotesk', sans-serif;
        margin-bottom: 1rem;
    }
    
    .stat-label {
        font-size: 1rem;
        font-weight: 600;
        color: var(--medium-gray);
        text-transform: uppercase;
        letter-spacing: 0.1em;
    }
    
    /* Join Community CTA */
    .join-community-premium {
        padding: 120px 0;
        background: linear-gradient(135deg, var(--primary-black) 0%, var(--secondary-black) 100%);
        color: white;
    }
    
    .cta-wrapper {
        text-align: center;
        max-width: 800px;
        margin: 0 auto;
    }
    
    .cta-icon {
        font-size: 4rem;
        margin-bottom: 2rem;
        color: white;
    }
    
    .cta-title {
        font-size: 3rem;
        font-weight: 900;
        margin-bottom: 1.5rem;
        font-family: 'Space Grotesk', sans-serif;
    }
    
    .cta-text {
        font-size: 1.2rem;
        color: rgba(255,255,255,0.8);
        margin-bottom: 3rem;
        line-height: 1.6;
    }
    
    .cta-buttons {
        display: flex;
        gap: 2rem;
        justify-content: center;
        flex-wrap: wrap;
    }
    
    .btn-spotlight-action,
    .btn-spotlight-cta {
        display: inline-flex;
        align-items: center;
        gap: 0.75rem;
        padding: 1rem 2.5rem;
        font-weight: 600;
        font-size: 0.9rem;
        letter-spacing: 0.05em;
        text-transform: uppercase;
        text-decoration: none;
        transition: all var(--transition-base);
        position: relative;
        overflow: hidden;
        border-radius: 0;
    }
    
    .btn-spotlight-action.primary {
        background: var(--primary-black);
        color: white;
        border: 2px solid var(--primary-black);
    }
    
    .btn-spotlight-action.primary:hover {
        background: transparent;
        color: var(--primary-black);
        transform: translateY(-3px);
        box-shadow: 0 10px 30px rgba(0,0,0,0.2);
    }
    
    .btn-spotlight-cta.primary {
        background: white;
        color: var(--primary-black);
        border: 2px solid white;
    }
    
    .btn-spotlight-cta.primary:hover {
        background: transparent;
        color: white;
        border-color: white;
        transform: translateY(-3px);
        box-shadow: 0 10px 30px rgba(255,255,255,0.2);
    }
    
    .btn-spotlight-cta.secondary {
        background: transparent;
        color: white;
        border: 2px solid white;
    }
    
    .btn-spotlight-cta.secondary:hover {
        background: white;
        color: var(--primary-black);
        border-color: white;
        transform: translateY(-3px);
        box-shadow: 0 10px 30px rgba(255,255,255,0.2);
    }
    
    /* Responsive */
    @media (max-width: 768px) {
        .spotlight-name {
            font-size: 2rem;
        }
        
        .banner-title {
            font-size: 2rem;
        }
        
        .cta-title {
            font-size: 2rem;
        }
        
        .winner-stats {
            gap: 2rem;
        }
        
        .guide-steps-premium {
            gap: 2rem;
        }
        
        .stats-grid {
            gap: 2rem;
        }
        
        .cta-buttons {
            flex-direction: column;
            align-items: center;
        }
        
        .spotlight-content {
            padding: 2rem 0;
        }
    }
    
    @media (max-width: 480px) {
        .hero-title-premium {
            font-size: 2.5rem;
        }
        
        .spotlight-image {
            height: 400px;
        }
        
        .step-item-premium {
            padding: 2rem 1rem;
        }
        
        .stat-card-premium {
            padding: 2rem 1rem;
        }
        
        .detail-item {
            padding-left: 1rem;
        }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize AOS
    AOS.init({
        duration: 1000,
        easing: 'ease-out-cubic',
        once: true,
        offset: 100
    });
    
    // Counter animation for stats
    const counters = document.querySelectorAll('.stat-number');
    counters.forEach(counter => {
        const target = parseInt(counter.getAttribute('data-count'));
        const increment = target / 60;
        let current = 0;
        
        const updateCounter = () => {
            if (current < target) {
                current += increment;
                counter.textContent = Math.floor(current);
                requestAnimationFrame(updateCounter);
            } else {
                counter.textContent = target;
            }
        };
        
        // Start animation when element comes into view
        const observer = new IntersectionObserver((entries) => {
            if (entries[0].isIntersecting) {
                updateCounter();
                observer.disconnect();
            }
        });
        
        observer.observe(counter);
    });
    
    // Spotlight image hover effect
    const spotlightImages = document.querySelectorAll('.spotlight-image-wrapper');
    spotlightImages.forEach(wrapper => {
        wrapper.addEventListener('mouseenter', function() {
            this.style.transform = 'scale(1.02)';
        });
        
        wrapper.addEventListener('mouseleave', function() {
            this.style.transform = 'scale(1)';
        });
    });
    
    // Parallax effect for hero section
    window.addEventListener('scroll', function() {
        const scrolled = window.pageYOffset;
        const rate = scrolled * -0.5;
        const heroPattern = document.querySelector('.hero-pattern');
        if (heroPattern) {
            heroPattern.style.transform = `translateY(${rate}px)`;
        }
    });
});
</script>
<?php $__env->stopPush(); ?>

<!-- JSON-LD for SEO -->
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "WebPage",
    "name": "Community Spotlight - Edition By Punjab",
    "description": "Discover our monthly featured community members who showcase exceptional style with Edition By Punjab streetwear across Australia",
    "url": "<?php echo e(route('community.spotlight')); ?>",
    "publisher": {
        "@type": "Organization",
        "name": "Edition By Punjab",
        "url": "<?php echo e(route('home')); ?>"
    },
    "mainEntity": {
        "@type": "ItemList",
        "name": "Featured Community Members",
        "itemListElement": [
            <?php $__currentLoopData = $spotlights; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $spotlight): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            {
                "@type": "Person",
                "position": <?php echo e($index + 1); ?>,
                "name": "<?php echo e($spotlight['name']); ?>",
                "address": {
                    "@type": "PostalAddress",
                    "addressLocality": "<?php echo e($spotlight['location']); ?>"
                },
                "image": "<?php echo e(asset('images/' . $spotlight['image'])); ?>"
            }<?php echo e(!$loop->last ? ',' : ''); ?>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        ]
    }
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\export-portfolio6\resources\views/community/spotlight.blade.php ENDPATH**/ ?>