<?php $__env->startSection('title', $pageData['meta_title']); ?>

<?php $__env->startSection('meta'); ?>
<meta name="description" content="<?php echo e($pageData['meta_description']); ?>">
<meta name="keywords" content="<?php echo e($pageData['keywords']); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php if (isset($component)) { $__componentOriginal269900abaed345884ce342681cdc99f6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal269900abaed345884ce342681cdc99f6 = $attributes; } ?>
<?php $component = App\View\Components\Breadcrumb::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Breadcrumb::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal269900abaed345884ce342681cdc99f6)): ?>
<?php $attributes = $__attributesOriginal269900abaed345884ce342681cdc99f6; ?>
<?php unset($__attributesOriginal269900abaed345884ce342681cdc99f6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal269900abaed345884ce342681cdc99f6)): ?>
<?php $component = $__componentOriginal269900abaed345884ce342681cdc99f6; ?>
<?php unset($__componentOriginal269900abaed345884ce342681cdc99f6); ?>
<?php endif; ?>

<!-- Hero Section -->
<section class="guide-hero py-5" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8">
                <h1 class="display-4 text-white fw-bold mb-4"><?php echo e($pageData['hero_title']); ?></h1>
                <p class="h4 text-light mb-4"><?php echo e($pageData['hero_subtitle']); ?></p>
                <p class="lead text-white mb-4">Everything you need to know about buying authentic streetwear in Australia - from the best online stores to local boutiques, budget tips to premium finds.</p>
                <div class="guide-stats d-flex gap-4 text-white">
                    <div class="stat-item">
                        <div class="stat-number h4 mb-0">50+</div>
                        <small>Shopping Options</small>
                    </div>
                    <div class="stat-item">
                        <div class="stat-number h4 mb-0">8</div>
                        <small>Major Cities</small>
                    </div>
                    <div class="stat-item">
                        <div class="stat-number h4 mb-0">100+</div>
                        <small>Expert Tips</small>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="hero-image">
                    <?php if (isset($component)) { $__componentOriginal1238c9c115275474af734e9c338ceaf4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1238c9c115275474af734e9c338ceaf4 = $attributes; } ?>
<?php $component = App\View\Components\LazyImage::resolve(['src' => 'guides/streetwear-shopping-australia.jpg','alt' => 'Where to buy streetwear in Australia','class' => 'img-fluid rounded shadow-lg'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('lazy-image'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\LazyImage::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $attributes = $__attributesOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__attributesOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $component = $__componentOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__componentOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Online Stores -->
<section class="online-stores py-5">
    <div class="container">
        <div class="row">
            <div class="col-12 mb-5">
                <h2 class="text-center mb-4">Best Online Streetwear Stores in Australia</h2>
                <p class="text-center text-muted lead">Shop from home with these trusted Australian streetwear retailers</p>
            </div>
        </div>
        
        <div class="row g-4">
            <?php $__currentLoopData = $pageData['online_stores']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $store): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-4 col-md-6">
                    <div class="store-card h-100 bg-white rounded-lg shadow-sm p-4 border-2 border-transparent">
                        <?php if($store['name'] === 'Edition By Punjab'): ?>
                            <div class="featured-badge position-absolute top-0 end-0 m-3">
                                <span class="badge bg-primary">Recommended</span>
                            </div>
                        <?php endif; ?>
                        
                        <div class="store-header mb-3">
                            <h4 class="store-name <?php echo e($store['name'] === 'Edition By Punjab' ? 'text-primary' : ''); ?>">
                                <?php echo e($store['name']); ?>

                            </h4>
                            <p class="store-specialty text-muted">
                                <i class="fas fa-tag me-2"></i><?php echo e($store['speciality']); ?>

                            </p>
                        </div>
                        
                        <p class="store-description mb-3"><?php echo e($store['description']); ?></p>
                        
                        <?php if(isset($store['shipping'])): ?>
                            <div class="store-shipping mb-3 p-3 bg-light rounded">
                                <small class="fw-bold text-success">
                                    <i class="fas fa-shipping-fast me-2"></i><?php echo e($store['shipping']); ?>

                                </small>
                            </div>
                        <?php endif; ?>
                        
                        <?php if(isset($store['unique_selling'])): ?>
                            <div class="store-unique mb-3">
                                <strong>Why Choose:</strong> <?php echo e($store['unique_selling']); ?>

                            </div>
                        <?php endif; ?>
                        
                        <?php if(isset($store['pros'])): ?>
                            <div class="store-pros">
                                <strong>Pros:</strong>
                                <ul class="mb-0 mt-2">
                                    <?php $__currentLoopData = $store['pros']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($pro); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                        
                        <?php if($store['name'] === 'Edition By Punjab'): ?>
                            <div class="mt-3">
                                <a href="<?php echo e(route('shop.index')); ?>" class="btn btn-primary w-100">
                                    Shop Now <i class="fas fa-arrow-right ms-2"></i>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<!-- Physical Locations -->
<section class="physical-locations py-5 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-12 mb-5">
                <h2 class="text-center mb-4">Best Physical Stores by City</h2>
                <p class="text-center text-muted">Discover streetwear hotspots across Australia's major cities</p>
            </div>
        </div>
        
        <div class="row g-4">
            <?php $__currentLoopData = $pageData['physical_locations']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-6 col-md-6">
                    <div class="location-card h-100 bg-white rounded-lg shadow-sm p-4">
                        <div class="location-header mb-3">
                            <h4 class="city-name text-primary mb-2">
                                <i class="fas fa-map-marker-alt me-2"></i><?php echo e($location['city']); ?>

                            </h4>
                            <small class="text-muted">Best for: <?php echo e($location['best_for']); ?></small>
                        </div>
                        
                        <div class="shopping-areas">
                            <h6 class="mb-3">Top Shopping Areas:</h6>
                            <div class="row g-2">
                                <?php $__currentLoopData = $location['areas']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-6">
                                        <span class="badge bg-light text-dark w-100 p-2"><?php echo e($area); ?></span>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        
                        <?php if($location['city'] === 'Melbourne'): ?>
                            <div class="mt-3">
                                <a href="<?php echo e(route('city.melbourne')); ?>" class="btn btn-outline-primary btn-sm">
                                    Melbourne Style Guide <i class="fas fa-external-link-alt ms-1"></i>
                                </a>
                            </div>
                        <?php endif; ?>
                        
                        <?php if($location['city'] === 'Sydney'): ?>
                            <div class="mt-3">
                                <a href="<?php echo e(route('city.sydney')); ?>" class="btn btn-outline-primary btn-sm">
                                    Sydney Fashion Guide <i class="fas fa-external-link-alt ms-1"></i>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<!-- Shopping Tips -->
<section class="shopping-tips py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <h2 class="text-center mb-5">Essential Australian Streetwear Shopping Tips</h2>
                <div class="tips-grid">
                    <?php $__currentLoopData = $pageData['shopping_tips']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $tip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="tip-item mb-4 p-4 bg-light rounded-lg d-flex align-items-start">
                            <div class="tip-number bg-primary text-white rounded-circle me-3 d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                <span class="fw-bold"><?php echo e($index + 1); ?></span>
                            </div>
                            <div class="tip-content">
                                <p class="mb-0"><?php echo e($tip); ?></p>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Budget Guide -->
<section class="budget-guide py-5 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-12 mb-5">
                <h2 class="text-center mb-4">Australian Streetwear Budget Guide</h2>
                <p class="text-center text-muted">Understanding price ranges for different streetwear categories</p>
            </div>
        </div>
        
        <div class="row g-4">
            <?php $__currentLoopData = $pageData['budget_ranges']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $budget): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-4 col-md-6">
                    <div class="budget-card h-100 bg-white rounded-lg shadow-sm p-4 text-center">
                        <div class="budget-range mb-3">
                            <h3 class="text-primary mb-0"><?php echo e($budget['range']); ?></h3>
                            <small class="text-muted">Australian Dollars</small>
                        </div>
                        
                        <div class="budget-items mb-3">
                            <h6 class="fw-bold mb-2">What You Get:</h6>
                            <p class="text-muted"><?php echo e($budget['items']); ?></p>
                        </div>
                        
                        <div class="budget-where">
                            <h6 class="fw-bold mb-2">Where to Shop:</h6>
                            <p class="text-muted mb-0"><?php echo e($budget['where']); ?></p>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<!-- Featured Recommendations -->
<section class="recommendations py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto text-center">
                <h2 class="mb-4">Our Top Recommendation</h2>
                <div class="recommendation-card p-5 bg-primary text-white rounded-lg">
                    <h3 class="mb-3">Edition By Punjab</h3>
                    <p class="lead mb-4">For authentic cultural fusion streetwear that celebrates Australian diversity while maintaining premium quality and sustainable practices.</p>
                    <div class="recommendation-features mb-4">
                        <div class="row">
                            <div class="col-md-4 mb-2">
                                <i class="fas fa-leaf fa-2x mb-2"></i>
                                <div>Sustainable Materials</div>
                            </div>
                            <div class="col-md-4 mb-2">
                                <i class="fas fa-heart fa-2x mb-2"></i>
                                <div>Cultural Authenticity</div>
                            </div>
                            <div class="col-md-4 mb-2">
                                <i class="fas fa-shipping-fast fa-2x mb-2"></i>
                                <div>Free AU Shipping</div>
                            </div>
                        </div>
                    </div>
                    <a href="<?php echo e(route('shop.index')); ?>" class="btn btn-light btn-lg">
                        Start Shopping <i class="fas fa-arrow-right ms-2"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<?php $__env->startPush('styles'); ?>
<style>
    .guide-hero {
        min-height: 600px;
        display: flex;
        align-items: center;
    }
    
    .store-card {
        position: relative;
        transition: transform 0.3s ease, border-color 0.3s ease;
    }
    
    .store-card:hover {
        transform: translateY(-5px);
        border-color: #007bff !important;
    }
    
    .store-card:has(.featured-badge) {
        border-color: #007bff !important;
        background: linear-gradient(135deg, #fff 0%, #f8f9ff 100%);
    }
    
    .location-card {
        transition: transform 0.3s ease;
    }
    
    .location-card:hover {
        transform: translateY(-5px);
    }
    
    .tip-item {
        transition: transform 0.2s ease;
    }
    
    .tip-item:hover {
        transform: translateX(10px);
    }
    
    .budget-card {
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    
    .budget-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 20px 40px rgba(0,0,0,0.1);
    }
    
    .recommendation-card {
        background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
    }
    
    .rounded-lg {
        border-radius: 1rem;
    }
    
    .tip-number {
        flex-shrink: 0;
    }
    
    .featured-badge {
        z-index: 10;
    }
</style>
<?php $__env->stopPush(); ?>

<!-- JSON-LD for SEO -->
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "Article",
    "headline": "<?php echo e($pageData['hero_title']); ?>",
    "description": "<?php echo e($pageData['meta_description']); ?>",
    "image": "<?php echo e(asset('images/guides/streetwear-shopping-australia.jpg')); ?>",
    "author": {
        "@type": "Organization",
        "name": "Edition By Punjab"
    },
    "publisher": {
        "@type": "Organization",
        "name": "Edition By Punjab",
        "url": "<?php echo e(route('home')); ?>"
    },
    "datePublished": "<?php echo e(now()->toISOString()); ?>",
    "dateModified": "<?php echo e(now()->toISOString()); ?>",
    "mainEntityOfPage": {
        "@type": "WebPage",
        "@id": "<?php echo e(route('where-to-buy-streetwear')); ?>"
    },
    "about": {
        "@type": "Thing",
        "name": "Streetwear Shopping Australia",
        "description": "Complete guide to buying streetwear in Australia"
    }
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\export-portfolio6\resources\views/city-pages/where-to-buy-streetwear.blade.php ENDPATH**/ ?>