<?php $__env->startSection('title', 'Export Industry Blog - Latest News & Insights'); ?>
<?php $__env->startSection('meta_description', 'Stay updated with the latest trends, insights and news from the export industry in Australia. Expert advice for exporters and importers.'); ?>
<?php $__env->startSection('meta_keywords', 'export blog, australia export news, international trade insights, export tips, import export trends'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .blog-premium {
        min-height: 100vh;
        background: linear-gradient(135deg, #fafafa 0%, #f0f2f5 100%);
    }
    
    .blog-header-premium {
        background: linear-gradient(135deg, #000 0%, #1a1a1a 50%, #333 100%);
        color: white;
        padding: 8rem 0 5rem;
        position: relative;
        overflow: hidden;
    }
    
    .blog-header-premium::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="25" cy="25" r="1" fill="white" opacity="0.1"/><circle cx="75" cy="75" r="1" fill="white" opacity="0.05"/><circle cx="50" cy="10" r="0.5" fill="white" opacity="0.1"/><circle cx="10" cy="90" r="1" fill="white" opacity="0.05"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>') repeat;
        z-index: 1;
    }
    
    .blog-header-premium .container {
        position: relative;
        z-index: 2;
    }
    
    .blog-header-content {
        text-align: center;
        max-width: 800px;
        margin: 0 auto;
    }
    
    .blog-title {
        font-size: 4rem;
        font-weight: 900;
        letter-spacing: 0.1em;
        margin-bottom: 1.5rem;
        text-transform: uppercase;
        background: linear-gradient(45deg, #fff, #f0f0f0);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
    }
    
    .blog-subtitle {
        font-size: 1.25rem;
        font-weight: 300;
        letter-spacing: 0.05em;
        opacity: 0.9;
        margin-bottom: 3rem;
        line-height: 1.6;
    }
    
    .breadcrumb-premium {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 1rem;
        list-style: none;
        padding: 0;
        margin: 0;
        font-size: 0.875rem;
        font-weight: 500;
        letter-spacing: 0.1em;
    }
    
    .breadcrumb-premium a {
        color: rgba(255, 255, 255, 0.8);
        text-decoration: none;
        transition: all 0.3s ease;
    }
    
    .breadcrumb-premium a:hover {
        color: white;
    }
    
    .separator {
        color: rgba(255, 255, 255, 0.5);
    }
    
    .active {
        color: white;
        font-weight: 600;
    }
    
    .blog-toolbar-premium {
        background: white;
        padding: 2rem 0;
        border-bottom: 1px solid rgba(0, 0, 0, 0.05);
        position: sticky;
        top: 80px;
        z-index: 100;
        box-shadow: 0 2px 20px rgba(0, 0, 0, 0.08);
    }
    
    .toolbar-content {
        display: flex;
        justify-content: space-between;
        align-items: center;
        gap: 2rem;
    }
    
    .toolbar-left {
        display: flex;
        align-items: center;
        gap: 2rem;
    }
    
    .results-count {
        font-size: 0.875rem;
        font-weight: 600;
        letter-spacing: 0.1em;
        color: #666;
    }
    
    .search-form-premium {
        max-width: 400px;
        position: relative;
    }
    
    .search-input-premium {
        width: 100%;
        padding: 0.75rem 1rem;
        border: 2px solid #e0e0e0;
        border-radius: 0;
        font-size: 0.875rem;
        font-weight: 500;
        letter-spacing: 0.05em;
        background: #fafafa;
        transition: all 0.3s ease;
    }
    
    .search-input-premium:focus {
        outline: none;
        border-color: #000;
        background: white;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
    }
    
    .search-submit-premium {
        position: absolute;
        right: 0.5rem;
        top: 50%;
        transform: translateY(-50%);
        background: #000;
        color: white;
        border: none;
        padding: 0.5rem 1rem;
        cursor: pointer;
        transition: all 0.3s ease;
    }
    
    .search-submit-premium:hover {
        background: #333;
    }
    
    .blog-card-premium {
        background: white;
        border-radius: 0;
        border: none;
        overflow: hidden;
        transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
        margin-bottom: 2rem;
        position: relative;
    }
    
    .blog-card-premium::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: linear-gradient(90deg, #000 0%, #333 100%);
        opacity: 0;
        transition: opacity 0.3s ease;
    }
    
    .blog-card-premium:hover::before {
        opacity: 1;
    }
    
    .blog-card-premium:hover {
        transform: translateY(-10px);
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
    }
    
    .blog-image-premium {
        width: 100%;
        height: 250px;
        object-fit: cover;
        transition: all 0.5s ease;
    }
    
    .blog-card-premium:hover .blog-image-premium {
        transform: scale(1.05);
    }
    
    .blog-content-premium {
        padding: 2rem;
    }
    
    .blog-meta-premium {
        display: flex;
        align-items: center;
        gap: 1.5rem;
        margin-bottom: 1rem;
        font-size: 0.75rem;
        font-weight: 600;
        letter-spacing: 0.1em;
        text-transform: uppercase;
        color: #999;
    }
    
    .blog-meta-item {
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }
    
    .blog-meta-item i {
        color: #000;
    }
    
    .blog-title-premium {
        font-size: 1.5rem;
        font-weight: 700;
        line-height: 1.3;
        margin-bottom: 1rem;
        color: #000;
    }
    
    .blog-title-premium a {
        color: inherit;
        text-decoration: none;
        transition: color 0.3s ease;
    }
    
    .blog-title-premium a:hover {
        color: #666;
    }
    
    .blog-excerpt-premium {
        font-size: 1rem;
        line-height: 1.6;
        color: #666;
        margin-bottom: 1.5rem;
    }
    
    .blog-tags-premium {
        display: flex;
        flex-wrap: wrap;
        gap: 0.5rem;
        margin-bottom: 1.5rem;
    }
    
    .blog-tag {
        padding: 0.25rem 0.75rem;
        background: #f5f5f5;
        color: #666;
        font-size: 0.75rem;
        font-weight: 500;
        letter-spacing: 0.05em;
        text-decoration: none;
        transition: all 0.3s ease;
        border: 1px solid transparent;
    }
    
    .blog-tag:hover {
        background: #000;
        color: white;
        transform: translateY(-2px);
    }
    
    .blog-read-more {
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
        padding: 0.75rem 2rem;
        background: #000;
        color: white;
        text-decoration: none;
        font-size: 0.875rem;
        font-weight: 600;
        letter-spacing: 0.1em;
        text-transform: uppercase;
        transition: all 0.3s ease;
        position: relative;
        overflow: hidden;
    }
    
    .blog-read-more::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
        transition: left 0.5s ease;
    }
    
    .blog-read-more:hover::before {
        left: 100%;
    }
    
    .blog-read-more:hover {
        background: #333;
        color: white;
        transform: translateY(-2px);
    }
    
    .featured-blog-premium {
        background: linear-gradient(135deg, #000 0%, #1a1a1a 100%);
        color: white;
        border-radius: 0;
        overflow: hidden;
        margin-bottom: 4rem;
        position: relative;
    }
    
    .featured-blog-premium::after {
        content: 'FEATURED';
        position: absolute;
        top: 2rem;
        right: 2rem;
        padding: 0.5rem 1rem;
        background: rgba(255, 255, 255, 0.1);
        backdrop-filter: blur(10px);
        font-size: 0.75rem;
        font-weight: 700;
        letter-spacing: 0.15em;
        border: 1px solid rgba(255, 255, 255, 0.2);
    }
    
    .sidebar-premium {
        background: white;
        padding: 2rem;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
        margin-bottom: 2rem;
        position: sticky;
        top: 180px;
    }
    
    .sidebar-title {
        font-size: 1.25rem;
        font-weight: 700;
        letter-spacing: 0.05em;
        margin-bottom: 1.5rem;
        color: #000;
        text-transform: uppercase;
        padding-bottom: 1rem;
        border-bottom: 2px solid #f0f0f0;
    }
    
    .blog-meta {
        font-size: 0.875rem;
        color: var(--text-secondary);
        margin-bottom: 1rem;
    }
    
    .blog-meta i {
        margin-right: 0.5rem;
        color: var(--accent-color);
    }
    
    .tag-cloud .badge {
        margin: 0.25rem;
        padding: 0.5rem 0.75rem;
        background: var(--bg-secondary);
        color: var(--text-primary);
        text-decoration: none;
        border-radius: 20px;
        transition: var(--transition-fast);
    }
    
    .tag-cloud .badge:hover {
        background: var(--text-primary);
        color: white;
        transform: translateY(-2px);
    }
    
    .featured-blog {
        background: linear-gradient(45deg, var(--bg-secondary), white);
        padding: 2rem;
        border-radius: 12px;
        margin-bottom: 2rem;
    }
    
    .search-bar {
        max-width: 500px;
        margin: 0 auto;
    }
    
    .sidebar-widget {
        background: var(--bg-secondary);
        padding: 1.5rem;
        border-radius: 12px;
        margin-bottom: 2rem;
    }
    
    .sidebar-widget h5 {
        color: var(--text-primary);
        margin-bottom: 1rem;
        font-weight: 700;
    }
    
    .recent-post {
        display: flex;
        gap: 1rem;
        padding: 1rem 0;
        border-bottom: 1px solid var(--border-color);
    }
    
    .recent-post:last-child {
        border-bottom: none;
    }
    
    .recent-post img {
        width: 60px;
        height: 60px;
        object-fit: cover;
        border-radius: 8px;
    }
    
    .recent-post-content h6 {
        font-size: 0.875rem;
        line-height: 1.4;
        margin: 0;
    }
    
    .recent-post-content small {
        color: var(--text-secondary);
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="blog-premium">
    <!-- Blog Header -->
    <section class="blog-header-premium">
        <div class="container">
            <div class="blog-header-content">
                <h1 class="blog-title" data-aos="fade-up">EXPORT INSIGHTS</h1>
                <p class="blog-subtitle" data-aos="fade-up" data-aos-delay="100">
                    Your trusted source for Australian export trends, market insights, and industry expertise
                </p>
                <nav aria-label="breadcrumb" data-aos="fade-up" data-aos-delay="200">
                    <ol class="breadcrumb-premium">
                        <li><a href="<?php echo e(route('home')); ?>">HOME</a></li>
                        <li class="separator">/</li>
                        <li class="active">BLOG</li>
                    </ol>
                </nav>
            </div>
        </div>
    </section>

    <!-- Blog Toolbar -->
    <section class="blog-toolbar-premium">
        <div class="container">
            <div class="toolbar-content">
                <div class="toolbar-left">
                    <span class="results-count"><?php echo e($blogs->total()); ?> ARTICLES</span>
                </div>
                
                <div class="toolbar-right">
                    <form method="GET" action="<?php echo e(route('blogs.index')); ?>" class="search-form-premium">
                        <input type="text" class="search-input-premium" placeholder="Search articles..." name="search" value="<?php echo e(request('search')); ?>">
                        <button class="search-submit-premium" type="submit">
                            <i class="fas fa-search"></i>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </section>

    <!-- Featured Blogs -->
    <?php if($featuredBlogs->count() > 0): ?>
    <section class="py-5">
        <div class="container">
            <h2 class="text-center mb-5 section-title-premium" data-aos="fade-up">
                FEATURED ARTICLES
            </h2>
            <div class="row g-4">
                <?php $__currentLoopData = $featuredBlogs->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $featured): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-4" data-aos="fade-up" data-aos-delay="<?php echo e($loop->index * 100); ?>">
                    <article class="featured-blog-premium">
                        <?php if($featured->featured_image): ?>
                            <img src="<?php echo e(\App\Helpers\ImageHelper::getImageUrl($featured->featured_image)); ?>" 
                                 alt="<?php echo e($featured->title); ?>" 
                                 class="blog-image-premium">
                        <?php else: ?>
                            <div class="blog-image-placeholder" style="height: 250px; background: linear-gradient(135deg, #f0f0f0 0%, #e0e0e0 100%); display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-image fa-3x" style="color: #ccc;"></i>
                            </div>
                        <?php endif; ?>
                        
                        <div class="blog-content-premium">
                            <div class="blog-meta-premium">
                                <div class="blog-meta-item">
                                    <i class="fas fa-calendar"></i>
                                    <span><?php echo e($featured->readable_published_date); ?></span>
                                </div>
                                <div class="blog-meta-item">
                                    <i class="fas fa-clock"></i>
                                    <span><?php echo e($featured->estimated_read_time); ?> min</span>
                                </div>
                                <div class="blog-meta-item">
                                    <i class="fas fa-eye"></i>
                                    <span><?php echo e(number_format($featured->views)); ?></span>
                                </div>
                            </div>
                            
                            <h3 class="blog-title-premium">
                                <a href="<?php echo e(route('blogs.show', $featured->slug)); ?>">
                                    <?php echo e($featured->title); ?>

                                </a>
                            </h3>
                            
                            <p class="blog-excerpt-premium"><?php echo e($featured->excerpt); ?></p>
                            
                            <?php if($featured->tags): ?>
                            <div class="blog-tags-premium">
                                <?php $__currentLoopData = array_slice($featured->tags, 0, 3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a href="<?php echo e(route('blogs.index', ['tag' => $tag])); ?>" class="blog-tag"><?php echo e($tag); ?></a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <?php endif; ?>
                            
                            <a href="<?php echo e(route('blogs.show', $featured->slug)); ?>" class="blog-read-more">
                                READ ARTICLE
                                <i class="fas fa-arrow-right"></i>
                            </a>
                        </div>
                    </article>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <?php endif; ?>

    <!-- Main Blog Content -->
    <section class="py-5">
        <div class="container">
            <div class="row">
                <!-- Blog Posts -->
                <div class="col-lg-8">
                    <?php if($blogs->count() > 0): ?>
                        <div class="row g-4">
                            <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-6" data-aos="fade-up">
                                <article class="blog-card-premium">
                                    <?php if($blog->featured_image): ?>
                                        <img src="<?php echo e(\App\Helpers\ImageHelper::getImageUrl($blog->featured_image)); ?>" 
                                             alt="<?php echo e($blog->title); ?>" 
                                             class="blog-image-premium">
                                    <?php else: ?>
                                        <div class="blog-image-placeholder" style="height: 250px; background: linear-gradient(135deg, #f0f0f0 0%, #e0e0e0 100%); display: flex; align-items: center; justify-content: center;">
                                            <i class="fas fa-image fa-3x" style="color: #ccc;"></i>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <div class="blog-content-premium">
                                        <div class="blog-meta-premium">
                                            <div class="blog-meta-item">
                                                <i class="fas fa-calendar"></i>
                                                <span><?php echo e($blog->readable_published_date); ?></span>
                                            </div>
                                            <div class="blog-meta-item">
                                                <i class="fas fa-clock"></i>
                                                <span><?php echo e($blog->estimated_read_time); ?> min</span>
                                            </div>
                                            <div class="blog-meta-item">
                                                <i class="fas fa-eye"></i>
                                                <span><?php echo e(number_format($blog->views)); ?></span>
                                            </div>
                                        </div>
                                        
                                        <h2 class="blog-title-premium">
                                            <a href="<?php echo e(route('blogs.show', $blog->slug)); ?>">
                                                <?php echo e($blog->title); ?>

                                            </a>
                                        </h2>
                                        
                                        <p class="blog-excerpt-premium"><?php echo e($blog->excerpt); ?></p>
                                        
                                        <?php if($blog->tags): ?>
                                        <div class="blog-tags-premium">
                                            <?php $__currentLoopData = array_slice($blog->tags, 0, 2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <a href="<?php echo e(route('blogs.index', ['tag' => $tag])); ?>" class="blog-tag"><?php echo e($tag); ?></a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                        <?php endif; ?>
                                        
                                        <a href="<?php echo e(route('blogs.show', $blog->slug)); ?>" class="blog-read-more">
                                            READ ARTICLE
                                            <i class="fas fa-arrow-right"></i>
                                        </a>
                                    </div>
                                </article>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        
                        <!-- Pagination -->
                        <div class="d-flex justify-content-center mt-5">
                            <?php echo e($blogs->withQueryString()->links('pagination::bootstrap-4')); ?>

                        </div>
                    <?php else: ?>
                        <div class="text-center py-5" style="background: white; padding: 4rem 2rem; box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);">
                            <i class="fas fa-search fa-4x mb-4" style="color: #e0e0e0;"></i>
                            <h3 style="font-weight: 700; letter-spacing: 0.05em; margin-bottom: 1rem;">NO ARTICLES FOUND</h3>
                            <p class="text-muted mb-4"><?php echo e(request('search') ? 'No articles match your search criteria.' : 'No articles have been published yet.'); ?></p>
                            <?php if(request('search')): ?>
                                <a href="<?php echo e(route('blogs.index')); ?>" class="blog-read-more">VIEW ALL ARTICLES</a>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            
                <!-- Sidebar -->
                <div class="col-lg-4">
                    <!-- Recent Posts -->
                    <?php if($recentBlogs->count() > 0): ?>
                    <div class="sidebar-premium" data-aos="fade-up">
                        <h5 class="sidebar-title">
                            <i class="fas fa-clock me-2"></i>Recent Articles
                        </h5>
                        <?php $__currentLoopData = $recentBlogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="recent-post-premium" style="display: flex; gap: 1rem; padding: 1rem 0; border-bottom: 1px solid #f0f0f0;">
                            <?php if($recent->featured_image): ?>
                                <img src="<?php echo e(\App\Helpers\ImageHelper::getImageUrl($recent->featured_image)); ?>" 
                                     alt="<?php echo e($recent->title); ?>" 
                                     style="width: 80px; height: 80px; object-fit: cover; flex-shrink: 0;">
                            <?php else: ?>
                                <div style="width: 80px; height: 80px; background: linear-gradient(135deg, #f0f0f0 0%, #e0e0e0 100%); display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                                    <i class="fas fa-image" style="color: #ccc;"></i>
                                </div>
                            <?php endif; ?>
                            <div style="flex: 1;">
                                <h6 style="font-size: 0.875rem; font-weight: 600; line-height: 1.4; margin: 0 0 0.5rem 0;">
                                    <a href="<?php echo e(route('blogs.show', $recent->slug)); ?>" style="color: #000; text-decoration: none; transition: color 0.3s ease;"><?php echo e($recent->title); ?></a>
                                </h6>
                                <small style="color: #999; font-size: 0.75rem; font-weight: 500; letter-spacing: 0.05em;"><?php echo e($recent->readable_published_date); ?></small>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php endif; ?>
                    
                    <!-- Popular Tags -->
                    <?php if(count($popularTags) > 0): ?>
                    <div class="sidebar-premium" data-aos="fade-up" data-aos-delay="100">
                        <h5 class="sidebar-title">
                            <i class="fas fa-tags me-2"></i>Popular Topics
                        </h5>
                        <div style="display: flex; flex-wrap: wrap; gap: 0.5rem;">
                            <?php $__currentLoopData = $popularTags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag => $count): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a href="<?php echo e(route('blogs.index', ['tag' => $tag])); ?>" class="blog-tag">
                                    <?php echo e($tag); ?> (<?php echo e($count); ?>)
                                </a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <!-- Newsletter Signup -->
                    <div class="sidebar-premium" data-aos="fade-up" data-aos-delay="200">
                        <h5 class="sidebar-title">
                            <i class="fas fa-envelope me-2"></i>Stay Updated
                        </h5>
                        <p style="color: #666; margin-bottom: 1.5rem; font-size: 0.875rem; line-height: 1.6;">Get the latest Australian export insights delivered straight to your inbox.</p>
                        <form action="<?php echo e(route('newsletter.subscribe')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="mb-3">
                                <input type="email" class="search-input-premium" name="email" placeholder="Your email address" required style="width: 100%; margin-bottom: 1rem;">
                            </div>
                            <button type="submit" class="blog-read-more" style="width: 100%; justify-content: center;">
                                SUBSCRIBE NOW
                                <i class="fas fa-paper-plane"></i>
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Smooth scroll for tag links
    document.addEventListener('DOMContentLoaded', function() {
        // Add loading states for forms
        document.querySelectorAll('form').forEach(form => {
            form.addEventListener('submit', function() {
                const button = this.querySelector('button[type="submit"]');
                if (button) {
                    button.disabled = true;
                    button.innerHTML = '<i class="fas fa-spinner fa-spin me-1"></i>Loading...';
                }
            });
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\export-portfolio6\resources\views/blogs/index.blade.php ENDPATH**/ ?>