<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Welcome to Edition By Punjab</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            text-align: center;
            padding: 30px 0;
            background: #000;
            color: white;
        }
        .content {
            padding: 30px;
            background: #f9f9f9;
        }
        .discount-code {
            background: #000;
            color: white;
            padding: 20px;
            text-align: center;
            font-size: 24px;
            letter-spacing: 3px;
            margin: 20px 0;
            border-radius: 5px;
        }
        .button {
            display: inline-block;
            padding: 15px 30px;
            background: #000;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin: 20px 0;
        }
        .footer {
            text-align: center;
            padding: 20px;
            color: #666;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Welcome to Edition By Punjab!</h1>
        </div>
        
        <div class="content">
            <h2>Thank you for subscribing!</h2>
            <p>We're excited to have you join our community. As promised, here's your exclusive 10% discount code:</p>
            
            <div class="discount-code">
                <?php echo e($discountCode); ?>

            </div>
            
            <p>Use this code at checkout to save 10% on your entire purchase. This is a one-time use code valid for the next 30 days.</p>
            
            <center>
                <a href="<?php echo e(route('shop.index')); ?>" class="button">Shop Now</a>
            </center>
            
            <p>Stay tuned for:</p>
            <ul>
                <li>Exclusive deals and early access to sales</li>
                <li>New product launches</li>
                <li>Style tips and inspiration</li>
                <li>Special member-only events</li>
            </ul>
        </div>
        
        <div class="footer">
            <p>&copy; <?php echo e(date('Y')); ?> Edition By Punjab. All rights reserved.</p>
            <p>
                <a href="<?php echo e(route('privacy')); ?>">Privacy Policy</a> | 
                <a href="<?php echo e(route('terms')); ?>">Terms of Service</a>
            </p>
        </div>
    </div>
</body>
</html><?php /**PATH C:\xampp\htdocs\export-portfolio6\resources\views/emails/newsletter-welcome.blade.php ENDPATH**/ ?>