<?php $__env->startSection('title', 'Style Guides'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">Style Guides Management</h3>
                    <a href="<?php echo e(route('admin.style-guides.create')); ?>" class="btn btn-primary">
                        <i class="fas fa-plus"></i> Add New Style Guide
                    </a>
                </div>

                <div class="card-body">
                    <?php if($styleGuides->count() > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>Hero Image</th>
                                        <th>Name</th>
                                        <th>Region</th>
                                        <th>Fashion Score</th>
                                        <th>Status</th>
                                        <th>Sort Order</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $styleGuides; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $guide): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <?php if($guide->hero_image): ?>
                                                    <img src="<?php echo e($guide->hero_image_url); ?>" 
                                                         alt="<?php echo e($guide->name); ?>" 
                                                         class="img-thumbnail" 
                                                         style="width: 60px; height: 40px; object-fit: cover;">
                                                <?php else: ?>
                                                    <div class="bg-light d-flex align-items-center justify-content-center" 
                                                         style="width: 60px; height: 40px;">
                                                        <i class="fas fa-image text-muted"></i>
                                                    </div>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <strong><?php echo e($guide->name); ?></strong>
                                                <br>
                                                <small class="text-muted"><?php echo e($guide->tagline); ?></small>
                                            </td>
                                            <td><?php echo e($guide->region); ?></td>
                                            <td>
                                                <span class="badge badge-info"><?php echo e($guide->fashion_score); ?>/10</span>
                                            </td>
                                            <td>
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input toggle-active" 
                                                           type="checkbox" 
                                                           id="toggle_<?php echo e($guide->id); ?>"
                                                           data-id="<?php echo e($guide->id); ?>"
                                                           <?php echo e($guide->is_active ? 'checked' : ''); ?>>
                                                    <label class="form-check-label" for="toggle_<?php echo e($guide->id); ?>">
                                                        <span class="badge <?php echo e($guide->is_active ? 'badge-success' : 'badge-secondary'); ?>">
                                                            <?php echo e($guide->is_active ? 'Active' : 'Inactive'); ?>

                                                        </span>
                                                    </label>
                                                </div>
                                            </td>
                                            <td><?php echo e($guide->sort_order); ?></td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <a href="<?php echo e(route('admin.style-guides.show', $guide)); ?>" 
                                                       class="btn btn-sm btn-outline-info" 
                                                       title="View">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    <a href="<?php echo e(route('admin.style-guides.edit', $guide)); ?>" 
                                                       class="btn btn-sm btn-outline-primary" 
                                                       title="Edit">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <form action="<?php echo e(route('admin.style-guides.duplicate', $guide)); ?>" 
                                                          method="POST" 
                                                          class="d-inline">
                                                        <?php echo csrf_field(); ?>
                                                        <button type="submit" 
                                                                class="btn btn-sm btn-outline-secondary" 
                                                                title="Duplicate">
                                                            <i class="fas fa-copy"></i>
                                                        </button>
                                                    </form>
                                                    <form action="<?php echo e(route('admin.style-guides.destroy', $guide)); ?>" 
                                                          method="POST" 
                                                          class="d-inline delete-form">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="submit" 
                                                                class="btn btn-sm btn-outline-danger" 
                                                                title="Delete">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        <div class="d-flex justify-content-center">
                            <?php echo e($styleGuides->links()); ?>

                        </div>
                    <?php else: ?>
                        <div class="text-center py-4">
                            <i class="fas fa-map-marked-alt fa-3x text-muted mb-3"></i>
                            <p class="text-muted">No style guides found. Create your first style guide to get started!</p>
                            <a href="<?php echo e(route('admin.style-guides.create')); ?>" class="btn btn-primary">
                                <i class="fas fa-plus"></i> Add New Style Guide
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    // Toggle active status
    $('.toggle-active').change(function() {
        const guideId = $(this).data('id');
        const isActive = $(this).is(':checked');
        
        $.ajax({
            url: `/admin/style-guides/${guideId}/toggle-active`,
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if (response.success) {
                    const badge = $(`#toggle_${guideId}`).siblings('label').find('.badge');
                    if (response.is_active) {
                        badge.removeClass('badge-secondary').addClass('badge-success').text('Active');
                    } else {
                        badge.removeClass('badge-success').addClass('badge-secondary').text('Inactive');
                    }
                    
                    // Show success message
                    toastr.success(response.message);
                }
            },
            error: function() {
                // Revert toggle on error
                $(`#toggle_${guideId}`).prop('checked', !isActive);
                toastr.error('An error occurred while updating the status.');
            }
        });
    });

    // Delete confirmation
    $('.delete-form').submit(function(e) {
        e.preventDefault();
        
        const form = this;
        const guideName = $(form).closest('tr').find('strong').first().text();
        
        Swal.fire({
            title: 'Are you sure?',
            text: `You are about to delete the style guide "${guideName}". This action cannot be undone!`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#dc3545',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
            }
        });
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
.form-switch .form-check-input {
    width: 2em;
    height: 1em;
}

.btn-group .btn {
    margin-right: 2px;
}

.img-thumbnail {
    border-radius: 4px;
}
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\export-portfolio7\resources\views/admin/style-guides/index.blade.php ENDPATH**/ ?>