<!-- Premium Navigation -->
<nav class="navbar navbar-expand-lg navbar-premium fixed-top">
    <div class="container">
        <!-- Logo -->
        <a class="navbar-brand brand-premium" href="<?php echo e(route('home')); ?>">
            <?php if($companyInfo->logo ?? false): ?>
                <img src="<?php echo e(\App\Helpers\ImageHelper::getImageUrl($companyInfo->logo)); ?>" alt="Edition By Punjab" class="brand-logo">
            <?php else: ?>
                <span class="brand-text">
                    <span class="brand-main">EDITION</span>
                    <span class="brand-sub">BY PUNJAB</span>
                </span>
            <?php endif; ?>
        </a>

        <!-- Mobile Menu Toggle -->
        <div class="mobile-menu-controls">
            <button class="nav-icon-btn d-lg-none" data-bs-toggle="modal" data-bs-target="#searchModal">
                <i class="fas fa-search"></i>
            </button>
            <a class="nav-icon-btn d-lg-none position-relative" href="<?php echo e(route('cart.index')); ?>">
                <i class="fas fa-shopping-bag"></i>
                <span class="icon-badge cart-count"><?php echo e($cartCount ?? 0); ?></span>
            </a>
            <button class="navbar-toggler-premium d-lg-none" type="button" data-bs-toggle="collapse" data-bs-target="#navbarMain">
                <span></span>
                <span></span>
                <span></span>
            </button>
        </div>

        <!-- Main Navigation -->
        <div class="collapse navbar-collapse" id="navbarMain">
            <!-- Left Menu -->
            <ul class="navbar-nav navbar-nav-premium">
                <li class="nav-item">
                    <a class="nav-link nav-link-premium <?php echo e(request()->routeIs('home') ? 'active' : ''); ?>" href="<?php echo e(route('home')); ?>">
                        HOME
                    </a>
                </li>
                
                <!-- Shop Mega Menu -->
                <li class="nav-item dropdown mega-dropdown position-static">
                    <a class="nav-link nav-link-premium dropdown-toggle <?php echo e(request()->routeIs('shop.*') ? 'active' : ''); ?>" 
                       href="#" data-bs-toggle="dropdown">
                        SHOP
                    </a>
                    <div class="dropdown-menu mega-menu-premium">
                        <div class="container">
                            <div class="row">
                                <div class="col-lg-3">
                                    <div class="mega-menu-section">
                                        <h5 class="mega-menu-title">CATEGORIES</h5>
                                        <ul class="mega-menu-list">
                                            <?php $__currentLoopData = $categories->take(6); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li>
                                                <a href="<?php echo e(route('shop.category', $category->slug)); ?>">
                                                    <?php echo e(strtoupper($category->name)); ?>

                                                </a>
                                            </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                        <a href="<?php echo e(route('shop.index')); ?>" class="mega-menu-link-all">
                                            VIEW ALL →
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </li>
                
                <li class="nav-item">
                    <a class="nav-link nav-link-premium <?php echo e(request()->routeIs('blogs.*') ? 'active' : ''); ?>" href="<?php echo e(route('blogs.index')); ?>">
                        BLOG
                    </a>
                </li>
                
                <!-- About Dropdown -->
                <li class="nav-item dropdown">
                    <a class="nav-link nav-link-premium dropdown-toggle <?php echo e(request()->routeIs('about') || request()->routeIs('lookbook.*') || request()->routeIs('style-guide.*') || request()->routeIs('community.*') || request()->routeIs('trends.*') || request()->routeIs('size-guide.*') || request()->routeIs('city.*') || request()->routeIs('faq') ? 'active' : ''); ?>" 
                       href="#" data-bs-toggle="dropdown">
                        ABOUT
                    </a>
                    <ul class="dropdown-menu dropdown-menu-premium">
                        <li><a class="dropdown-item" href="<?php echo e(route('about')); ?>">ABOUT US</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="<?php echo e(route('lookbook.index')); ?>">LOOKBOOK</a></li>
                        <li><a class="dropdown-item" href="<?php echo e(route('style-guide.index')); ?>">STYLE GUIDES</a></li>
                        <li><a class="dropdown-item" href="<?php echo e(route('community.index')); ?>">COMMUNITY</a></li>
                        <li><a class="dropdown-item" href="<?php echo e(route('trends.index')); ?>">TRENDS & NEWS</a></li>
                        <li><a class="dropdown-item" href="<?php echo e(route('size-guide.index')); ?>">SIZE GUIDES</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><h6 class="dropdown-header text-muted">CITY GUIDES</h6></li>
                        <li><a class="dropdown-item" href="<?php echo e(route('city.melbourne')); ?>">MELBOURNE STREETWEAR</a></li>
                        <li><a class="dropdown-item" href="<?php echo e(route('city.sydney')); ?>">SYDNEY FASHION</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="<?php echo e(route('faq')); ?>">FAQ</a></li>
                    </ul>
                </li>
                
                <li class="nav-item">
                    <a class="nav-link nav-link-premium <?php echo e(request()->routeIs('contact') ? 'active' : ''); ?>" href="<?php echo e(route('contact')); ?>">
                        CONTACT
                    </a>
                </li>
                
                <li class="nav-item">
                    <a class="nav-link nav-link-premium text-sale" href="<?php echo e(route('shop.index', ['collection' => 'sale'])); ?>">
                        <span class="sale-badge">SALE</span>
                    </a>
                </li>
            </ul>

            <!-- Right Icons -->
            <ul class="navbar-nav navbar-icons-premium ms-auto">
                <!-- Search -->
                <li class="nav-item d-none d-lg-block">
                    <a class="nav-link icon-link" href="#" data-bs-toggle="modal" data-bs-target="#searchModal">
                        <i class="fas fa-search"></i>
                    </a>
                </li>
                
                <!-- Account -->
                <li class="nav-item dropdown">
                    <a class="nav-link icon-link" href="#" data-bs-toggle="dropdown">
                        <i class="far fa-user"></i>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-premium dropdown-menu-end">
                        <?php if(auth()->guard()->check()): ?>
                            <li><a class="dropdown-item" href="<?php echo e(route('account.dashboard')); ?>">MY ACCOUNT</a></li>
                            <li><a class="dropdown-item" href="<?php echo e(route('account.orders')); ?>">MY ORDERS</a></li>
                            <li><a class="dropdown-item" href="<?php echo e(route('account.wishlist')); ?>">WISHLIST</a></li>
                            <?php if(auth()->user()->is_admin): ?>
                                <li><hr class="dropdown-divider"></li>
                                <li><a class="dropdown-item" href="<?php echo e(route('admin.dashboard')); ?>">ADMIN PANEL</a></li>
                            <?php endif; ?>
                            <li><hr class="dropdown-divider"></li>
                            <li>
                                <form method="POST" action="<?php echo e(route('logout')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="dropdown-item">LOGOUT</button>
                                </form>
                            </li>
                        <?php else: ?>
                            <li><a class="dropdown-item" href="<?php echo e(route('login')); ?>">LOGIN</a></li>
                            <li><a class="dropdown-item" href="<?php echo e(route('register')); ?>">REGISTER</a></li>
                        <?php endif; ?>
                    </ul>
                </li>
                
                <!-- Wishlist -->
                <?php if(auth()->guard()->check()): ?>
                <li class="nav-item d-none d-lg-block">
                    <a class="nav-link icon-link position-relative" href="<?php echo e(route('account.wishlist')); ?>">
                        <i class="far fa-heart"></i>
                        <span class="icon-badge wishlist-count"><?php echo e($wishlistCount ?? 0); ?></span>
                    </a>
                </li>
                <?php endif; ?>
                
                <!-- Cart -->
                <li class="nav-item d-none d-lg-block">
                    <a class="nav-link icon-link position-relative" href="<?php echo e(route('cart.index')); ?>">
                        <i class="fas fa-shopping-bag"></i>
                        <span class="icon-badge cart-count"><?php echo e($cartCount ?? 0); ?></span>
                    </a>
                </li>
            </ul>
        </div>
    </div>
</nav>

<!-- Premium Search Modal -->
<div class="modal fade search-modal-premium" id="searchModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-fullscreen">
        <div class="modal-content">
            <div class="modal-header border-0">
                <button type="button" class="btn-close-search" data-bs-dismiss="modal">
                    <span></span>
                    <span></span>
                </button>
            </div>
            <div class="modal-body d-flex align-items-center justify-content-center">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-lg-8">
                            <h2 class="search-title mb-4">WHAT ARE YOU LOOKING FOR?</h2>
                            <form action="<?php echo e(route('shop.index')); ?>" method="GET" class="search-form-premium">
                                <div class="search-input-group">
                                    <input type="text" name="search" class="search-input-premium" 
                                           placeholder="Search products..." autofocus>
                                    <button class="search-submit-premium" type="submit">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>
                            </form>
                            
                            <!-- Trending Searches -->
                            <div class="trending-searches mt-5">
                                <h5 class="trending-title">TRENDING SEARCHES</h5>
                                <div class="trending-tags">
                                    <a href="<?php echo e(route('shop.index', ['search' => 'punjabi'])); ?>" class="trending-tag">PUNJABI</a>
                                    <a href="<?php echo e(route('shop.index', ['search' => 'kurta'])); ?>" class="trending-tag">KURTA</a>
                                    <a href="<?php echo e(route('shop.index', ['search' => 'streetwear'])); ?>" class="trending-tag">STREETWEAR</a>
                                    <a href="<?php echo e(route('shop.index', ['search' => 'accessories'])); ?>" class="trending-tag">ACCESSORIES</a>
                                    <a href="<?php echo e(route('shop.index', ['search' => 'new'])); ?>" class="trending-tag">NEW ARRIVALS</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Announcement Bar -->
<?php if($announcement ?? false): ?>
<div class="announcement-bar-premium">
    <div class="announcement-content">
        <span><?php echo e($announcement); ?></span>
    </div>
</div>
<?php endif; ?>

<style>
/* Premium Navigation Styles */
.navbar-premium {
    background: rgba(255, 255, 255, 0.98);
    backdrop-filter: blur(20px);
    -webkit-backdrop-filter: blur(20px);
    border-bottom: 1px solid rgba(0, 0, 0, 0.05);
    padding: 1.25rem 0;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    z-index: 1000;
}

.navbar-premium.scrolled {
    padding: 0.75rem 0;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
}

/* Brand Styles */
.brand-premium {
    display: flex;
    align-items: center;
}

.brand-logo {
    height: 40px;
}

.brand-text {
    display: flex;
    flex-direction: column;
    line-height: 1;
}

.brand-main {
    font-size: 1.5rem;
    font-weight: 900;
    letter-spacing: 0.05em;
    color: #000;
}

.brand-sub {
    font-size: 0.75rem;
    letter-spacing: 0.15em;
    color: #666;
    margin-top: 0.125rem;
}

/* Navigation Links */
.navbar-nav-premium {
    gap: 2rem;
}

.nav-link-premium {
    color: #000 !important;
    font-size: 0.875rem;
    font-weight: 600;
    letter-spacing: 0.1em;
    padding: 0.5rem 0 !important;
    position: relative;
    transition: all 0.3s;
}

.nav-link-premium::after {
    content: '';
    position: absolute;
    bottom: -2px;
    left: 0;
    width: 0;
    height: 2px;
    background: #000;
    transition: width 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}

.nav-link-premium:hover::after,
.nav-link-premium.active::after {
    width: 100%;
}

/* Sale Badge */
.sale-badge {
    background: var(--accent-color);
    color: white;
    padding: 0.25rem 0.75rem;
    font-size: 0.75rem;
    font-weight: 700;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% {
        transform: scale(1);
    }
    50% {
        transform: scale(1.05);
    }
}

/* Icon Navigation */
.navbar-icons-premium {
    gap: 1.5rem;
}

.icon-link {
    color: #000 !important;
    font-size: 1.125rem;
    position: relative;
    transition: all 0.3s;
}

.icon-link:hover {
    transform: translateY(-2px);
}

.icon-badge {
    position: absolute;
    top: -8px;
    right: -8px;
    background: #000;
    color: white;
    width: 18px;
    height: 18px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.625rem;
    font-weight: 700;
}

/* Mobile Menu Toggle */
.navbar-toggler-premium {
    width: 28px;
    height: 28px;
    padding: 0;
    border: none;
    background: none;
    position: relative;
    cursor: pointer;
}

.navbar-toggler-premium span {
    position: absolute;
    width: 100%;
    height: 2px;
    background: #000;
    left: 0;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}

.navbar-toggler-premium span:nth-child(1) {
    top: 6px;
}

.navbar-toggler-premium span:nth-child(2) {
    top: 50%;
    transform: translateY(-50%);
}

.navbar-toggler-premium span:nth-child(3) {
    bottom: 6px;
}

.navbar-toggler-premium[aria-expanded="true"] span:nth-child(1) {
    transform: rotate(45deg);
    top: 50%;
    margin-top: -1px;
}

.navbar-toggler-premium[aria-expanded="true"] span:nth-child(2) {
    opacity: 0;
}

.navbar-toggler-premium[aria-expanded="true"] span:nth-child(3) {
    transform: rotate(-45deg);
    bottom: 50%;
    margin-bottom: -1px;
}

/* Mobile Menu Controls */
.mobile-menu-controls {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.nav-icon-btn {
    background: none;
    border: none;
    color: #000;
    font-size: 1.125rem;
    cursor: pointer;
    position: relative;
}

/* Mega Menu */
.mega-menu-premium {
    background: white;
    border: none;
    border-radius: 0;
    box-shadow: 0 10px 40px rgba(0, 0, 0, 0.15);
    padding: 2.5rem 0;
    margin-top: 1rem;
    animation: fadeInDown 0.3s;
    left: 0;
    right: 0;
}

@keyframes fadeInDown {
    from {
        opacity: 0;
        transform: translateY(-10px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.mega-menu-title {
    font-size: 0.75rem;
    font-weight: 700;
    letter-spacing: 0.15em;
    margin-bottom: 1.5rem;
    color: #000;
}

.mega-menu-list {
    list-style: none;
    padding: 0;
    margin: 0;
}

.mega-menu-list li {
    margin-bottom: 0.75rem;
}

.mega-menu-list a {
    color: #666;
    text-decoration: none;
    font-size: 0.875rem;
    transition: all 0.3s;
    position: relative;
}

.mega-menu-list a:hover {
    color: #000;
    transform: translateX(5px);
    display: inline-block;
}

.mega-menu-link-all {
    display: inline-block;
    margin-top: 1rem;
    color: #000;
    font-weight: 600;
    text-decoration: none;
    font-size: 0.875rem;
    transition: all 0.3s;
}

.mega-menu-link-all:hover {
    transform: translateX(5px);
}

/* Dropdown Menu */
.dropdown-menu-premium {
    background: white;
    border: none;
    border-radius: 0;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
    padding: 1rem 0;
    margin-top: 0.5rem;
    min-width: 200px;
    animation: fadeInDown 0.3s;
}

.dropdown-menu-premium .dropdown-item {
    padding: 0.75rem 1.5rem;
    color: #000;
    font-size: 0.875rem;
    font-weight: 500;
    letter-spacing: 0.05em;
    transition: all 0.3s;
}

.dropdown-menu-premium .dropdown-item:hover {
    background: #f5f5f5;
    transform: translateX(5px);
}

.dropdown-divider {
    margin: 0.5rem 0;
    border-color: #e0e0e0;
}

/* Search Modal */
.search-modal-premium .modal-content {
    background: rgba(255, 255, 255, 0.98);
    backdrop-filter: blur(20px);
}

.btn-close-search {
    position: absolute;
    top: 2rem;
    right: 2rem;
    width: 40px;
    height: 40px;
    cursor: pointer;
    z-index: 1000;
}

.btn-close-search span {
    position: absolute;
    width: 100%;
    height: 2px;
    background: #000;
    transition: all 0.3s;
}

.btn-close-search span:first-child {
    transform: rotate(45deg);
}

.btn-close-search span:last-child {
    transform: rotate(-45deg);
}

.btn-close-search:hover span {
    background: var(--accent-color);
}

.search-title {
    font-size: 2rem;
    font-weight: 700;
    text-align: center;
    letter-spacing: 0.05em;
}

.search-input-group {
    position: relative;
    max-width: 600px;
    margin: 0 auto;
}

.search-input-premium {
    width: 100%;
    padding: 1.5rem 4rem 1.5rem 1.5rem;
    font-size: 1.125rem;
    border: 2px solid #000;
    background: transparent;
    outline: none;
    transition: all 0.3s;
}

.search-input-premium:focus {
    border-color: var(--accent-color);
}

.search-submit-premium {
    position: absolute;
    right: 1rem;
    top: 50%;
    transform: translateY(-50%);
    background: none;
    border: none;
    font-size: 1.5rem;
    cursor: pointer;
    transition: all 0.3s;
}

.search-submit-premium:hover {
    color: var(--accent-color);
}

/* Trending Searches */
.trending-searches {
    text-align: center;
}

.trending-title {
    font-size: 0.875rem;
    font-weight: 700;
    letter-spacing: 0.1em;
    margin-bottom: 1rem;
}

.trending-tags {
    display: flex;
    flex-wrap: wrap;
    gap: 1rem;
    justify-content: center;
}

.trending-tag {
    padding: 0.5rem 1.5rem;
    border: 1px solid #000;
    color: #000;
    text-decoration: none;
    font-size: 0.875rem;
    font-weight: 500;
    transition: all 0.3s;
}

.trending-tag:hover {
    background: #000;
    color: white;
    transform: translateY(-2px);
}

/* Announcement Bar */
.announcement-bar-premium {
    background: #000;
    color: white;
    padding: 0.5rem 0;
    text-align: center;
    font-size: 0.875rem;
    letter-spacing: 0.05em;
    position: relative;
    overflow: hidden;
}

.announcement-content {
    animation: slide 20s linear infinite;
}

@keyframes slide {
    0% {
        transform: translateX(100%);
    }
    100% {
        transform: translateX(-100%);
    }
}

/* Responsive */
@media (max-width: 991px) {
    .navbar-premium {
        padding: 1rem 0;
    }
    
    .navbar-collapse {
        background: white;
        position: absolute;
        top: 100%;
        left: 0;
        right: 0;
        padding: 2rem 0;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
    }
    
    .navbar-nav-premium {
        gap: 0;
    }
    
    .nav-link-premium {
        padding: 1rem !important;
        border-bottom: 1px solid #f0f0f0;
    }
    
    .navbar-icons-premium {
        flex-direction: row;
        padding: 1rem;
        border-top: 1px solid #f0f0f0;
        margin-top: 1rem;
    }
    
    .mega-menu-premium {
        position: static;
        box-shadow: none;
        padding: 1rem;
        margin: 0;
        left: auto;
        right: auto;
    }
}

@media (min-width: 992px) {
    .brand-premium {
        position: absolute;
        left: 50%;
        transform: translateX(-50%);
    }
}

/* Fixed body padding for fixed navbar */
body {
    padding-top: 80px;
}
</style>

<script>
// Navbar scroll effect
window.addEventListener('scroll', function() {
    const navbar = document.querySelector('.navbar-premium');
    if (window.scrollY > 50) {
        navbar.classList.add('scrolled');
    } else {
        navbar.classList.remove('scrolled');
    }
});
</script><?php /**PATH C:\xampp\htdocs\export-portfolio8\resources\views/layouts/navigation.blade.php ENDPATH**/ ?>