<?php $__env->startSection('title', 'Fashion Style Predictions - Edition By Punjab'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-0">
    <!-- Hero Section -->
    <section class="style-predictions-hero py-5" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
        <div class="container">
            <div class="row justify-content-center text-center">
                <div class="col-lg-8">
                    <div class="hero-content">
                        <h1 class="display-4 fw-bold mb-4">Fashion Style Predictions</h1>
                        <p class="lead mb-4">Get ahead of the curve with our data-driven fashion forecasts and trend predictions</p>
                        <div class="hero-stats d-flex justify-content-center gap-5 mt-4">
                            <div class="stat-item">
                                <h3 class="fw-bold"><?php echo e(count($predictions)); ?></h3>
                                <p class="mb-0">Predictions</p>
                            </div>
                            <div class="stat-item">
                                <h3 class="fw-bold"><?php echo e(round(collect($predictions)->avg('confidence'))); ?>%</h3>
                                <p class="mb-0">Avg Confidence</p>
                            </div>
                            <div class="stat-item">
                                <h3 class="fw-bold">12</h3>
                                <p class="mb-0">Month Outlook</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Predictions Timeline Section -->
    <section class="predictions-timeline py-5 bg-light">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="section-header text-center mb-5">
                        <h2 class="display-5 fw-bold text-dark">Fashion Forecast Timeline</h2>
                        <p class="lead text-muted">Our expert predictions for the future of Australian streetwear</p>
                    </div>
                </div>
            </div>

            <div class="timeline-container">
                <?php $__currentLoopData = $predictions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $prediction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="timeline-item row mb-5">
                    <div class="col-lg-6 <?php echo e($index % 2 === 0 ? '' : 'order-lg-2'); ?>">
                        <div class="prediction-card card border-0 shadow-lg h-100">
                            <!-- Timeline Badge -->
                            <div class="timeline-badge position-absolute" 
                                 style="top: 20px; <?php echo e($index % 2 === 0 ? 'right: -20px' : 'left: -20px'); ?>;">
                                <span class="badge bg-primary px-3 py-2 rounded-pill fs-6">
                                    <i class="fas fa-clock me-1"></i><?php echo e($prediction['timeline']); ?>

                                </span>
                            </div>

                            <div class="card-body p-4">
                                <!-- Confidence Score -->
                                <div class="confidence-score mb-3 d-flex justify-content-between align-items-center">
                                    <h6 class="fw-bold text-muted mb-0">PREDICTION <?php echo e($index + 1); ?></h6>
                                    <div class="score-badge">
                                        <span class="badge 
                                        <?php if($prediction['confidence'] >= 90): ?>
                                            bg-success
                                        <?php elseif($prediction['confidence'] >= 80): ?>
                                            bg-warning text-dark
                                        <?php else: ?>
                                            bg-secondary
                                        <?php endif; ?>
                                        px-3 py-2">
                                            <?php echo e($prediction['confidence']); ?>% Confidence
                                        </span>
                                    </div>
                                </div>

                                <!-- Prediction Title -->
                                <h3 class="prediction-title fw-bold text-dark mb-3">
                                    <?php echo e($prediction['prediction']); ?>

                                </h3>

                                <!-- Description -->
                                <p class="prediction-description text-muted mb-4">
                                    <?php echo e($prediction['description']); ?>

                                </p>

                                <!-- Confidence Progress Bar -->
                                <div class="confidence-bar mb-4">
                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                        <span class="fw-bold text-dark">Confidence Level</span>
                                        <span class="text-muted"><?php echo e($prediction['confidence']); ?>%</span>
                                    </div>
                                    <div class="progress" style="height: 8px;">
                                        <div class="progress-bar 
                                        <?php if($prediction['confidence'] >= 90): ?>
                                            bg-success
                                        <?php elseif($prediction['confidence'] >= 80): ?>
                                            bg-warning
                                        <?php else: ?>
                                            bg-secondary
                                        <?php endif; ?>
                                        " 
                                             role="progressbar" 
                                             style="width: <?php echo e($prediction['confidence']); ?>%"
                                             aria-valuenow="<?php echo e($prediction['confidence']); ?>" 
                                             aria-valuemin="0" 
                                             aria-valuemax="100">
                                        </div>
                                    </div>
                                </div>

                                <!-- Impact Areas -->
                                <div class="impact-areas">
                                    <h6 class="fw-bold text-dark mb-3">
                                        <i class="fas fa-bullseye text-primary me-2"></i>Impact Areas
                                    </h6>
                                    <div class="d-flex flex-wrap gap-2">
                                        <?php $__currentLoopData = $prediction['impact_areas']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span class="badge bg-light text-dark border px-3 py-2">
                                            <i class="fas fa-dot-circle me-1 text-primary"></i><?php echo e($area); ?>

                                        </span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Timeline Visual -->
                    <div class="col-lg-6 <?php echo e($index % 2 === 0 ? 'order-lg-2' : ''); ?> d-flex align-items-center">
                        <div class="timeline-visual text-center w-100">
                            <div class="prediction-icon mb-3">
                                <?php if($index === 0): ?>
                                    <i class="fas fa-paint-brush fa-4x text-primary"></i>
                                <?php elseif($index === 1): ?>
                                    <i class="fas fa-leaf fa-4x text-success"></i>
                                <?php else: ?>
                                    <i class="fas fa-user-cog fa-4x text-warning"></i>
                                <?php endif; ?>
                            </div>
                            <h5 class="fw-bold text-dark"><?php echo e($prediction['timeline']); ?></h5>
                            <p class="text-muted">Timeline Forecast</p>
                            
                            <!-- Visual Timeline Indicator -->
                            <div class="timeline-indicator mx-auto mt-3" style="width: 100px; height: 4px; background: #e9ecef; border-radius: 2px;">
                                <div class="timeline-progress bg-primary" 
                                     style="height: 100%; width: <?php echo e($prediction['confidence']); ?>%; border-radius: 2px;">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>

    <!-- Prediction Methodology Section -->
    <section class="methodology py-5">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <h3 class="text-center mb-5 fw-bold">Our Prediction Methodology</h3>
                </div>
            </div>
            <div class="row g-4">
                <div class="col-lg-3 col-md-6">
                    <div class="methodology-card text-center p-4 border rounded-3 h-100">
                        <div class="icon mb-3">
                            <i class="fas fa-chart-line fa-3x text-primary"></i>
                        </div>
                        <h5 class="fw-bold">Data Analysis</h5>
                        <p class="text-muted mb-0">Advanced analytics of fashion trends, consumer behavior, and market data</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="methodology-card text-center p-4 border rounded-3 h-100">
                        <div class="icon mb-3">
                            <i class="fas fa-users fa-3x text-success"></i>
                        </div>
                        <h5 class="fw-bold">Expert Insights</h5>
                        <p class="text-muted mb-0">Input from fashion industry experts and cultural trend analysts</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="methodology-card text-center p-4 border rounded-3 h-100">
                        <div class="icon mb-3">
                            <i class="fas fa-globe fa-3x text-info"></i>
                        </div>
                        <h5 class="fw-bold">Global Trends</h5>
                        <p class="text-muted mb-0">Monitoring international fashion movements and cultural shifts</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="methodology-card text-center p-4 border rounded-3 h-100">
                        <div class="icon mb-3">
                            <i class="fas fa-brain fa-3x text-warning"></i>
                        </div>
                        <h5 class="fw-bold">AI Modeling</h5>
                        <p class="text-muted mb-0">Machine learning algorithms to predict future fashion trends</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="prediction-cta py-5 bg-primary text-white">
        <div class="container">
            <div class="row justify-content-center text-center">
                <div class="col-lg-8">
                    <h3 class="fw-bold mb-3">Stay Ahead of Fashion Trends</h3>
                    <p class="lead mb-4">Be the first to know about emerging trends and get exclusive insights</p>
                    <div class="cta-buttons d-flex gap-3 justify-content-center flex-wrap">
                        <a href="<?php echo e(route('shop.index')); ?>" class="btn btn-light btn-lg px-4">
                            <i class="fas fa-shopping-cart me-2"></i>Shop Trending Styles
                        </a>
                        <a href="<?php echo e(route('style-guide.index')); ?>" class="btn btn-outline-light btn-lg px-4">
                            <i class="fas fa-map-marked-alt me-2"></i>Style Guides
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Navigation Section -->
    <section class="trends-navigation py-5 bg-dark text-white">
        <div class="container">
            <div class="row">
                <div class="col-12 text-center">
                    <h3 class="mb-5 fw-bold">Explore More Content</h3>
                </div>
            </div>
            <div class="row g-4 text-center">
                <div class="col-lg-4 col-md-6">
                    <div class="nav-item p-4 border border-secondary rounded-3 h-100">
                        <i class="fas fa-chart-trending-up fa-3x mb-3 text-warning"></i>
                        <h5 class="fw-bold">Weekly Trends</h5>
                        <p class="text-muted">Latest weekly streetwear trends</p>
                        <a href="<?php echo e(route('trends.weekly')); ?>" class="btn btn-outline-warning">View Trends</a>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="nav-item p-4 border border-secondary rounded-3 h-100">
                        <i class="fas fa-calendar-alt fa-3x mb-3 text-info"></i>
                        <h5 class="fw-bold">Seasonal Forecast</h5>
                        <p class="text-muted">Upcoming seasonal trends</p>
                        <a href="<?php echo e(route('trends.seasonal')); ?>" class="btn btn-outline-info">View Forecast</a>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="nav-item p-4 border border-secondary rounded-3 h-100">
                        <i class="fas fa-newspaper fa-3x mb-3 text-success"></i>
                        <h5 class="fw-bold">Fashion News</h5>
                        <p class="text-muted">Latest industry updates</p>
                        <a href="<?php echo e(route('trends.news')); ?>" class="btn btn-outline-success">Read News</a>
                    </div>
                </div>
            </div>
            <div class="row mt-4">
                <div class="col-12 text-center">
                    <a href="<?php echo e(route('trends.index')); ?>" class="btn btn-outline-light btn-lg px-5 rounded-pill">
                        <i class="fas fa-arrow-left me-2"></i> Back to Trends Overview
                    </a>
                </div>
            </div>
        </div>
    </section>
</div>

<style>
.prediction-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    position: relative;
}

.prediction-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 35px rgba(0,0,0,0.15) !important;
}

.methodology-card {
    transition: transform 0.3s ease, border-color 0.3s ease;
}

.methodology-card:hover {
    transform: translateY(-3px);
    border-color: #3b82f6 !important;
}

.nav-item {
    transition: transform 0.3s ease, border-color 0.3s ease;
}

.nav-item:hover {
    transform: translateY(-5px);
    border-color: #fff !important;
}

.timeline-badge {
    z-index: 10;
}

.timeline-progress {
    transition: width 2s ease-in-out;
}

.prediction-icon i {
    animation: float 3s ease-in-out infinite;
}

@keyframes float {
    0% { transform: translateY(0px); }
    50% { transform: translateY(-10px); }
    100% { transform: translateY(0px); }
}

.progress-bar {
    animation: progressAnimation 2s ease-in-out;
}

@keyframes progressAnimation {
    0% { width: 0; }
    100% { width: var(--progress-width); }
}

.style-predictions-hero {
    position: relative;
    overflow: hidden;
}

.style-predictions-hero::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0,0,0,0.1);
    z-index: 1;
}

.style-predictions-hero .container {
    position: relative;
    z-index: 2;
}

.timeline-container {
    position: relative;
}

.timeline-container::before {
    content: '';
    position: absolute;
    left: 50%;
    top: 0;
    bottom: 0;
    width: 2px;
    background: #e9ecef;
    transform: translateX(-50%);
    z-index: 1;
}

@media (max-width: 991.98px) {
    .timeline-container::before {
        left: 20px;
    }
    
    .timeline-badge {
        position: relative !important;
        top: auto !important;
        left: auto !important;
        right: auto !important;
        margin-bottom: 1rem;
    }
}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\export-portfolio7\resources\views/trends/predictions.blade.php ENDPATH**/ ?>