<?php $__env->startSection('title', 'Edit Style Guide'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">Edit Style Guide: <?php echo e($styleGuide->name); ?></h3>
                    <div>
                        <a href="<?php echo e(route('style-guide.show', $styleGuide->slug)); ?>" 
                           class="btn btn-info" 
                           target="_blank">
                            <i class="fas fa-eye"></i> Preview
                        </a>
                        <a href="<?php echo e(route('admin.style-guides.index')); ?>" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Back to Style Guides
                        </a>
                    </div>
                </div>

                <!-- Nav tabs -->
                <ul class="nav nav-tabs" id="styleGuideTab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="basic-tab" data-bs-toggle="tab" data-bs-target="#basic" type="button" role="tab">
                            <i class="fas fa-info-circle"></i> Basic Info
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="content-tab" data-bs-toggle="tab" data-bs-target="#content" type="button" role="tab">
                            <i class="fas fa-file-alt"></i> Content
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="details-tab" data-bs-toggle="tab" data-bs-target="#details" type="button" role="tab">
                            <i class="fas fa-list"></i> Style Details
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="gallery-tab" data-bs-toggle="tab" data-bs-target="#gallery" type="button" role="tab">
                            <i class="fas fa-images"></i> Gallery
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="seo-tab" data-bs-toggle="tab" data-bs-target="#seo" type="button" role="tab">
                            <i class="fas fa-search"></i> SEO
                        </button>
                    </li>
                </ul>

                <form action="<?php echo e(route('admin.style-guides.update', $styleGuide)); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    
                    <div class="tab-content p-3">
                        <!-- Basic Info Tab -->
                        <div class="tab-pane fade show active" id="basic" role="tabpanel">
                            <?php echo $__env->make('admin.style-guides.partials.basic-info', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                        <!-- Content Tab -->
                        <div class="tab-pane fade" id="content" role="tabpanel">
                            <?php echo $__env->make('admin.style-guides.partials.content', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                        <!-- Style Details Tab -->
                        <div class="tab-pane fade" id="details" role="tabpanel">
                            <?php echo $__env->make('admin.style-guides.partials.style-details', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                        <!-- Gallery Tab -->
                        <div class="tab-pane fade" id="gallery" role="tabpanel">
                            <?php echo $__env->make('admin.style-guides.partials.gallery', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                        <!-- SEO Tab -->
                        <div class="tab-pane fade" id="seo" role="tabpanel">
                            <?php echo $__env->make('admin.style-guides.partials.seo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>

                    <div class="card-footer">
                        <div class="row">
                            <div class="col-md-6">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> Update Style Guide
                                </button>
                                <a href="<?php echo e(route('admin.style-guides.index')); ?>" class="btn btn-secondary ms-2">
                                    Cancel
                                </a>
                            </div>
                            <div class="col-md-6 text-end">
                                <small class="text-muted">
                                    Last updated: <?php echo e($styleGuide->updated_at->format('M j, Y \a\t g:i A')); ?>

                                </small>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.ckeditor.com/ckeditor5/39.0.1/classic/ckeditor.js"></script>
<script>
$(document).ready(function() {
    // Initialize CKEditor for content
    ClassicEditor
        .create(document.querySelector('#content'))
        .catch(error => {
            console.error(error);
        });

    // Auto-generate slug from name
    $('#name').on('input', function() {
        const name = $(this).val();
        const slug = name.toLowerCase()
            .replace(/[^\w\s-]/g, '')
            .replace(/[\s_-]+/g, '-')
            .replace(/^-+|-+$/g, '');
        $('#slug').val(slug);
    });

    // Dynamic array field management
    function addArrayItem(containerSelector, template) {
        const container = $(containerSelector);
        const index = container.children().length;
        const newItem = template.replace(/\[INDEX\]/g, `[${index}]`).replace(/INDEX/g, index);
        container.append(newItem);
    }

    function removeArrayItem(button) {
        $(button).closest('.array-item').remove();
    }

    // Styling Tips
    $('#add-styling-tip').click(function() {
        const template = `
            <div class="array-item mb-2">
                <div class="input-group">
                    <input type="text" class="form-control" name="styling_tips[INDEX]" placeholder="Enter styling tip">
                    <button type="button" class="btn btn-outline-danger remove-item">
                        <i class="fas fa-trash"></i>
                    </button>
                </div>
            </div>
        `;
        addArrayItem('#styling-tips-container', template);
    });

    // Key Pieces
    $('#add-key-piece').click(function() {
        const template = `
            <div class="array-item mb-2">
                <div class="input-group">
                    <input type="text" class="form-control" name="key_pieces[INDEX]" placeholder="Enter key piece">
                    <button type="button" class="btn btn-outline-danger remove-item">
                        <i class="fas fa-trash"></i>
                    </button>
                </div>
            </div>
        `;
        addArrayItem('#key-pieces-container', template);
    });

    // Remove array item
    $(document).on('click', '.remove-item', function() {
        removeArrayItem(this);
    });

    // Color picker
    $('input[type="color"]').change(function() {
        $(this).siblings('input[type="text"]').val($(this).val());
    });

    // Image preview
    $('input[type="file"]').change(function() {
        const input = this;
        const preview = $(this).siblings('.image-preview');
        
        if (input.files && input.files[0]) {
            const reader = new FileReader();
            
            reader.onload = function(e) {
                preview.html(`<img src="${e.target.result}" class="img-thumbnail mt-2" style="max-width: 200px;">`);
            }
            
            reader.readAsDataURL(input.files[0]);
        }
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
.nav-tabs .nav-link {
    border: 1px solid transparent;
    border-top-left-radius: 0.375rem;
    border-top-right-radius: 0.375rem;
}

.nav-tabs .nav-link.active {
    color: #495057;
    background-color: #fff;
    border-color: #dee2e6 #dee2e6 #fff;
}

.array-item {
    background: #f8f9fa;
    padding: 10px;
    border-radius: 4px;
    border-left: 3px solid #007bff;
}

.color-swatch {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    border: 2px solid #ddd;
    cursor: pointer;
}

.image-preview {
    min-height: 50px;
}
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\export-portfolio7\resources\views/admin/style-guides/edit.blade.php ENDPATH**/ ?>