

<?php $__env->startSection('title', 'Shopping Cart'); ?>

<?php $__env->startSection('content'); ?>
<div class="cart-page-premium">
    <!-- Page Header -->
    <section class="cart-header-premium">
        <div class="container">
            <h1 class="cart-title" data-aos="fade-up">SHOPPING CART</h1>
            <nav aria-label="breadcrumb" data-aos="fade-up" data-aos-delay="100">
                <ol class="breadcrumb-premium">
                    <li><a href="<?php echo e(route('home')); ?>">HOME</a></li>
                    <li class="separator">/</li>
                    <li><a href="<?php echo e(route('shop.index')); ?>">SHOP</a></li>
                    <li class="separator">/</li>
                    <li class="active">CART</li>
                </ol>
            </nav>
        </div>
    </section>

    <div class="container">
        <?php if(session('success')): ?>
            <div class="alert-premium success" data-aos="fade-down">
                <i class="fas fa-check-circle"></i>
                <span><?php echo e(session('success')); ?></span>
                <button class="alert-close" onclick="this.parentElement.remove()">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="alert-premium error" data-aos="fade-down">
                <i class="fas fa-exclamation-circle"></i>
                <span><?php echo e(session('error')); ?></span>
                <button class="alert-close" onclick="this.parentElement.remove()">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        <?php endif; ?>

        <?php if($cartItems->isEmpty()): ?>
            <!-- Empty Cart -->
            <div class="empty-cart-section">
                <div class="empty-cart-content" data-aos="zoom-in">
                    <div class="empty-cart-icon">
                        <i class="fas fa-shopping-bag"></i>
                    </div>
                    <h2>YOUR CART IS EMPTY</h2>
                    <p>Looks like you haven't added anything to your cart yet.</p>
                    <a href="<?php echo e(route('shop.index')); ?>" class="btn-continue-shopping">
                        CONTINUE SHOPPING
                    </a>
                </div>
            </div>
        <?php else: ?>
            <!-- Cart Content -->
            <div class="cart-content-premium">
                <div class="row">
                    <!-- Cart Items -->
                    <div class="col-lg-8">
                        <div class="cart-items-section" data-aos="fade-right">
                            <div class="cart-items-header">
                                <h3>CART ITEMS (<?php echo e($cartItems->count()); ?>)</h3>
                            </div>

                            <div class="cart-items-list">
                                <?php $__currentLoopData = $cartItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="cart-item-premium" data-item-id="<?php echo e($item->id); ?>">
                                    <div class="cart-item-image">
                                        <?php if($item->product && $item->product->featured_image): ?>
                                        <img src="<?php echo e(Storage::url($item->product->featured_image)); ?>"
                                             alt="<?php echo e($item->product->name); ?>"
                                             onerror="this.src='/images/placeholder-product.jpg'">
                                        <?php else: ?>
                                        <img src="/images/placeholder-product.jpg" alt="Product">
                                        <?php endif; ?>
                                    </div>

                                    <div class="cart-item-details">
                                        <h4 class="item-name">
                                            <?php if($item->product): ?>
                                            <a href="<?php echo e(route('shop.product', $item->product->slug)); ?>">
                                                <?php echo e($item->product->name); ?>

                                            </a>
                                            <?php else: ?>
                                            <?php echo e($item->product_name ?? 'Product'); ?>

                                            <?php endif; ?>
                                        </h4>

                                        <?php if($item->attributes): ?>
                                        <div class="item-attributes">
                                            <?php
                                                // ensure attributes render whether stored as array or json string
                                                $attrs = $item->attributes;
                                                if (is_string($attrs)) {
                                                    $decoded = json_decode($attrs, true);
                                                    if (is_array($decoded)) {
                                                        $attrs = $decoded;
                                                    } else {
                                                        $attrs = [];
                                                    }
                                                }
                                                if (!is_array($attrs)) {
                                                    $attrs = [];
                                                }
                                            ?>
                                            <?php $__currentLoopData = $attrs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span class="attribute-tag">
                                                <?php echo e(ucfirst($key)); ?>: <?php echo e($value); ?>

                                            </span>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                        <?php endif; ?>

                                        <div class="item-price-mobile">
                                            $<?php echo e(number_format($item->price, 2)); ?>

                                        </div>
                                    </div>

                                    <div class="cart-item-price">
                                        $<?php echo e(number_format($item->price, 2)); ?>

                                    </div>

                                    <div class="cart-item-quantity">
                                        <form action="<?php echo e(route('cart.update', $item->id)); ?>" method="POST" class="quantity-form">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PATCH'); ?>
                                            <div class="quantity-control">
                                                <button type="button" class="qty-decrease" data-action="decrease">
                                                    <i class="fas fa-minus"></i>
                                                </button>
                                                <input type="number" name="quantity" value="<?php echo e($item->quantity); ?>"
                                                       min="1" max="<?php echo e($item->product->stock ?? 99); ?>"
                                                       class="qty-value" readonly>
                                                <button type="button" class="qty-increase" data-action="increase">
                                                    <i class="fas fa-plus"></i>
                                                </button>
                                            </div>
                                        </form>
                                    </div>

                                    <div class="cart-item-total">
                                        $<?php echo e(number_format($item->price * $item->quantity, 2)); ?>

                                    </div>

                                    <div class="cart-item-remove">
                                        <form action="<?php echo e(route('cart.remove', $item->id)); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn-remove" title="Remove item">
                                                <i class="fas fa-times"></i>
                                            </button>
                                        </form>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                            <!-- Cart Actions -->
                            <div class="cart-actions">
                                <a href="<?php echo e(route('shop.index')); ?>" class="btn-secondary-premium">
                                    <i class="fas fa-arrow-left"></i> CONTINUE SHOPPING
                                </a>
                                <button type="button" class="btn-clear-cart" onclick="clearCart()">
                                    <i class="fas fa-trash"></i> CLEAR CART
                                </button>
                            </div>
                        </div>

                        <!-- Coupon Section -->
                        <div class="coupon-section-premium" data-aos="fade-up">
                            <h4>HAVE A COUPON?</h4>
                            <?php if(!$couponSession && !$discountSession): ?>
                            <form action="<?php echo e(route('cart.apply-coupon')); ?>" method="POST" class="coupon-form">
                                <?php echo csrf_field(); ?>
                                <div class="coupon-input-group">
                                    <input type="text" name="coupon_code" placeholder="Enter coupon code" class="coupon-input">
                                    <button type="submit" class="btn-apply-coupon">APPLY</button>
                                </div>
                            </form>
                            <?php else: ?>
                            <div class="applied-coupon">
                                <div class="coupon-info">
                                    <i class="fas fa-tag"></i>
                                    <?php if($discountSession): ?>
                                        <span>Discount Applied: <?php echo e($discountSession['percentage'] ?? 0); ?>% OFF</span>
                                    <?php elseif($couponSession): ?>
                                        <span>Coupon Applied: <?php echo e($couponSession['code']); ?></span>
                                    <?php endif; ?>
                                </div>
                                <form action="<?php echo e(route('cart.remove-coupon')); ?>" method="POST" class="d-inline">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn-remove-coupon">REMOVE</button>
                                </form>
                            </div>
                            <?php endif; ?>
                        </div>

                        <!-- Shipping & Tax Calculator (Premium) -->
                        <div class="shipping-calculator-premium mt-4" data-aos="fade-up">
                            <div class="card">
                                <div class="card-header bg-primary text-white">
                                    <h5 class="mb-0"><i class="fas fa-calculator"></i> Shipping & Tax Calculator</h5>
                                </div>
                                <div class="card-body">
                                    <form id="shippingFormPremium" class="row g-3">
                                        <div class="col-md-6">
                                            <label class="form-label">City / Zone (Tax & Shipping)</label>
                                            <select id="shippingCityPremium" class="form-select">
                                                <option value="">Select city</option>
                                                <?php if(isset($locationData) && $locationData->count() > 0): ?>
                                                    <?php $__currentLoopData = $locationData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state => $locations): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <optgroup label="<?php echo e($state); ?>">
                                                            <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($location['city']); ?>"
                                                                        data-state="<?php echo e($location['state']); ?>"
                                                                        data-free-threshold="<?php echo e($location['free_shipping_threshold'] ?? ''); ?>"
                                                                        data-tax-rate="<?php echo e($location['tax_percentage'] ?? 10); ?>"
                                                                        data-tax-name="<?php echo e($location['tax_name'] ?? 'GST'); ?>"
                                                                        <?php echo e((isset($shippingCity) && $shippingCity == $location['city']) ? 'selected' : ''); ?>>
                                                                    <?php echo e($location['city']); ?>

                                                                    <?php if($location['tax_percentage'] !== null): ?>
                                                                        - <?php echo e($location['tax_name']); ?> <?php echo e(number_format($location['tax_percentage'], 0)); ?>%
                                                                    <?php else: ?>
                                                                        - GST 10%
                                                                    <?php endif; ?>
                                                                    <?php if($location['free_shipping_threshold']): ?>
                                                                        (Free shipping > $<?php echo e(number_format($location['free_shipping_threshold'], 0)); ?>)
                                                                    <?php endif; ?>
                                                                </option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </optgroup>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php elseif(isset($shippingZones) && $shippingZones->count() > 0): ?>
                                                    <?php $__currentLoopData = $shippingZones->groupBy('state'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state => $zones): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <optgroup label="<?php echo e($state); ?>">
                                                            <?php $__currentLoopData = $zones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $zone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($zone->city); ?>"
                                                                        data-state="<?php echo e($zone->state); ?>"
                                                                        data-free-threshold="<?php echo e($zone->free_shipping_threshold ?? ''); ?>"
                                                                        <?php echo e((isset($shippingCity) && $shippingCity == $zone->city) ? 'selected' : ''); ?>>
                                                                    <?php echo e($zone->city); ?>

                                                                    <?php if($zone->free_shipping_threshold): ?>
                                                                        (Free over $<?php echo e(number_format($zone->free_shipping_threshold, 0)); ?>)
                                                                    <?php endif; ?>
                                                                </option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </optgroup>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php else: ?>
                                                    <option value="Sydney" data-state="NSW" data-tax-rate="10" data-tax-name="GST">Sydney - GST 10%</option>
                                                    <option value="Melbourne" data-state="VIC" data-tax-rate="10" data-tax-name="GST">Melbourne - GST 10%</option>
                                                    <option value="Brisbane" data-state="QLD" data-tax-rate="10" data-tax-name="GST">Brisbane - GST 10%</option>
                                                    <option value="Perth" data-state="WA" data-tax-rate="0" data-tax-name="Tax Free Zone">Perth - Tax Free Zone 0%</option>
                                                    <option value="Adelaide" data-state="SA" data-tax-rate="0" data-tax-name="Tax Free Zone">Adelaide - Tax Free Zone 0%</option>
                                                    <option value="Darwin" data-state="NT" data-tax-rate="0" data-tax-name="Tax Free Zone">Darwin - Tax Free Zone 0%</option>
                                                    <option value="Other" data-state="ALL" data-tax-rate="10" data-tax-name="GST">Other - GST 10%</option>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                        <div class="col-md-6">
                                            <label class="form-label">Shipping Method</label>
                                            <select id="shippingMethodPremium" class="form-select">
                                                <option value="standard" <?php echo e((isset($shippingMethod) && $shippingMethod == 'standard') ? 'selected' : ''); ?>>
                                                    Standard (5-7 business days)
                                                </option>
                                                <option value="express" <?php echo e((isset($shippingMethod) && $shippingMethod == 'express') ? 'selected' : ''); ?>>
                                                    Express (2-3 business days)
                                                </option>
                                                <option value="priority" <?php echo e((isset($shippingMethod) && $shippingMethod == 'priority') ? 'selected' : ''); ?>>
                                                    Priority (1-2 business days)
                                                </option>
                                            </select>
                                        </div>

                                        <div class="col-12">
                                            <button type="button" id="updateShippingPremium" class="btn btn-primary w-100">
                                                <i class="fas fa-calculator"></i> Calculate Tax & Shipping
                                            </button>
                                        </div>
                                    </form>
                                    
                                    <!-- Current Rates Display -->
                                    <div id="currentRatesDisplay" class="mt-3 p-3 bg-light rounded">
                                        <div class="row text-center">
                                            <div class="col-6">
                                                <div class="rate-info">
                                                    <div class="rate-label">Current Tax Rate</div>
                                                    <div class="rate-value" id="currentTaxRate">
                                                        <?php if($taxRate): ?>
                                                            <?php echo e($taxRate->tax_name); ?> <?php echo e($taxRate->formatted_rate); ?>

                                                        <?php else: ?>
                                                            GST 10%
                                                        <?php endif; ?>
                                                    </div>
                                                    <div class="rate-location" id="currentTaxLocation"><?php echo e($shippingCity); ?>, <?php echo e($shippingState); ?></div>
                                                </div>
                                            </div>
                                            <div class="col-6">
                                                <div class="rate-info">
                                                    <div class="rate-label">Shipping Method</div>
                                                    <div class="rate-value" id="currentShippingMethod"><?php echo e(ucfirst($shippingMethod)); ?></div>
                                                    <div class="rate-location" id="currentShippingLocation">to <?php echo e($shippingCity); ?></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <?php if(isset($shippingZone) && $shippingZone && $shippingZone->free_shipping_threshold && isset($subtotal) && $subtotal < $shippingZone->free_shipping_threshold): ?>
                                    <div id="freeShippingNoticePremium" class="alert alert-info mt-3 mb-0">
                                        <i class="fas fa-info-circle"></i>
                                        Add $<?php echo e(number_format($shippingZone->free_shipping_threshold - $subtotal, 2)); ?>

                                        more to qualify for free shipping to <?php echo e($shippingCity); ?>!
                                    </div>
                                    <?php else: ?>
                                    <div id="freeShippingNoticePremium" class="alert alert-info mt-3 mb-0" style="display: none;">
                                        <i class="fas fa-info-circle"></i>
                                        <!-- dynamic content -->
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <!-- END Shipping Calculator -->

                    </div>

                    <!-- Order Summary -->
                    <div class="col-lg-4">
                        <div class="order-summary-premium" data-aos="fade-left">
                            <h3 class="summary-title">ORDER SUMMARY</h3>

                            <div class="summary-details">
                                <div class="summary-row">
                                    <span>Subtotal</span>
                                    <strong id="subtotalAmount">$<?php echo e(number_format($subtotal, 2)); ?></strong>
                                </div>

                                <?php if($discount > 0): ?>
                                <div class="summary-row discount">
                                    <span>Discount</span>
                                    <strong>-$<?php echo e(number_format($discount, 2)); ?></strong>
                                </div>
                                <?php endif; ?>

                                <div class="summary-row">
                                    <span id="taxLabel">Tax (<?php echo e($taxRate ? $taxRate->tax_name : 'GST'); ?> <?php echo e($taxRate ? $taxRate->formatted_rate : '10%'); ?>)</span>
                                    <strong id="taxAmount">$<?php echo e(number_format($tax, 2)); ?></strong>
                                </div>

                                <div class="summary-row">
                                    <span id="shippingLabel">Shipping</span>
                                    <strong id="shippingAmount">
                                        <?php if($shipping > 0): ?>
                                            $<?php echo e(number_format($shipping, 2)); ?>

                                        <?php else: ?>
                                            <span class="free-shipping">FREE</span>
                                        <?php endif; ?>
                                    </strong>
                                </div>

                                <div class="summary-divider"></div>

                                <div class="summary-row total">
                                    <span>Total</span>
                                    <strong id="totalAmount">$<?php echo e(number_format($total, 2)); ?></strong>
                                </div>
                            </div>

                            <div class="shipping-progress">
                                <?php
                                    $freeThreshold = isset($shippingZone) && $shippingZone ? $shippingZone->free_shipping_threshold : 100;
                                    if (!$freeThreshold) $freeThreshold = 100;
                                ?>

                                <?php if($subtotal < $freeThreshold): ?>
                                <div class="progress-info">
                                    <i class="fas fa-truck"></i>
                                    <span>Add $<?php echo e(number_format($freeThreshold - $subtotal, 2)); ?> more for FREE shipping!</span>
                                </div>
                                <div class="progress-bar-premium">
                                    <div class="progress-fill" style="width: <?php echo e(($subtotal / $freeThreshold) * 100); ?>%"></div>
                                </div>
                                <?php else: ?>
                                <div class="progress-info success">
                                    <i class="fas fa-check-circle"></i>
                                    <span>You qualify for FREE shipping!</span>
                                </div>
                                <?php endif; ?>
                            </div>

                            <a href="<?php echo e(route('checkout.index')); ?>" class="btn-checkout">
                                PROCEED TO CHECKOUT
                                <i class="fas fa-lock"></i>
                            </a>

                            <div class="payment-methods">
                                <p>WE ACCEPT</p>
                                <div class="payment-icons">
                                    <i class="fab fa-cc-visa"></i>
                                    <i class="fab fa-cc-mastercard"></i>
                                    <i class="fab fa-cc-paypal"></i>
                                    <i class="fab fa-cc-stripe"></i>
                                </div>
                            </div>

                            <div class="security-badges">
                                <div class="badge-item">
                                    <i class="fas fa-shield-alt"></i>
                                    <span>SECURE CHECKOUT</span>
                                </div>
                                <div class="badge-item">
                                    <i class="fas fa-lock"></i>
                                    <span>SSL ENCRYPTED</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
/* Cart Page Premium Styles */
.cart-page-premium {
    min-height: 100vh;
    padding-bottom: 4rem;
}

/* Cart Header */
.cart-header-premium {
    background: linear-gradient(135deg, #f8f8f8 0%, #ffffff 100%);
    padding: 3rem 0;
    text-align: center;
    border-bottom: 1px solid #e0e0e0;
    margin-bottom: 3rem;
}

.cart-title {
    font-size: 2.5rem;
    font-weight: 900;
    letter-spacing: 0.1em;
    margin-bottom: 1rem;
    font-family: 'Space Grotesk', sans-serif;
}

/* Alert Styles */
.alert-premium {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem 1.5rem;
    margin-bottom: 2rem;
    border-left: 4px solid;
    background: white;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    position: relative;
}

.alert-premium.success {
    border-color: #4CAF50;
    color: #4CAF50;
}

.alert-premium.error {
    border-color: #ff3333;
    color: #ff3333;
}

.alert-close {
    position: absolute;
    right: 1rem;
    background: none;
    border: none;
    color: inherit;
    cursor: pointer;
    opacity: 0.5;
    transition: opacity 0.3s;
}

.alert-close:hover {
    opacity: 1;
}

/* Empty Cart */
.empty-cart-section {
    min-height: 50vh;
    display: flex;
    align-items: center;
    justify-content: center;
}

.empty-cart-content {
    text-align: center;
    max-width: 400px;
}

.empty-cart-icon {
    font-size: 5rem;
    color: #e0e0e0;
    margin-bottom: 2rem;
}

.empty-cart-content h2 {
    font-size: 1.5rem;
    font-weight: 700;
    margin-bottom: 1rem;
    letter-spacing: 0.05em;
}

.empty-cart-content p {
    color: #666;
    margin-bottom: 2rem;
}

.btn-continue-shopping {
    display: inline-block;
    padding: 1rem 2rem;
    background: #000;
    color: white;
    text-decoration: none;
    font-weight: 600;
    letter-spacing: 0.05em;
    transition: all 0.3s;
}

.btn-continue-shopping:hover {
    background: #333;
    transform: translateY(-2px);
}

/* Cart Items Section */
.cart-items-section {
    background: white;
    border: 1px solid #e0e0e0;
    margin-bottom: 2rem;
}

.cart-items-header {
    padding: 1.5rem;
    border-bottom: 1px solid #e0e0e0;
}

.cart-items-header h3 {
    margin: 0;
    font-size: 1.125rem;
    font-weight: 700;
    letter-spacing: 0.05em;
}

/* Cart Item */
.cart-item-premium {
    display: grid;
    grid-template-columns: 100px 1fr 120px 150px 120px 50px;
    gap: 1.5rem;
    align-items: center;
    padding: 1.5rem;
    border-bottom: 1px solid #f0f0f0;
    transition: all 0.3s;
}

.cart-item-premium:hover {
    background: #fafafa;
}

.cart-item-image {
    width: 100px;
    height: 120px;
    overflow: hidden;
}

.cart-item-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.cart-item-details {
    flex: 1;
}

.item-name {
    font-size: 1rem;
    font-weight: 600;
    margin-bottom: 0.5rem;
}

.item-name a {
    color: #000;
    text-decoration: none;
    transition: all 0.3s;
}

.item-name a:hover {
    color: #666;
}

.item-attributes {
    display: flex;
    gap: 0.5rem;
    flex-wrap: wrap;
}

.attribute-tag {
    padding: 0.25rem 0.5rem;
    background: #f5f5f5;
    font-size: 0.75rem;
    color: #666;
}

.item-price-mobile {
    display: none;
    font-weight: 700;
    margin-top: 0.5rem;
}

.cart-item-price {
    font-weight: 600;
}

/* Quantity Control */
.quantity-control {
    display: flex;
    align-items: center;
    border: 1px solid #ddd;
}

.qty-decrease,
.qty-increase {
    width: 35px;
    height: 35px;
    background: white;
    border: none;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.3s;
}

.qty-decrease:hover,
.qty-increase:hover {
    background: #000;
    color: white;
}

.qty-value {
    width: 50px;
    height: 35px;
    border: none;
    text-align: center;
    font-weight: 600;
}

.cart-item-total {
    font-weight: 700;
    font-size: 1.125rem;
}

.btn-remove {
    background: none;
    border: none;
    color: #999;
    font-size: 1.25rem;
    cursor: pointer;
    transition: all 0.3s;
}

.btn-remove:hover {
    color: #ff3333;
}

/* Cart Actions */
.cart-actions {
    padding: 1.5rem;
    display: flex;
    justify-content: space-between;
    gap: 1rem;
}

.btn-secondary-premium {
    padding: 0.75rem 1.5rem;
    background: white;
    color: #000;
    border: 2px solid #000;
    text-decoration: none;
    font-weight: 600;
    letter-spacing: 0.05em;
    transition: all 0.3s;
}

.btn-secondary-premium:hover {
    background: #000;
    color: white;
}

.btn-clear-cart {
    padding: 0.75rem 1.5rem;
    background: #ff3333;
    color: white;
    border: none;
    font-weight: 600;
    letter-spacing: 0.05em;
    cursor: pointer;
    transition: all 0.3s;
}

.btn-clear-cart:hover {
    background: #cc0000;
}

/* Coupon Section */
.coupon-section-premium {
    background: white;
    border: 1px solid #e0e0e0;
    padding: 1.5rem;
}

.coupon-section-premium h4 {
    margin-bottom: 1rem;
    font-size: 1rem;
    font-weight: 700;
    letter-spacing: 0.05em;
}

.coupon-input-group {
    display: flex;
    gap: 1rem;
}

.coupon-input {
    flex: 1;
    padding: 0.75rem;
    border: 1px solid #ddd;
    font-size: 0.875rem;
}

.btn-apply-coupon {
    padding: 0.75rem 2rem;
    background: #000;
    color: white;
    border: none;
    font-weight: 600;
    letter-spacing: 0.05em;
    cursor: pointer;
    transition: all 0.3s;
}

.btn-apply-coupon:hover {
    background: #333;
}

.applied-coupon {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1rem;
    background: #f0fff0;
    border: 1px solid #4CAF50;
}

.coupon-info {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    color: #4CAF50;
    font-weight: 600;
}

.btn-remove-coupon {
    padding: 0.5rem 1rem;
    background: none;
    color: #ff3333;
    border: 1px solid #ff3333;
    font-size: 0.75rem;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s;
}

.btn-remove-coupon:hover {
    background: #ff3333;
    color: white;
}

/* Order Summary */
.order-summary-premium {
    background: white;
    border: 1px solid #e0e0e0;
    padding: 2rem;
    position: sticky;
    top: 100px;
}

.summary-title {
    font-size: 1.125rem;
    font-weight: 700;
    letter-spacing: 0.05em;
    margin-bottom: 1.5rem;
}

.summary-details {
    margin-bottom: 1.5rem;
}

.summary-row {
    display: flex;
    justify-content: space-between;
    padding: 0.75rem 0;
    font-size: 0.875rem;
}

.summary-row.discount {
    color: #4CAF50;
}

.summary-row.total {
    font-size: 1.125rem;
    font-weight: 700;
}

.free-shipping {
    color: #4CAF50;
    font-weight: 600;
}

.summary-divider {
    height: 1px;
    background: #e0e0e0;
    margin: 1rem 0;
}

/* Shipping Progress */
.shipping-progress {
    padding: 1rem;
    background: #f8f8f8;
    margin-bottom: 1.5rem;
}

.progress-info {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    margin-bottom: 0.5rem;
    font-size: 0.875rem;
}

.progress-info.success {
    color: #4CAF50;
}

.progress-bar-premium {
    height: 8px;
    background: #e0e0e0;
    border-radius: 4px;
    overflow: hidden;
}

.progress-fill {
    height: 100%;
    background: linear-gradient(90deg, #4CAF50 0%, #45a049 100%);
    transition: width 0.3s;
}

/* Checkout Button */
.btn-checkout {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
    width: 100%;
    padding: 1rem;
    background: #000;
    color: white;
    text-decoration: none;
    font-weight: 700;
    letter-spacing: 0.05em;
    transition: all 0.3s;
    margin-bottom: 1.5rem;
}

.btn-checkout:hover {
    background: #333;
    color: white;
    transform: translateY(-2px);
}

/* Payment Methods */
.payment-methods {
    text-align: center;
    padding: 1.5rem 0;
    border-top: 1px solid #e0e0e0;
    border-bottom: 1px solid #e0e0e0;
    margin-bottom: 1.5rem;
}

.payment-methods p {
    font-size: 0.75rem;
    font-weight: 600;
    letter-spacing: 0.1em;
    margin-bottom: 0.75rem;
    color: #666;
}

.payment-icons {
    display: flex;
    justify-content: center;
    gap: 1rem;
}

.payment-icons i {
    font-size: 2rem;
    color: #999;
}

/* Security Badges */
.security-badges {
    display: flex;
    justify-content: center;
    gap: 2rem;
}

.badge-item {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-size: 0.75rem;
    color: #666;
}

.badge-item i {
    color: #4CAF50;
}

/* Rate Display Styles */
.rate-info {
    padding: 0.5rem;
}

.rate-label {
    font-size: 0.75rem;
    color: #666;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.05em;
    margin-bottom: 0.25rem;
}

.rate-value {
    font-size: 1rem;
    font-weight: 700;
    color: #000;
    margin-bottom: 0.25rem;
}

.rate-location {
    font-size: 0.75rem;
    color: #999;
}

/* Responsive */
@media (max-width: 991px) {
    .cart-item-premium {
        grid-template-columns: 80px 1fr;
        gap: 1rem;
    }

    .cart-item-price {
        display: none;
    }

    .item-price-mobile {
        display: block;
    }

    .cart-item-quantity,
    .cart-item-total,
    .cart-item-remove {
        grid-column: span 2;
    }

    .cart-item-quantity {
        order: 3;
    }

    .cart-item-total {
        order: 4;
        font-size: 1.25rem;
        text-align: right;
    }

    .cart-item-remove {
        order: 5;
        text-align: right;
    }

    .order-summary-premium {
        position: static;
        margin-top: 2rem;
    }
}

@media (max-width: 576px) {
    .cart-title {
        font-size: 1.75rem;
    }

    .cart-actions {
        flex-direction: column;
    }

    .btn-secondary-premium,
    .btn-clear-cart {
        width: 100%;
    }
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Quantity controls
    document.querySelectorAll('.qty-decrease, .qty-increase').forEach(function(btn) {
        btn.addEventListener('click', function() {
            const form = this.closest('form');
            const input = form.querySelector('.qty-value');
            const currentVal = parseInt(input.value);
            const max = parseInt(input.max || 99);
            const cartItem = this.closest('.cart-item-premium');
            const itemId = cartItem.dataset.itemId;

            let newQuantity = currentVal;
            if (this.dataset.action === 'increase') {
                if (currentVal < max) {
                    newQuantity = currentVal + 1;
                    input.value = newQuantity;
                }
            } else {
                if (currentVal > 1) {
                    newQuantity = currentVal - 1;
                    input.value = newQuantity;
                }
            }

            // Only update if quantity changed
            if (newQuantity !== currentVal) {
                updateCartItemQuantity(itemId, newQuantity, form.action);
            }
        });
    });

    // Function to update cart item via AJAX
    function updateCartItemQuantity(itemId, quantity, actionUrl) {
        // Show loading state
        const cartItem = document.querySelector(`[data-item-id="${itemId}"]`);
        const quantityControls = cartItem.querySelector('.quantity-control');
        quantityControls.style.opacity = '0.6';
        quantityControls.style.pointerEvents = 'none';

        fetch(actionUrl, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'Accept': 'application/json',
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: JSON.stringify({
                quantity: quantity,
                _method: 'PATCH'
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Update individual item total
                const itemTotal = cartItem.querySelector('.cart-item-total');
                const itemPrice = parseFloat(cartItem.querySelector('.cart-item-price').textContent.replace('$', ''));
                itemTotal.textContent = '$' + (itemPrice * quantity).toFixed(2);

                // Update order summary
                const subtotalEl = document.getElementById('subtotalAmount');
                const taxEl = document.getElementById('taxAmount');
                const shippingEl = document.getElementById('shippingAmount');
                const totalEl = document.getElementById('totalAmount');

                if (subtotalEl && data.subtotal !== undefined) {
                    subtotalEl.textContent = '$' + data.subtotal;
                }
                if (taxEl && data.tax !== undefined) {
                    taxEl.textContent = '$' + data.tax;
                }
                if (shippingEl && data.shipping !== undefined) {
                    const shippingAmount = parseFloat(data.shipping);
                    if (shippingAmount === 0) {
                        shippingEl.innerHTML = '<span class="free-shipping">FREE</span>';
                    } else {
                        shippingEl.textContent = '$' + data.shipping;
                    }
                }
                if (totalEl && data.total !== undefined) {
                    totalEl.textContent = '$' + data.total;
                }

                // Update discount if present
                if (data.discount !== undefined) {
                    const discountRow = document.querySelector('.summary-row.discount');
                    const discountAmount = parseFloat(data.discount);
                    if (discountAmount > 0 && !discountRow) {
                        // Add discount row if it doesn't exist
                        const subtotalRow = document.querySelector('.summary-row');
                        const newDiscountRow = document.createElement('div');
                        newDiscountRow.className = 'summary-row discount';
                        newDiscountRow.innerHTML = `
                            <span>Discount</span>
                            <strong>-$${data.discount}</strong>
                        `;
                        subtotalRow.insertAdjacentElement('afterend', newDiscountRow);
                    } else if (discountAmount > 0 && discountRow) {
                        // Update existing discount row
                        discountRow.querySelector('strong').textContent = '-$' + data.discount;
                    }
                }

                // Update cart count in header if exists
                const cartCountBadge = document.querySelector('.cart-count-badge, .cart-badge, [data-cart-count]');
                if (cartCountBadge) {
                    fetch('<?php echo e(route("cart.count")); ?>')
                        .then(response => response.json())
                        .then(countData => {
                            cartCountBadge.textContent = countData.count;
                        });
                }

                // Show success message
                if (window.toastr) {
                    toastr.success('Cart updated successfully');
                }
            } else {
                // Reset quantity on error
                const input = cartItem.querySelector('.qty-value');
                const originalQuantity = quantity === parseInt(input.value) + 1 ? parseInt(input.value) - 1 : parseInt(input.value) + 1;
                input.value = originalQuantity;
                
                // Show error message
                const message = data.message || 'Failed to update cart';
                if (window.toastr) {
                    toastr.error(message);
                } else {
                    alert(message);
                }
            }
        })
        .catch(error => {
            console.error('Error updating cart:', error);
            
            // Reset quantity on error
            const input = cartItem.querySelector('.qty-value');
            const originalQuantity = quantity === parseInt(input.value) + 1 ? parseInt(input.value) - 1 : parseInt(input.value) + 1;
            input.value = originalQuantity;
            
            // Show error message
            if (window.toastr) {
                toastr.error('An error occurred while updating the cart');
            } else {
                alert('An error occurred while updating the cart');
            }
        })
        .finally(() => {
            // Remove loading state
            quantityControls.style.opacity = '1';
            quantityControls.style.pointerEvents = 'auto';
        });
    }

    // Handle direct input changes
    document.querySelectorAll('.qty-value').forEach(function(input) {
        input.addEventListener('change', function() {
            const form = this.closest('form');
            const cartItem = this.closest('.cart-item-premium');
            const itemId = cartItem.dataset.itemId;
            const newQuantity = parseInt(this.value);
            const min = parseInt(this.min || 1);
            const max = parseInt(this.max || 99);

            // Validate quantity
            if (newQuantity < min) {
                this.value = min;
                return;
            }
            if (newQuantity > max) {
                this.value = max;
                return;
            }

            updateCartItemQuantity(itemId, this.value, form.action);
        });

        // Remove readonly attribute to allow direct input
        input.removeAttribute('readonly');
    });

    // Clear cart confirmation
    window.clearCart = function() {
        if (confirm('Are you sure you want to clear your entire cart?')) {
            // Since there's no clear cart route defined, we'll remove items one by one
            const forms = document.querySelectorAll('.cart-item-remove form');
            if (forms.length > 0) {
                forms.forEach(form => form.submit());
            }
        }
    }

    // Shipping update (Premium)
    document.getElementById('updateShippingPremium')?.addEventListener('click', function() {
        const citySelect = document.getElementById('shippingCityPremium');
        if (!citySelect) return;

        const selectedOption = citySelect.options[citySelect.selectedIndex];
        const city = citySelect.value;
        const state = selectedOption ? selectedOption.dataset.state : '';
        const method = document.getElementById('shippingMethodPremium')?.value || 'standard';

        if (!city) {
            if (window.toastr) {
                toastr.warning('Please select a city/zone first.');
            } else {
                alert('Please select a city/zone first.');
            }
            return;
        }

        fetch('<?php echo e(route("cart.update-shipping")); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'Accept': 'application/json'
            },
            body: JSON.stringify({
                city: city,
                state: state,
                method: method
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Update displayed amounts
                const taxEl = document.getElementById('taxAmount');
                const taxLabel = document.getElementById('taxLabel');
                const shippingEl = document.getElementById('shippingAmount');
                const totalEl = document.getElementById('totalAmount');
                const shippingLabel = document.getElementById('shippingLabel');

                if (taxEl && data.tax !== undefined) {
                    taxEl.textContent = '$' + data.tax;
                }

                if (taxLabel && data.tax_rate_name && data.tax_rate_formatted) {
                    taxLabel.textContent = 'Tax (' + data.tax_rate_name + ' ' + data.tax_rate_formatted + ')';
                }

                if (shippingEl && data.shipping_raw !== undefined) {
                    if (Number(data.shipping_raw) === 0) {
                        shippingEl.innerHTML = '<span class="free-shipping">FREE</span>';
                    } else {
                        shippingEl.textContent = '$' + data.shipping;
                    }
                }

                if (shippingLabel) {
                    shippingLabel.textContent = (method ? method.charAt(0).toUpperCase() + method.slice(1) + ' to ' : 'Shipping to ') + city;
                }

                if (totalEl && data.total !== undefined) {
                    totalEl.textContent = '$' + data.total;
                }

                // Update current rates display
                const currentTaxRate = document.getElementById('currentTaxRate');
                const currentTaxLocation = document.getElementById('currentTaxLocation');
                const currentShippingMethod = document.getElementById('currentShippingMethod');
                const currentShippingLocation = document.getElementById('currentShippingLocation');

                if (currentTaxRate && data.tax_rate_name) {
                    currentTaxRate.textContent = data.tax_rate_name + ' ' + (data.tax_rate_formatted || '');
                }

                if (currentTaxLocation) {
                    currentTaxLocation.textContent = city + ', ' + state;
                }

                if (currentShippingMethod) {
                    currentShippingMethod.textContent = method.charAt(0).toUpperCase() + method.slice(1);
                }

                if (currentShippingLocation) {
                    currentShippingLocation.textContent = 'to ' + city;
                }

                // Show tax benefit notification for 0% tax locations
                if (data.tax_rate_percentage === 0) {
                    if (window.toastr) {
                        toastr.success('Great! You selected a Tax Free Zone - 0% tax on your order!');
                    }
                }

                // Update free shipping notice
                const freeNotice = document.getElementById('freeShippingNoticePremium');
                const freeThreshold = selectedOption.dataset.freeThreshold;
                if (freeNotice && freeThreshold) {
                    const threshold = Number(freeThreshold);
                    const subtotal = <?php echo e($subtotal); ?>;
                    if (subtotal < threshold) {
                        freeNotice.style.display = 'block';
                        freeNotice.className = 'alert alert-info mt-3 mb-0';
                        freeNotice.innerHTML = '<i class="fas fa-info-circle"></i> Add $' + (threshold - subtotal).toFixed(2) + ' more to qualify for free shipping to ' + city + '!';
                    } else {
                        freeNotice.style.display = 'block';
                        freeNotice.className = 'alert alert-success mt-3 mb-0';
                        freeNotice.innerHTML = '<i class="fas fa-check-circle"></i> You qualify for FREE shipping to ' + city + '!';
                    }
                }

                // Success notification
                if (window.toastr) {
                    toastr.success('Shipping updated');
                }
            } else {
                // Show error
                const msg = data.message || 'Could not update shipping. Please try again.';
                if (window.toastr) {
                    toastr.error(msg);
                } else {
                    alert(msg);
                }
            }
        })
        .catch(err => {
            console.error(err);
            if (window.toastr) {
                toastr.error('An error occurred while updating shipping.');
            } else {
                alert('An error occurred while updating shipping.');
            }
        });
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\export-portfolio6\resources\views/shop/cart.blade.php ENDPATH**/ ?>