<?php $__env->startSection('title', 'Fashion News Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Page Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3">Fashion News Management</h1>
            <p class="text-muted">Manage fashion news articles and industry updates</p>
        </div>
        <div>
            <a href="<?php echo e(route('trends.news')); ?>" class="btn btn-info me-2" target="_blank">
                <i class="fas fa-eye me-2"></i>View Live
            </a>
            <a href="<?php echo e(route('admin.trends.create-news')); ?>" class="btn btn-success">
                <i class="fas fa-plus me-2"></i>Add New Article
            </a>
        </div>
    </div>

    <!-- News Statistics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card border-start border-primary border-4">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="small fw-bold text-primary text-uppercase mb-1">Total Articles</div>
                            <div class="h5"><?php echo e(count($fashionNews)); ?></div>
                        </div>
                        <i class="fas fa-newspaper fa-2x text-primary"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-start border-success border-4">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="small fw-bold text-success text-uppercase mb-1">Brand News</div>
                            <div class="h5"><?php echo e(collect($fashionNews)->where('category', 'Brand News')->count()); ?></div>
                        </div>
                        <i class="fas fa-building fa-2x text-success"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-start border-info border-4">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="small fw-bold text-info text-uppercase mb-1">Industry News</div>
                            <div class="h5"><?php echo e(collect($fashionNews)->where('category', 'Industry News')->count()); ?></div>
                        </div>
                        <i class="fas fa-industry fa-2x text-info"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-start border-warning border-4">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="small fw-bold text-warning text-uppercase mb-1">Global Trends</div>
                            <div class="h5"><?php echo e(collect($fashionNews)->where('category', 'Global Trends')->count()); ?></div>
                        </div>
                        <i class="fas fa-globe fa-2x text-warning"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- News Articles List -->
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Fashion News Articles</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th style="width: 80px;">Image</th>
                            <th>Title</th>
                            <th style="width: 120px;">Category</th>
                            <th style="width: 100px;">Author</th>
                            <th style="width: 80px;">Read Time</th>
                            <th style="width: 120px;">Published</th>
                            <th style="width: 150px;" class="text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $fashionNews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <img src="<?php echo e(\App\Helpers\ImageHelper::getImageUrl($article['image'])); ?>" 
                                     class="rounded" 
                                     style="width: 60px; height: 60px; object-fit: cover;" 
                                     alt="<?php echo e($article['title']); ?>">
                            </td>
                            <td>
                                <h6 class="mb-1"><?php echo e($article['title']); ?></h6>
                                <p class="text-muted small mb-0"><?php echo e(Str::limit($article['excerpt'], 100)); ?></p>
                            </td>
                            <td>
                                <span class="badge 
                                    <?php if($article['category'] === 'Brand News'): ?> bg-primary
                                    <?php elseif($article['category'] === 'Industry News'): ?> bg-success
                                    <?php else: ?> bg-warning text-dark
                                    <?php endif; ?>
                                ">
                                    <?php if($article['category'] === 'Brand News'): ?>
                                        <i class="fas fa-building me-1"></i>
                                    <?php elseif($article['category'] === 'Industry News'): ?>
                                        <i class="fas fa-industry me-1"></i>
                                    <?php else: ?>
                                        <i class="fas fa-globe me-1"></i>
                                    <?php endif; ?>
                                    <?php echo e($article['category']); ?>

                                </span>
                            </td>
                            <td>
                                <span class="fw-bold"><?php echo e($article['author']); ?></span>
                            </td>
                            <td>
                                <span class="badge bg-light text-dark">
                                    <i class="fas fa-clock me-1"></i><?php echo e($article['read_time']); ?>m
                                </span>
                            </td>
                            <td>
                                <small class="text-muted">
                                    <?php echo e(date('M j, Y', strtotime($article['published_date']))); ?>

                                </small>
                            </td>
                            <td class="text-center">
                                <div class="btn-group" role="group">
                                    <a href="<?php echo e(route('trends.news.story', $article['slug'])); ?>" 
                                       class="btn btn-sm btn-outline-info" title="View" target="_blank">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="<?php echo e(route('admin.trends.edit-news', $article['slug'])); ?>" 
                                       class="btn btn-sm btn-outline-primary" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <button type="button" class="btn btn-sm btn-outline-danger" 
                                            onclick="confirmDelete('<?php echo e($article['slug']); ?>', '<?php echo e($article['title']); ?>')" 
                                            title="Delete">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="text-center py-5">
                                <i class="fas fa-newspaper fa-3x text-muted mb-3"></i>
                                <p class="text-muted">No fashion news articles found. Create your first article to get started!</p>
                                <a href="<?php echo e(route('admin.trends.create-news')); ?>" class="btn btn-success">
                                    <i class="fas fa-plus me-2"></i>Add New Article
                                </a>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Recent Activity -->
    <div class="row mt-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">Most Recent Articles</h6>
                </div>
                <div class="card-body">
                    <?php $__currentLoopData = array_slice($fashionNews, 0, 3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="d-flex align-items-center mb-3 <?php echo e(!$loop->last ? 'border-bottom pb-3' : ''); ?>">
                        <img src="<?php echo e(\App\Helpers\ImageHelper::getImageUrl($article['image'])); ?>" 
                             class="rounded me-3" 
                             style="width: 50px; height: 50px; object-fit: cover;" 
                             alt="<?php echo e($article['title']); ?>">
                        <div class="flex-grow-1">
                            <h6 class="mb-1 small"><?php echo e(Str::limit($article['title'], 60)); ?></h6>
                            <div class="d-flex align-items-center gap-2">
                                <span class="badge bg-light text-dark small"><?php echo e($article['category']); ?></span>
                                <small class="text-muted"><?php echo e($article['author']); ?></small>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">SEO Overview</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-6">
                            <div class="text-center">
                                <div class="h4 text-primary"><?php echo e(collect($fashionNews)->avg('read_time')); ?>m</div>
                                <small class="text-muted">Avg. Read Time</small>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="text-center">
                                <div class="h4 text-success"><?php echo e(count($fashionNews) * 1000); ?>+</div>
                                <small class="text-muted">Est. Words</small>
                            </div>
                        </div>
                    </div>
                    <hr>
                    <div class="mt-3">
                        <h6 class="small fw-bold">Top Keywords Coverage:</h6>
                        <div class="d-flex flex-wrap gap-1">
                            <span class="badge bg-light text-dark">Australian Fashion</span>
                            <span class="badge bg-light text-dark">Streetwear</span>
                            <span class="badge bg-light text-dark">Melbourne</span>
                            <span class="badge bg-light text-dark">Sydney</span>
                            <span class="badge bg-light text-dark">Sustainable Fashion</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Confirm Delete</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete the article "<span id="deleteArticleTitle"></span>"?</p>
                <p class="text-muted small">This action cannot be undone.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form id="deleteForm" method="POST" class="d-inline">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger">Delete Article</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function confirmDelete(slug, title) {
    document.getElementById('deleteArticleTitle').textContent = title;
    document.getElementById('deleteForm').action = `/admin/trends/news/${slug}`;
    new bootstrap.Modal(document.getElementById('deleteModal')).show();
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\export-portfolio7\resources\views/admin/trends/news.blade.php ENDPATH**/ ?>