<?php if(count($breadcrumbs) > 1): ?>
<!-- Breadcrumb Navigation with SEO Schema -->
<nav aria-label="breadcrumb" class="breadcrumb-nav py-2" style="background: #f8f9fa;">
    <div class="container">
        <ol class="breadcrumb mb-0">
            <?php $__currentLoopData = $breadcrumbs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $breadcrumb): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($key === count($breadcrumbs) - 1): ?>
                    <!-- Current page - no link -->
                    <li class="breadcrumb-item active" aria-current="page">
                        <span><?php echo e($breadcrumb['name']); ?></span>
                    </li>
                <?php else: ?>
                    <!-- Previous pages - with links -->
                    <li class="breadcrumb-item">
                        <a href="<?php echo e($breadcrumb['url']); ?>" class="text-decoration-none">
                            <?php echo e($breadcrumb['name']); ?>

                        </a>
                    </li>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ol>
    </div>
</nav>

<!-- JSON-LD Structured Data for SEO -->
<script type="application/ld+json">
<?php echo json_encode($jsonLd, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT); ?>

</script>

<?php if (! $__env->hasRenderedOnce('1b66ec28-3662-413d-be7f-814db4a10ad5')): $__env->markAsRenderedOnce('1b66ec28-3662-413d-be7f-814db4a10ad5'); ?>
<?php $__env->startPush('styles'); ?>
<style>
    .breadcrumb-nav {
        border-bottom: 1px solid rgba(0,0,0,0.1);
    }
    
    .breadcrumb {
        font-size: 0.875rem;
        margin-bottom: 0;
    }
    
    .breadcrumb-item + .breadcrumb-item::before {
        content: "›";
        color: #6c757d;
        font-weight: bold;
    }
    
    .breadcrumb-item a {
        color: #495057;
        transition: color 0.2s ease;
    }
    
    .breadcrumb-item a:hover {
        color: #007bff;
        text-decoration: none !important;
    }
    
    .breadcrumb-item.active span {
        color: #6c757d;
        font-weight: 500;
    }
    
    @media (max-width: 768px) {
        .breadcrumb {
            font-size: 0.75rem;
        }
        
        .breadcrumb-item span,
        .breadcrumb-item a {
            max-width: 120px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
            display: inline-block;
            vertical-align: top;
        }
    }
</style>
<?php $__env->stopPush(); ?>
<?php endif; ?>
<?php endif; ?><?php /**PATH C:\xampp\htdocs\export-portfolio6\resources\views/components/breadcrumb.blade.php ENDPATH**/ ?>