<?php

// app/Http/Controllers/Admin/CompanyInfoController.php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\CompanyInfo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class CompanyInfoController extends Controller
{
    public function edit()
    {
        $companyInfo = CompanyInfo::getInfo();
        return view('admin.company.edit', compact('companyInfo'));
    }

    public function update(Request $request)
    {
        $validated = $request->validate([
            'company_name' => 'required|string|max:255',
            'about_us' => 'required|string',
            'mission' => 'required|string',
            'vision' => 'required|string',
            'phone' => 'required|string|max:20',
            'email' => 'required|email',
            'address' => 'required|string',
            'logo' => 'nullable|image|max:2048',
            'favicon' => 'nullable|image|mimes:ico,png,jpg,jpeg,gif|max:1024',
            'whatsapp' => 'nullable|string|max:20',
            'export_countries' => 'nullable|string',
            'years_experience' => 'nullable|integer|min:0',
            'happy_clients' => 'nullable|integer|min:0',
            'products_count' => 'nullable|integer|min:0',
            'social_links' => 'nullable|array',
            'social_links.facebook' => 'nullable|url',
            'social_links.twitter' => 'nullable|url',
            'social_links.linkedin' => 'nullable|url',
            'social_links.instagram' => 'nullable|url',
            'social_links.tiktok' => 'nullable|url',
            'social_links.youtube' => 'nullable|url'
        ]);

        $companyInfo = CompanyInfo::getInfo();

        if ($request->hasFile('logo')) {
            if ($companyInfo->logo) {
                Storage::disk('public')->delete($companyInfo->logo);
            }
            $validated['logo'] = $request->file('logo')->store('company', 'public');
        }

        if ($request->hasFile('favicon')) {
            if ($companyInfo->favicon) {
                Storage::disk('public')->delete($companyInfo->favicon);
            }
            $validated['favicon'] = $request->file('favicon')->store('company', 'public');
        }

        $companyInfo->update($validated);

        return redirect()->route('admin.company.edit')
            ->with('success', 'Company information updated successfully');
    }
}

?>