<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Product;
use App\Models\Category;
use App\Models\Order;
use App\Models\User;
use App\Models\Inquiry;
use App\Models\Testimonial;

class DashboardController extends Controller
{
    public function index()
    {
        // Get statistics
        $stats = [
            'products' => Product::count(),
            'categories' => Category::count(),
            'orders' => Order::count(),
            'customers' => User::where('is_admin', false)->count(),
            'inquiries' => Inquiry::where('status', 'new')->count(),
            'testimonials' => Testimonial::count(),
            'revenue' => Order::where('payment_status', 'paid')->sum('total_amount'),
            'pending_orders' => Order::where('status', 'pending')->count(),
        ];
        
        // Get recent orders
        $recentOrders = Order::with(['user', 'items'])
            ->latest()
            ->take(5)
            ->get();
        
        // Get recent inquiries
        $recentInquiries = Inquiry::with('product')
            ->where('status', 'new')
            ->latest()
            ->take(5)
            ->get();
        
        // Get popular products
        $popularProducts = Product::orderBy('views', 'desc')
            ->take(5)
            ->get();
        
        // Get revenue data for chart (last 7 days)
        $revenueData = [];
        for ($i = 6; $i >= 0; $i--) {
            $date = now()->subDays($i);
            $revenueData[] = [
                'date' => $date->format('M d'),
                'amount' => Order::whereDate('created_at', $date->toDateString())
                    ->where('payment_status', 'paid')
                    ->sum('total_amount')
            ];
        }
        
        return view('admin.dashboard', compact('stats', 'recentOrders', 'recentInquiries', 'popularProducts', 'revenueData'));
    }
}