<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Auth\Events\Verified;
use Illuminate\Foundation\Auth\EmailVerificationRequest;
use Illuminate\Http\RedirectResponse;

class VerifyEmailController extends Controller
{
    /**
     * Mark the authenticated user's email address as verified.
     */
    public function __invoke(EmailVerificationRequest $request): RedirectResponse
    {
        if ($request->user()->hasVerifiedEmail()) {
            // Direct redirect based on user role
            if ($request->user()->is_admin) {
                return redirect('/admin/dashboard?verified=1');
            }
            return redirect('/account/dashboard?verified=1');
        }

        if ($request->user()->markEmailAsVerified()) {
            event(new Verified($request->user()));
        }

        // Direct redirect based on user role after verification
        if ($request->user()->is_admin) {
            return redirect('/admin/dashboard?verified=1');
        }
        return redirect('/account/dashboard?verified=1');
    }
}