<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\Category;

class CityPagesController extends Controller
{
    /**
     * Melbourne streetwear page
     */
    public function melbourne()
    {
        $cityData = [
            'name' => 'Melbourne',
            'meta_title' => 'Melbourne Streetwear | Cultural Fashion | Edition By Punjab Australia',
            'meta_description' => 'Discover Melbourne streetwear culture with Edition By Punjab. Premium cultural fusion fashion, sustainable hoodies, and authentic Punjabi-inspired designs in Melbourne.',
            'keywords' => 'melbourne streetwear, streetwear melbourne, cultural fashion melbourne, punjabi streetwear melbourne, sustainable fashion melbourne, streetwear brands melbourne',
            'hero_title' => 'Melbourne Streetwear Culture',
            'hero_subtitle' => 'Where Art Meets Street Fashion',
            'hero_description' => 'Melbourne\'s diverse cultural landscape makes it Australia\'s streetwear capital. Discover how Edition By Punjab fits perfectly into Melbourne\'s artistic and multicultural fashion scene.',
            'population' => '5.2M',
            'fashion_districts' => 4,
            'cultural_diversity' => '40%',
            'streetwear_growth' => '85%',
            'city_intro' => 'Melbourne, Australia\'s cultural capital, has always been at the forefront of fashion innovation. The city\'s lane ways, coffee culture, and diverse communities create the perfect backdrop for authentic streetwear expression.',
            
            'fashion_districts' => [
                [
                    'name' => 'Fitzroy & Collingwood',
                    'description' => 'The heart of Melbourne\'s alternative fashion scene, where independent designers and vintage stores thrive.',
                    'vibe' => 'Alternative & Artistic',
                    'best_for' => 'Unique streetwear finds and cultural fashion'
                ],
                [
                    'name' => 'Chapel Street, Prahran',
                    'description' => 'Premier shopping destination mixing high-end fashion with accessible streetwear brands.',
                    'vibe' => 'Premium & Trendy',
                    'best_for' => 'Designer streetwear and contemporary fashion'
                ],
                [
                    'name' => 'Brunswick Street',
                    'description' => 'Bohemian shopping strip perfect for cultural fashion and sustainable clothing brands.',
                    'vibe' => 'Bohemian & Sustainable',
                    'best_for' => 'Ethical fashion and cultural expression'
                ],
                [
                    'name' => 'Collins Street',
                    'description' => 'Melbourne\'s premium shopping precinct where streetwear meets luxury fashion.',
                    'vibe' => 'Luxury & Sophisticated',
                    'best_for' => 'High-end streetwear and designer pieces'
                ]
            ],

            'style_characteristics' => [
                [
                    'title' => 'Layering Masters',
                    'description' => 'Melbourne\'s unpredictable weather has created a culture of expert layering, perfect for versatile streetwear pieces.'
                ],
                [
                    'title' => 'Cultural Fusion',
                    'description' => 'With 40% of residents born overseas, Melbourne embraces cultural fashion that tells personal stories.'
                ],
                [
                    'title' => 'Sustainable Focus',
                    'description' => 'Melbourne leads Australia in sustainable fashion adoption, with 70% of young consumers prioritizing ethical brands.'
                ],
                [
                    'title' => 'Street Art Influence',
                    'description' => 'The city\'s famous street art culture heavily influences fashion choices, favoring bold graphics and artistic designs.'
                ]
            ],

            'local_trends' => [
                [
                    'trend' => 'Heritage Graphics',
                    'description' => 'Cultural symbols and traditional patterns integrated into contemporary streetwear designs',
                    'popularity' => 92
                ],
                [
                    'trend' => 'Weather-Adaptive Layers',
                    'description' => 'Versatile pieces that transition from Melbourne\'s cool mornings to warm afternoons',
                    'popularity' => 89
                ],
                [
                    'trend' => 'Sustainable Materials',
                    'description' => 'Organic cotton, recycled polyester, and eco-friendly production methods',
                    'popularity' => 86
                ],
                [
                    'trend' => 'Artistic Collaborations',
                    'description' => 'Streetwear brands partnering with local street artists for unique designs',
                    'popularity' => 84
                ]
            ],

            'featured_products' => [
                'cultural_hoodies' => 'Heritage-inspired hoodies perfect for Melbourne\'s cool climate',
                'layering_tees' => 'Premium cotton tees ideal for Melbourne\'s layering culture',
                'sustainable_joggers' => 'Eco-friendly joggers for Melbourne\'s active lifestyle',
                'artistic_accessories' => 'Caps and bags featuring cultural artistic designs'
            ],

            'why_edition_fits' => [
                'Cultural authenticity resonates with Melbourne\'s diverse communities',
                'Sustainable production aligns with Melbourne\'s environmental consciousness',
                'Quality fabrics perfect for Melbourne\'s variable weather',
                'Artistic heritage designs complement the city\'s creative culture',
                'Premium streetwear suitable for Melbourne\'s fashion-forward scene'
            ],

            'local_seo_terms' => [
                'streetwear melbourne',
                'melbourne fashion brands',
                'cultural clothing melbourne',
                'sustainable streetwear melbourne',
                'punjabi fashion melbourne',
                'melbourne street style',
                'ethical fashion melbourne',
                'streetwear stores melbourne'
            ]
        ];

        $relatedProducts = Product::where('is_featured', true)->limit(8)->get();

        return view('city-pages.melbourne', compact('cityData', 'relatedProducts'));
    }

    /**
     * Sydney fashion page
     */
    public function sydney()
    {
        $cityData = [
            'name' => 'Sydney',
            'meta_title' => 'Sydney Fashion | Beach Streetwear | Edition By Punjab Australia',
            'meta_description' => 'Sydney fashion meets cultural streetwear. Discover Edition By Punjab\'s beach-to-city fashion, sustainable hoodies, and Punjabi fusion designs perfect for Sydney lifestyle.',
            'keywords' => 'sydney fashion, sydney streetwear, beach fashion sydney, cultural fashion sydney, punjabi streetwear sydney, sustainable clothing sydney, fashion brands sydney',
            'hero_title' => 'Sydney Fashion Scene',
            'hero_subtitle' => 'Where Beach Meets Street Culture',
            'hero_description' => 'Sydney\'s laid-back beach culture and cosmopolitan energy create a unique fashion landscape. See how Edition By Punjab brings cultural authenticity to Sydney\'s effortless style.',
            'population' => '5.3M',
            'fashion_districts' => 5,
            'beach_influence' => '75%',
            'cultural_diversity' => '45%',
            'city_intro' => 'Sydney\'s fashion scene perfectly balances relaxed beach vibes with sophisticated city style. The harbour city\'s multicultural population embraces fashion that\'s both comfortable and culturally expressive.',
            
            'fashion_districts' => [
                [
                    'name' => 'Surry Hills',
                    'description' => 'Creative hub where emerging designers showcase innovative streetwear and cultural fashion.',
                    'vibe' => 'Creative & Emerging',
                    'best_for' => 'Independent brands and cultural streetwear'
                ],
                [
                    'name' => 'Newtown',
                    'description' => 'Alternative fashion destination known for vintage, sustainable, and culturally diverse clothing.',
                    'vibe' => 'Alternative & Sustainable',
                    'best_for' => 'Unique finds and ethical fashion'
                ],
                [
                    'name' => 'Bondi & Beach Areas',
                    'description' => 'Beach lifestyle fashion meets streetwear, perfect for Sydney\'s outdoor culture.',
                    'vibe' => 'Beach & Lifestyle',
                    'best_for' => 'Beach-to-street transitional pieces'
                ],
                [
                    'name' => 'CBD & Martin Place',
                    'description' => 'Business district where professional meets casual in modern Australian fashion.',
                    'vibe' => 'Professional & Modern',
                    'best_for' => 'Smart-casual streetwear'
                ],
                [
                    'name' => 'Paddington',
                    'description' => 'Upmarket area featuring boutique fashion and designer streetwear brands.',
                    'vibe' => 'Boutique & Designer',
                    'best_for' => 'Premium streetwear and designer pieces'
                ]
            ],

            'style_characteristics' => [
                [
                    'title' => 'Beach-to-Street Versatility',
                    'description' => 'Sydney fashion prioritizes pieces that transition seamlessly from beach to city, day to night.'
                ],
                [
                    'title' => 'Relaxed Sophistication',
                    'description' => 'The perfect blend of laid-back beach culture and cosmopolitan city sophistication.'
                ],
                [
                    'title' => 'Cultural Celebration',
                    'description' => 'Sydney\'s diverse population celebrates cultural heritage through fashion choices and brand support.'
                ],
                [
                    'title' => 'Sun-Smart Fashion',
                    'description' => 'UV protection and breathable fabrics are essential in Sydney\'s strong sun and outdoor lifestyle.'
                ]
            ],

            'local_trends' => [
                [
                    'trend' => 'Beach-Street Fusion',
                    'description' => 'Clothing that works for beach mornings and city afternoons',
                    'popularity' => 94
                ],
                [
                    'trend' => 'Cultural Pride Wear',
                    'description' => 'Fashion that celebrates diverse cultural heritage and identity',
                    'popularity' => 88
                ],
                [
                    'trend' => 'UV-Smart Streetwear',
                    'description' => 'Stylish protection from Australia\'s intense sun',
                    'popularity' => 87
                ],
                [
                    'trend' => 'Sustainable Luxury',
                    'description' => 'Premium quality meets environmental responsibility',
                    'popularity' => 85
                ]
            ],

            'featured_products' => [
                'beach_hoodies' => 'Lightweight hoodies perfect for Sydney\'s beach-to-city lifestyle',
                'cultural_tees' => 'Heritage-inspired tees ideal for Sydney\'s cultural diversity',
                'uv_protection' => 'Stylish UV protection for Sydney\'s outdoor lifestyle',
                'versatile_joggers' => 'Comfortable joggers that transition from beach to street'
            ],

            'why_edition_fits' => [
                'Beach-to-street versatility perfect for Sydney lifestyle',
                'Cultural authenticity valued in Sydney\'s diverse communities',
                'Premium quality materials suitable for Sydney\'s climate',
                'UV-protective fabrics essential for Australian sun',
                'Sustainable practices align with Sydney\'s progressive values'
            ],

            'local_seo_terms' => [
                'sydney fashion',
                'sydney streetwear',
                'beach fashion sydney',
                'cultural fashion sydney',
                'sustainable clothing sydney',
                'fashion brands sydney',
                'streetwear stores sydney',
                'sydney street style'
            ]
        ];

        $relatedProducts = Product::where('is_featured', true)->limit(8)->get();

        return view('city-pages.sydney', compact('cityData', 'relatedProducts'));
    }

    /**
     * Where to buy streetwear in Australia - Long-tail keyword page
     */
    public function whereToBuyStreetWear()
    {
        $pageData = [
            'meta_title' => 'Where to Buy Streetwear in Australia 2024 | Best Online & Physical Stores',
            'meta_description' => 'Complete guide to buying streetwear in Australia. Top online stores, physical locations, Australian brands, and shopping tips for authentic street fashion.',
            'keywords' => 'where to buy streetwear australia, buy streetwear online australia, australian streetwear stores, streetwear shopping australia',
            'hero_title' => 'Where to Buy Streetwear in Australia',
            'hero_subtitle' => 'Your Complete Shopping Guide',
            
            'online_stores' => [
                [
                    'name' => 'Edition By Punjab',
                    'description' => 'Premium cultural fusion streetwear with authentic heritage designs',
                    'speciality' => 'Cultural streetwear, sustainable fashion',
                    'shipping' => 'Free shipping Australia-wide over $100',
                    'unique_selling' => 'Authentic Punjabi-inspired designs, sustainable materials'
                ],
                [
                    'name' => 'Major Online Retailers',
                    'description' => 'ASOS, The Iconic, Surfstitch - Wide selection of international brands',
                    'speciality' => 'International streetwear brands',
                    'pros' => ['Wide selection', 'Frequent sales', 'Easy returns']
                ],
                [
                    'name' => 'Local Australian Brands Online',
                    'description' => 'Ksubi, Thrills, Afends - Supporting local Australian streetwear',
                    'speciality' => 'Australian-made streetwear',
                    'pros' => ['Local support', 'Climate-appropriate', 'Unique designs']
                ]
            ],

            'physical_locations' => [
                [
                    'city' => 'Melbourne',
                    'areas' => ['Fitzroy', 'Collingwood', 'Chapel Street', 'Brunswick Street'],
                    'best_for' => 'Alternative and cultural streetwear'
                ],
                [
                    'city' => 'Sydney',
                    'areas' => ['Surry Hills', 'Newtown', 'Bondi', 'Paddington'],
                    'best_for' => 'Beach-to-street fashion'
                ],
                [
                    'city' => 'Brisbane',
                    'areas' => ['Fortitude Valley', 'West End', 'South Bank'],
                    'best_for' => 'Tropical climate streetwear'
                ],
                [
                    'city' => 'Perth',
                    'areas' => ['Fremantle', 'Subiaco', 'Mount Lawley'],
                    'best_for' => 'Relaxed coastal streetwear'
                ]
            ],

            'shopping_tips' => [
                'Check sizing guides - Australian sizes can differ from international',
                'Look for UV protection in streetwear for Australian climate',
                'Support local brands that understand Australian culture',
                'Consider sustainable options - good for environment and longevity',
                'Read reviews from other Australian customers',
                'Check shipping times and return policies for online orders',
                'Follow brands on social media for exclusive drops and sales'
            ],

            'budget_ranges' => [
                [
                    'range' => '$30-60',
                    'items' => 'Basic tees, caps, accessories',
                    'where' => 'Chain stores, online retailers'
                ],
                [
                    'range' => '$60-120',
                    'items' => 'Quality hoodies, premium tees, joggers',
                    'where' => 'Mid-range brands, local designers'
                ],
                [
                    'range' => '$120+',
                    'items' => 'Designer pieces, limited editions',
                    'where' => 'Premium brands, boutique stores'
                ]
            ]
        ];

        return view('city-pages.where-to-buy-streetwear', compact('pageData'));
    }

    /**
     * Punjabi fusion streetwear online - Long-tail keyword page
     */
    public function punjabieFusionStreetWear()
    {
        $pageData = [
            'meta_title' => 'Punjabi Fusion Streetwear Online Australia | Cultural Fashion 2024',
            'meta_description' => 'Shop authentic Punjabi fusion streetwear online in Australia. Traditional meets modern in hoodies, tees, and accessories celebrating Punjabi heritage.',
            'keywords' => 'punjabi fusion streetwear, punjabi streetwear online australia, cultural fusion fashion, punjabi clothing australia, traditional meets modern fashion',
            'hero_title' => 'Punjabi Fusion Streetwear',
            'hero_subtitle' => 'Where Heritage Meets Street Culture',
            
            'what_is_fusion' => [
                'Traditional Punjabi elements like Phulkari embroidery patterns',
                'Modern streetwear silhouettes and fits',
                'Cultural color palettes with contemporary styling',
                'Heritage typography mixed with street graphics',
                'Sacred symbols respectfully integrated into designs'
            ],

            'popular_items' => [
                [
                    'item' => 'Heritage Hoodies',
                    'description' => 'Comfortable hoodies featuring traditional Punjabi patterns and motifs',
                    'cultural_element' => 'Phulkari-inspired designs, Gurmukhi script',
                    'price_range' => '$80-150'
                ],
                [
                    'item' => 'Cultural Print Tees',
                    'description' => 'Premium tees celebrating Punjabi culture with modern aesthetics',
                    'cultural_element' => 'Traditional symbols, Punjabi quotes, heritage colors',
                    'price_range' => '$45-80'
                ],
                [
                    'item' => 'Fusion Joggers',
                    'description' => 'Comfortable joggers with subtle cultural detailing',
                    'cultural_element' => 'Traditional patterns as side stripes or pocket details',
                    'price_range' => '$70-120'
                ],
                [
                    'item' => 'Cultural Accessories',
                    'description' => 'Caps, bags, and jewelry celebrating Punjabi heritage',
                    'cultural_element' => 'Khanda symbols, traditional colors, heritage fonts',
                    'price_range' => '$25-60'
                ]
            ],

            'why_choose_fusion' => [
                'Express cultural pride in contemporary fashion',
                'Bridge traditional heritage with modern lifestyle',
                'Start conversations about cultural diversity',
                'Support brands that respect and celebrate culture',
                'Wear pieces with deeper meaning and story'
            ],

            'styling_tips' => [
                'Pair cultural hoodies with neutral basics for balance',
                'Layer heritage tees under blazers for smart-casual looks',
                'Mix cultural accessories with existing wardrobe pieces',
                'Choose one statement cultural piece per outfit',
                'Respect the cultural significance while enjoying the style'
            ]
        ];

        $featuredProducts = Product::where('is_featured', true)->limit(6)->get();

        return view('city-pages.punjabi-fusion-streetwear', compact('pageData', 'featuredProducts'));
    }

    /**
     * FAQ page for common queries
     */
    public function faq()
    {
        $faqs = [
            [
                'category' => 'Ordering & Shipping',
                'questions' => [
                    [
                        'q' => 'Do you ship Australia-wide?',
                        'a' => 'Yes! We offer free shipping across Australia for orders over $100. Standard shipping takes 3-7 business days, with express options available.'
                    ],
                    [
                        'q' => 'Can I track my order?',
                        'a' => 'Absolutely. Once your order ships, you\'ll receive a tracking number via email to monitor your package\'s progress.'
                    ],
                    [
                        'q' => 'What if I need to change my shipping address?',
                        'a' => 'Contact us within 2 hours of placing your order, and we\'ll do our best to update the shipping address before processing.'
                    ]
                ]
            ],
            [
                'category' => 'Sizing & Fit',
                'questions' => [
                    [
                        'q' => 'How do I choose the right size?',
                        'a' => 'Check our detailed size guides for each product category. We provide measurements in cm for chest, length, and shoulder. When in doubt, size up for a relaxed streetwear fit.'
                    ],
                    [
                        'q' => 'Do your clothes shrink after washing?',
                        'a' => 'Our premium cotton may shrink 2-3cm after the first wash. We account for this in our sizing. Always wash in cold water and air dry when possible.'
                    ],
                    [
                        'q' => 'What if the size doesn\'t fit?',
                        'a' => 'We offer easy exchanges within 30 days. Just ensure items are unworn with tags attached. We\'ll cover return shipping for size exchanges.'
                    ]
                ]
            ],
            [
                'category' => 'Cultural & Ethical',
                'questions' => [
                    [
                        'q' => 'How do you ensure cultural authenticity in your designs?',
                        'a' => 'Our designs are created with deep respect for Punjabi culture, consulting with community members and cultural experts to ensure authentic representation.'
                    ],
                    [
                        'q' => 'Are your products ethically made?',
                        'a' => 'Yes, we prioritize ethical manufacturing, fair wages, and sustainable materials. We regularly audit our supply chain to maintain these standards.'
                    ],
                    [
                        'q' => 'Do you support local communities?',
                        'a' => 'We actively support Punjabi cultural organizations in Australia and donate a portion of profits to cultural preservation initiatives.'
                    ]
                ]
            ],
            [
                'category' => 'Product Care',
                'questions' => [
                    [
                        'q' => 'How should I care for my cultural print items?',
                        'a' => 'Turn inside out when washing, use cold water, and avoid bleach. Air dry when possible and iron on low heat to preserve print quality.'
                    ],
                    [
                        'q' => 'Will the prints fade over time?',
                        'a' => 'We use high-quality, fade-resistant inks. With proper care, your prints will maintain their vibrancy for years.'
                    ],
                    [
                        'q' => 'Can I machine wash hoodies?',
                        'a' => 'Yes, but use cold water and gentle cycle. Avoid fabric softener for the first few washes to maintain shape and print quality.'
                    ]
                ]
            ],
            [
                'category' => 'Returns & Exchanges',
                'questions' => [
                    [
                        'q' => 'What is your return policy?',
                        'a' => '30-day returns on unworn items with original tags. We provide prepaid return labels for defective items or sizing issues.'
                    ],
                    [
                        'q' => 'How long do refunds take?',
                        'a' => 'Refunds are processed within 3-5 business days of receiving your return. You\'ll receive email confirmation once processed.'
                    ],
                    [
                        'q' => 'Can I return sale items?',
                        'a' => 'Sale items can be returned for store credit or exchange only. Full-price items can be returned for a full refund.'
                    ]
                ]
            ]
        ];

        return view('city-pages.faq', compact('faqs'));
    }
}