<?php

namespace App\Http\Controllers;

use App\Models\LegalPage;
use Illuminate\Http\Request;

class LegalPageController extends Controller
{
    /**
     * Display a listing of legal pages.
     */
    public function index()
    {
        $legalPages = LegalPage::where('is_active', true)->orderBy('title')->get();
        
        return view('legal.index', compact('legalPages'));
    }

    /**
     * Display the specified legal page.
     */
    public function show($slug)
    {
        $legalPage = LegalPage::where('slug', $slug)
                              ->where('is_active', true)
                              ->firstOrFail();
        
        return view('legal.show', compact('legalPage'));
    }
}
