<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class AdminMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Check if user is authenticated
        if (!Auth::check()) {
            // Store the intended URL for admin area
            session(['url.intended' => $request->url()]);
            return redirect()->route('login')->with('error', 'Please login to access admin panel.');
        }

        // Get the authenticated user
        $user = Auth::user();

        // Check if user is blocked
        if ($user->is_blocked) {
            Auth::logout();
            return redirect()->route('login')->with('error', 'Your account has been blocked. Please contact support.');
        }

        // Check if user is admin
        if (!$user->is_admin) {
            // Non-admin users trying to access admin area
            return redirect('/account/dashboard')->with('error', 'You do not have admin access.');
        }

        return $next($request);
    }
}