<?php

namespace App\Http\Middleware;

use App\Providers\RouteServiceProvider;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class RedirectIfAuthenticated
{
    /**
     * Handle an incoming request.
     * This middleware is used for guest routes (login, register, etc.)
     * It redirects already authenticated users to their appropriate dashboard
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next, string ...$guards): Response
    {
        $guards = empty($guards) ? [null] : $guards;

        foreach ($guards as $guard) {
            if (Auth::guard($guard)->check()) {
                $user = Auth::guard($guard)->user();
                
                // Check if user is blocked
                if ($user->is_blocked) {
                    Auth::guard($guard)->logout();
                    return redirect()->route('login')->with('error', 'Your account has been blocked.');
                }
                
                // Direct redirect based on user role
                if ($user->is_admin) {
                    return redirect('/admin/dashboard');
                }
                
                return redirect('/account/dashboard');
            }
        }

        return $next($request);
    }
}