<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CommunityPage extends Model
{
    use HasFactory;

    protected $fillable = [
        'page_key',
        'title',
        'content',
        'images',
        'meta_title',
        'meta_description',
        'is_active'
    ];

    protected $casts = [
        'images' => 'array',
        'is_active' => 'boolean',
    ];

    public function getImagesAttribute($value)
    {
        return $value ? json_decode($value, true) : [];
    }

    public function setImagesAttribute($value)
    {
        $this->attributes['images'] = is_array($value) ? json_encode($value) : $value;
    }

    /**
     * Get image URLs using ImageHelper
     */
    public function getImageUrlsAttribute()
    {
        if (empty($this->images)) {
            return [];
        }

        return array_map(function ($imagePath) {
            return \App\Helpers\ImageHelper::getImageUrl($imagePath);
        }, $this->images);
    }

    /**
     * Get first image URL using ImageHelper
     */
    public function getFirstImageUrlAttribute()
    {
        $imageUrls = $this->image_urls;
        return !empty($imageUrls) ? $imageUrls[0] : null;
    }
}
