<?php

// app/Models/CompanyInfo.php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CompanyInfo extends Model
{
    use HasFactory;

    protected $table = 'company_info';

    protected $fillable = [
        'company_name', 'about_us', 'mission', 'vision',
        'phone', 'email', 'address', 'logo', 'favicon', 'social_links',
        'whatsapp', 'export_countries', 'years_experience',
        'happy_clients', 'products_count'
    ];

    protected $casts = [
        'social_links' => 'array',
    ];

    public static function getInfo()
    {
        return self::first() ?? self::create([
            'company_name' => 'Your Company Name',
            'about_us' => 'Leading manufacturer and exporter',
            'mission' => 'Our mission statement',
            'vision' => 'Our vision statement',
            'phone' => '+1234567890',
            'email' => 'info@company.com',
            'address' => 'Your Address',
            'years_experience' => 10,
            'happy_clients' => 500,
            'products_count' => 100
        ]);
    }
}