<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NewsletterSubscriber extends Model
{
    use HasFactory;

    protected $fillable = [
        'email',
        'name',
        'is_active',
        'discount_code',
        'discount_used',
        'subscribed_at'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'discount_used' => 'boolean',
        'subscribed_at' => 'datetime',
    ];

    public function generateDiscountCode()
    {
        $this->discount_code = 'NEWS' . strtoupper(substr(md5($this->email . time()), 0, 6));
        $this->save();
        return $this->discount_code;
    }
}