<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class OrderItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'order_id', 
        'product_id', 
        'product_name', 
        'product_sku',
        'product_image',
        'price', 
        'quantity', 
        'total', 
        'subtotal',
        'attributes',
        'product_options'
    ];

    protected $casts = [
        'price' => 'decimal:2',
        'total' => 'decimal:2',
        'subtotal' => 'decimal:2',
        'attributes' => 'array',
        'product_options' => 'array'
    ];

    public function order()
    {
        return $this->belongsTo(Order::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    /**
     * Get formatted attributes for display
     */
    public function getFormattedAttributesAttribute()
    {
        $attributes = $this->attributes ?? $this->product_options ?? [];
        
        if (empty($attributes)) {
            return '';
        }

        $formatted = [];
        foreach ($attributes as $key => $value) {
            $formatted[] = ucfirst($key) . ': ' . $value;
        }

        return implode(', ', $formatted);
    }

    /**
     * Get item subtotal
     */
    public function getItemSubtotalAttribute()
    {
        return $this->subtotal ?? $this->total ?? ($this->price * $this->quantity);
    }
}