<?php

// app/Models/Testimonial.php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Testimonial extends Model
{
    use HasFactory;

    protected $fillable = [
        'client_name', 'client_position', 'client_company',
        'client_country', 'content', 'rating', 'client_image', 'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'rating' => 'integer'
    ];

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }
}