<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Blade;
use App\Services\ImageOptimizer;
use App\Services\InternalLinkingService;

class SEOServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        // Register SEO services
        $this->app->singleton(ImageOptimizer::class);
        $this->app->singleton(InternalLinkingService::class);
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        // Register Blade components
        Blade::component('lazy-image', \App\View\Components\LazyImage::class);
        Blade::component('breadcrumb', \App\View\Components\Breadcrumb::class);
        Blade::component('related-content', \App\View\Components\RelatedContent::class);
        Blade::component('mobile-optimizer', \App\View\Components\MobileOptimizer::class);
        
        // Register Blade directives for SEO
        Blade::directive('seoTitle', function ($expression) {
            return "<?php echo htmlspecialchars($expression ?: config('app.name'), ENT_QUOTES, 'UTF-8'); ?>";
        });
        
        Blade::directive('seoDescription', function ($expression) {
            return "<?php echo htmlspecialchars($expression ?: 'Premium streetwear fashion combining cultural heritage with modern style. Edition By Punjab - Where Tradition Meets Modern Fashion.', ENT_QUOTES, 'UTF-8'); ?>";
        });
        
        Blade::directive('seoKeywords', function ($expression) {
            return "<?php echo htmlspecialchars($expression ?: 'streetwear, fashion, cultural fusion, hoodies, t-shirts, sustainable fashion, australian streetwear', ENT_QUOTES, 'UTF-8'); ?>";
        });
    }
}