<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use App\Models\Category;
use App\Models\CompanyInfo;

class ViewServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        // Share categories with all views
        View::composer('*', function ($view) {
            $categories = Category::where('is_active', true)
                ->withCount('products')
                ->orderBy('sort_order')
                ->get();
            
            $view->with('categories', $categories);
        });

        // Share company info with all views
        View::composer('*', function ($view) {
            $companyInfo = CompanyInfo::first();
            
            // If no company info exists, create default
            if (!$companyInfo) {
                $companyInfo = CompanyInfo::create([
                    'company_name' => 'Edition By Punjab',
                    'email' => 'info@editionbypunjab.com',
                    'phone' => '+61 000 000 000',
                    'address' => 'Sydney, Australia',
                    'description' => 'Your trusted partner for premium fashion and lifestyle products.',
                    'about_us' => 'Edition By Punjab is a premium fashion brand...',
                    'mission' => 'To provide high-quality fashion products...',
                    'vision' => 'To become a leading fashion brand...'
                ]);
            }
            
            $view->with('companyInfo', $companyInfo);
        });
    }
}