<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddShippingFieldsToOrdersTable extends Migration
{
    public function up()
    {
        Schema::table('orders', function (Blueprint $table) {
            // Add shipping method and location fields
            $table->string('shipping_method')->nullable()->after('shipping_amount');
            $table->string('shipping_city')->nullable()->after('shipping_method');
            $table->string('shipping_state')->nullable()->after('shipping_city');
            $table->decimal('discount_amount', 10, 2)->default(0)->after('shipping_amount');
            $table->string('coupon_code')->nullable()->after('discount_amount');
            
            // Add indexes for better query performance
            $table->index(['shipping_city', 'shipping_state']);
        });
        
        // Update existing orders with default values
        DB::table('orders')->whereNull('shipping_method')->update([
            'shipping_method' => 'standard',
            'shipping_city' => 'Sydney',
            'shipping_state' => 'NSW'
        ]);
    }

    public function down()
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropIndex(['shipping_city', 'shipping_state']);
            $table->dropColumn(['shipping_method', 'shipping_city', 'shipping_state', 'discount_amount', 'coupon_code']);
        });
    }
}