<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class CreateShippingZonesAndTaxRatesTablesIfNotExist extends Migration
{
    public function up()
    {
        // Create shipping_zones table if it doesn't exist
        if (!Schema::hasTable('shipping_zones')) {
            Schema::create('shipping_zones', function (Blueprint $table) {
                $table->id();
                $table->string('city');
                $table->string('state');
                $table->string('postcode_range')->nullable();
                $table->decimal('standard_rate', 10, 2)->default(10.00);
                $table->decimal('express_rate', 10, 2)->default(15.00);
                $table->decimal('priority_rate', 10, 2)->default(25.00);
                $table->decimal('free_shipping_threshold', 10, 2)->nullable();
                $table->boolean('is_active')->default(true);
                $table->integer('sort_order')->default(0);
                $table->timestamps();
                
                $table->index(['city', 'state']);
                $table->index('is_active');
            });
            
            // Insert default shipping zone
            DB::table('shipping_zones')->insert([
                'city' => 'Other',
                'state' => 'ALL',
                'standard_rate' => 10,
                'express_rate' => 15,
                'priority_rate' => 25,
                'free_shipping_threshold' => 100,
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now()
            ]);
        }
        
        // Create tax_rates table if it doesn't exist
        if (!Schema::hasTable('tax_rates')) {
            Schema::create('tax_rates', function (Blueprint $table) {
                $table->id();
                $table->string('city');
                $table->string('state');
                $table->string('tax_name')->default('GST');
                $table->decimal('rate', 5, 2)->default(10.00);
                $table->boolean('is_percentage')->default(true);
                $table->boolean('is_active')->default(true);
                $table->integer('sort_order')->default(0);
                $table->timestamps();
                
                $table->index(['city', 'state']);
                $table->index('is_active');
            });
            
            // Insert default tax rate (10% GST for Australia)
            DB::table('tax_rates')->insert([
                'city' => 'Other',
                'state' => 'ALL',
                'tax_name' => 'GST',
                'rate' => 10.00,
                'is_percentage' => true,
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now()
            ]);
        }
    }

    public function down()
    {
        Schema::dropIfExists('shipping_zones');
        Schema::dropIfExists('tax_rates');
    }
}