<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTaxRatesTable extends Migration
{
    public function up()
    {
        Schema::create('tax_rates', function (Blueprint $table) {
            $table->id();
            $table->string('city');
            $table->string('state');
            $table->string('tax_name')->default('GST'); // Goods and Services Tax
            $table->decimal('rate', 5, 2)->default(10.00); // Default 10% GST
            $table->boolean('is_percentage')->default(true);
            $table->boolean('is_active')->default(true);
            $table->integer('sort_order')->default(0);
            $table->timestamps();
            
            $table->index(['city', 'state']);
            $table->index('is_active');
        });
        
        // Add default tax rates for Australian states (GST is uniform at 10% across Australia)
        DB::table('tax_rates')->insert([
            // Major cities with standard GST
            ['city' => 'Sydney', 'state' => 'NSW', 'tax_name' => 'GST', 'rate' => 10.00, 'is_percentage' => true, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            ['city' => 'Melbourne', 'state' => 'VIC', 'tax_name' => 'GST', 'rate' => 10.00, 'is_percentage' => true, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            ['city' => 'Brisbane', 'state' => 'QLD', 'tax_name' => 'GST', 'rate' => 10.00, 'is_percentage' => true, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            ['city' => 'Perth', 'state' => 'WA', 'tax_name' => 'GST', 'rate' => 10.00, 'is_percentage' => true, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            ['city' => 'Adelaide', 'state' => 'SA', 'tax_name' => 'GST', 'rate' => 10.00, 'is_percentage' => true, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            ['city' => 'Hobart', 'state' => 'TAS', 'tax_name' => 'GST', 'rate' => 10.00, 'is_percentage' => true, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            ['city' => 'Darwin', 'state' => 'NT', 'tax_name' => 'GST', 'rate' => 10.00, 'is_percentage' => true, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            ['city' => 'Canberra', 'state' => 'ACT', 'tax_name' => 'GST', 'rate' => 10.00, 'is_percentage' => true, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            
            // Default for all other areas
            ['city' => 'Other', 'state' => 'ALL', 'tax_name' => 'GST', 'rate' => 10.00, 'is_percentage' => true, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
        ]);
    }

    public function down()
    {
        Schema::dropIfExists('tax_rates');
    }
}