<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddShopFieldsToProductsTable extends Migration
{
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            // Be careful: 'after' may not be supported by all DB drivers (e.g. SQLite).
            $table->integer('stock')->default(0)->after('price');
            $table->boolean('track_stock')->default(true)->after('stock');
            $table->decimal('compare_price', 10, 2)->nullable()->after('price');
            $table->decimal('weight', 8, 2)->nullable();
            $table->string('brand')->nullable();
            $table->json('sizes')->nullable();
            $table->json('colors')->nullable();
            $table->integer('sold_count')->default(0);
        });
    }

    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn([
                'stock',
                'track_stock',
                'compare_price',
                'weight',
                'brand',
                'sizes',
                'colors',
                'sold_count',
            ]);
        });
    }
}
