<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddShopFieldsToCompanyInfoTable extends Migration
{
    public function up(): void
    {
        Schema::table('company_info', function (Blueprint $table) {
            $table->string('currency_code')->default('AUD');
            $table->string('currency_symbol')->default('$');
            $table->decimal('tax_rate', 5, 2)->default(10);
            $table->decimal('shipping_rate', 10, 2)->default(10);
            $table->decimal('free_shipping_threshold', 10, 2)->default(100);
            $table->json('payment_methods')->nullable();
            $table->json('shop_policies')->nullable();
        });
    }

    public function down(): void
    {
        Schema::table('company_info', function (Blueprint $table) {
            $table->dropColumn([
                'currency_code',
                'currency_symbol',
                'tax_rate',
                'shipping_rate',
                'free_shipping_threshold',
                'payment_methods',
                'shop_policies',
            ]);
        });
    }
}
