<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('user_discounts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('cascade');
            $table->string('email');
            $table->string('discount_code')->unique();
            $table->decimal('discount_percentage', 5, 2);
            $table->enum('discount_type', ['percentage', 'fixed']);
            $table->boolean('is_used')->default(false);
            $table->timestamp('used_at')->nullable();
            $table->timestamp('expires_at')->nullable();
            $table->timestamps();
            
            $table->index('email');
            $table->index('discount_code');
        });
    }

    public function down()
    {
        Schema::dropIfExists('user_discounts');
    }
};