<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('community_posts', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('location');
            $table->text('caption');
            $table->string('products_featured')->nullable();
            $table->string('instagram_handle')->nullable();
            $table->string('image_path');
            $table->boolean('consent_gallery')->default(true);
            $table->boolean('consent_social')->default(false);
            $table->boolean('consent_marketing')->default(false);
            $table->enum('status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->boolean('featured')->default(false);
            $table->integer('likes')->default(0);
            $table->timestamp('approved_at')->nullable();
            $table->timestamps();
            
            $table->index(['status', 'approved_at']);
            $table->index(['featured', 'status']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('community_posts');
    }
};
