<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('banners', function (Blueprint $table) {
            // Add new fields for slideshow functionality
            $table->json('images')->nullable()->after('image');
            $table->integer('slide_duration')->default(5)->after('images');
            $table->enum('animation_type', ['fade', 'slide'])->default('fade')->after('slide_duration');
            $table->boolean('auto_play')->default(true)->after('animation_type');
        });

        // Update the position enum to include new banner types
        DB::statement("ALTER TABLE banners MODIFY COLUMN position ENUM('hero', 'promo_left', 'promo_right', 'home_hero_slider', 'below_categories_slider') DEFAULT 'hero'");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('banners', function (Blueprint $table) {
            // Remove slideshow fields
            $table->dropColumn(['images', 'slide_duration', 'animation_type', 'auto_play']);
        });

        // Revert position enum to original values
        DB::statement("ALTER TABLE banners MODIFY COLUMN position ENUM('hero', 'promo_left', 'promo_right') DEFAULT 'hero'");
    }
};
