<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ShippingZone;

class DefaultShippingZoneSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Check if default shipping zone already exists
        $defaultShippingZone = ShippingZone::where('city', 'Other')
            ->where('state', 'ALL')
            ->first();

        if (!$defaultShippingZone) {
            ShippingZone::create([
                'city' => 'Other',
                'state' => 'ALL',
                'standard_rate' => 10.00,
                'express_rate' => 20.00,
                'priority_rate' => 30.00,
                'free_shipping_threshold' => 100.00,
                'is_active' => true,
                'sort_order' => 999
            ]);
        }

        // Create some example shipping zones for major cities
        $shippingZones = [
            [
                'city' => 'Sydney',
                'state' => 'NSW',
                'standard_rate' => 0.00, // Free standard shipping
                'express_rate' => 15.00,
                'priority_rate' => 25.00,
                'free_shipping_threshold' => 80.00,
                'is_active' => true,
                'sort_order' => 1
            ],
            [
                'city' => 'Melbourne',
                'state' => 'VIC',
                'standard_rate' => 5.00,
                'express_rate' => 18.00,
                'priority_rate' => 28.00,
                'free_shipping_threshold' => 100.00,
                'is_active' => true,
                'sort_order' => 2
            ],
            [
                'city' => 'Brisbane',
                'state' => 'QLD',
                'standard_rate' => 8.00,
                'express_rate' => 20.00,
                'priority_rate' => 30.00,
                'free_shipping_threshold' => 120.00,
                'is_active' => true,
                'sort_order' => 3
            ],
            [
                'city' => 'Perth',
                'state' => 'WA',
                'standard_rate' => 12.00,
                'express_rate' => 25.00,
                'priority_rate' => 35.00,
                'free_shipping_threshold' => 150.00,
                'is_active' => true,
                'sort_order' => 4
            ],
            [
                'city' => 'Adelaide',
                'state' => 'SA',
                'standard_rate' => 10.00,
                'express_rate' => 22.00,
                'priority_rate' => 32.00,
                'free_shipping_threshold' => 110.00,
                'is_active' => true,
                'sort_order' => 5
            ]
        ];

        foreach ($shippingZones as $zone) {
            $existingZone = ShippingZone::where('city', $zone['city'])
                ->where('state', $zone['state'])
                ->first();

            if (!$existingZone) {
                ShippingZone::create($zone);
            }
        }
    }
}