<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\TaxRate;

class DefaultTaxRateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Check if default tax rate already exists
        $defaultTaxRate = TaxRate::where('city', 'Other')
            ->where('state', 'ALL')
            ->first();

        if (!$defaultTaxRate) {
            TaxRate::create([
                'city' => 'Other',
                'state' => 'ALL',
                'tax_name' => 'GST',
                'rate' => 10.00,
                'is_percentage' => true,
                'is_active' => true,
                'sort_order' => 999
            ]);
        }

        // Create some example tax rates for major cities
        $taxRates = [
            [
                'city' => 'Sydney',
                'state' => 'NSW',
                'tax_name' => 'GST',
                'rate' => 10.00,
                'is_percentage' => true,
                'is_active' => true,
                'sort_order' => 1
            ],
            [
                'city' => 'Melbourne',
                'state' => 'VIC',
                'tax_name' => 'GST',
                'rate' => 10.00,
                'is_percentage' => true,
                'is_active' => true,
                'sort_order' => 2
            ],
            [
                'city' => 'Brisbane',
                'state' => 'QLD',
                'tax_name' => 'GST',
                'rate' => 10.00,
                'is_percentage' => true,
                'is_active' => true,
                'sort_order' => 3
            ],
            [
                'city' => 'Perth',
                'state' => 'WA',
                'tax_name' => 'GST',
                'rate' => 10.00,
                'is_percentage' => true,
                'is_active' => true,
                'sort_order' => 4
            ],
            [
                'city' => 'Adelaide',
                'state' => 'SA',
                'tax_name' => 'GST',
                'rate' => 10.00,
                'is_percentage' => true,
                'is_active' => true,
                'sort_order' => 5
            ]
        ];

        foreach ($taxRates as $taxRate) {
            $existingRate = TaxRate::where('city', $taxRate['city'])
                ->where('state', $taxRate['state'])
                ->first();

            if (!$existingRate) {
                TaxRate::create($taxRate);
            }
        }
    }
}