<?php

namespace Database\Seeders;

use App\Models\LegalPage;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class LegalPageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Clear existing legal pages
        LegalPage::truncate();

        // Terms of Service
        LegalPage::create([
            'title' => 'Terms of Service',
            'slug' => 'terms-of-service',
            'meta_description' => 'Terms and conditions for using Edition By Punjab website and services',
            'content' => $this->getTermsContent(),
            'is_active' => true,
        ]);

        // Privacy Policy
        LegalPage::create([
            'title' => 'Privacy Policy',
            'slug' => 'privacy-policy',
            'meta_description' => 'Learn how Edition By Punjab protects your privacy and handles your personal information',
            'content' => $this->getPrivacyContent(),
            'is_active' => true,
        ]);

        // Shipping Policy
        LegalPage::create([
            'title' => 'Shipping Policy',
            'slug' => 'shipping-policy',
            'meta_description' => 'Fast, reliable shipping worldwide. Learn about our shipping rates, delivery times, and policies.',
            'content' => $this->getShippingContent(),
            'is_active' => true,
        ]);

        // Refund & Return Policy
        LegalPage::create([
            'title' => 'Refund & Return Policy',
            'slug' => 'refund-policy',
            'meta_description' => 'Learn about our hassle-free return and refund process at Edition By Punjab',
            'content' => $this->getRefundContent(),
            'is_active' => true,
        ]);
    }

    private function getTermsContent()
    {
        return '
<h2>Acceptance of Terms</h2>
<p>By accessing and using the Edition By Punjab website, you accept and agree to be bound by the terms and provision of this agreement. These Terms of Service apply to all users of the site, including without limitation users who are browsers, vendors, customers, merchants, and/or contributors of content.</p>

<div class="terms-highlights">
    <div class="term-highlight">
        <h4>Age Requirement</h4>
        <p>You must be at least 18 years old to use our services</p>
    </div>
    <div class="term-highlight">
        <h4>Jurisdiction</h4>
        <p>These terms are governed by the laws of the United States</p>
    </div>
    <div class="term-highlight">
        <h4>Updates</h4>
        <p>We reserve the right to update these terms at any time</p>
    </div>
</div>

<h2>Use License</h2>
<p>Permission is granted to temporarily download one copy of the materials (information or software) on Edition By Punjab\'s website for personal, non-commercial transitory viewing only. This is the grant of a license, not a transfer of title.</p>

<h3>Under this license you may NOT:</h3>
<ul>
    <li>Modify or copy the materials</li>
    <li>Use the materials for any commercial purpose or public display</li>
    <li>Attempt to decompile or reverse engineer any software</li>
    <li>Remove any copyright or proprietary notations</li>
    <li>Transfer the materials to another person</li>
</ul>

<h2>Product Information</h2>
<p>We strive to display colors as accurately as possible, but screen variations may occur. Please refer to our size guide for accurate measurements. Images are for illustration purposes and may vary slightly. We ensure accuracy but reserve the right to correct any errors.</p>

<h2>Order Acceptance</h2>
<p>Placing an order constitutes an offer to purchase products. Receipt of order confirmation does not signify acceptance. We reserve the right to accept or decline your order and may require additional verification for certain orders.</p>

<h2>Pricing</h2>
<p>All prices are subject to change without notice. Promotional prices are limited time offers. We reserve the right to correct pricing errors. Prices exclude applicable taxes unless stated.</p>

<h2>Payment</h2>
<p>We accept Visa, Mastercard, American Express, Discover, PayPal, and Apple Pay. All payments are processed securely through encrypted channels. We never store your complete payment information on our servers.</p>

<p>Payment must be received by us prior to our dispatch of your order. For credit card payments, your card will be charged at the time of purchase.</p>

<h2>Shipping</h2>
<p>Shipping times and costs vary based on location and shipping method selected. Please refer to our Shipping Policy for detailed information.</p>

<ul>
    <li><strong>Processing Time:</strong> 1-2 business days</li>
    <li><strong>Delivery Time:</strong> 5-7 business days (standard)</li>
    <li><strong>Free Shipping:</strong> Orders over $100</li>
</ul>

<h2>Returns and Refunds</h2>
<p>Please review our Return & Refund Policy for detailed information about returning products and obtaining refunds.</p>

<ul>
    <li><strong>30-Day Returns:</strong> Return within 30 days of delivery</li>
    <li><strong>Original Condition:</strong> Items must be unworn with tags</li>
    <li><strong>Full Refund:</strong> 100% money back guarantee</li>
</ul>

<h2>Privacy</h2>
<p>Your use of our website is also governed by our Privacy Policy. Please review our Privacy Policy, which also governs your visit to our website, to understand our practices.</p>

<h3>Our Privacy Commitment:</h3>
<ul>
    <li>We never sell your personal information</li>
    <li>We use industry-standard encryption</li>
    <li>We respect your communication preferences</li>
    <li>You can request data deletion at any time</li>
</ul>

<h2>Limitation of Liability</h2>
<p>In no event shall Edition By Punjab or its directors, employees, partners, agents, suppliers, or affiliates, be liable for any indirect, incidental, special, consequential, or punitive damages, including without limitation, loss of profits, data, use, goodwill, or other intangible losses.</p>

<p>Our liability is limited to the maximum extent permitted by law. We shall not be liable for:</p>
<ul>
    <li>Any errors or omissions in content</li>
    <li>Personal injury or property damage</li>
    <li>Unauthorized access to our servers</li>
    <li>Interruption of transmission to or from our website</li>
    <li>Any bugs, viruses, or trojan horses</li>
</ul>

<h2>Contact Information</h2>
<p>If you have any questions about these Terms of Service, please contact us:</p>

<ul>
    <li><strong>Email:</strong> legal@editionbypunjab.com</li>
    <li><strong>Phone:</strong> +1 (555) 123-4567</li>
    <li><strong>Address:</strong> 123 Fashion Street, City, State 12345</li>
    <li><strong>Business Hours:</strong> Mon-Fri: 9AM-6PM EST</li>
</ul>
        ';
    }

    private function getPrivacyContent()
    {
        return '
<h2>Information We Collect</h2>
<p>We collect information you provide directly to us, such as when you create an account, make a purchase, or contact us. This information may include:</p>

<ul>
    <li>Personal identification information (name, email address, phone number)</li>
    <li>Billing and shipping addresses</li>
    <li>Payment information (processed securely through our payment processors)</li>
    <li>Purchase history and preferences</li>
    <li>Communication preferences</li>
    <li>Any other information you choose to provide</li>
</ul>

<h2>How We Use Your Information</h2>
<p>We use the information we collect to provide, maintain, and improve our services, including to:</p>

<div class="usage-grid">
    <div class="usage-item">
        <h4>Process Orders</h4>
        <p>Process and fulfill your orders, including payment processing and delivery</p>
    </div>
    <div class="usage-item">
        <h4>Communication</h4>
        <p>Communicate with you about your orders, account, and customer service inquiries</p>
    </div>
    <div class="usage-item">
        <h4>Marketing</h4>
        <p>Send you marketing communications with your consent</p>
    </div>
    <div class="usage-item">
        <h4>Improvement</h4>
        <p>Improve our products, services, and user experience</p>
    </div>
    <div class="usage-item">
        <h4>Protection</h4>
        <p>Protect against fraudulent or illegal activities</p>
    </div>
    <div class="usage-item">
        <h4>Compliance</h4>
        <p>Comply with legal obligations and enforce our terms</p>
    </div>
</div>

<h2>Information Sharing</h2>
<p>We do not sell, trade, or otherwise transfer your personal information to third parties without your consent, except as described in this policy. We may share your information with:</p>

<ul>
    <li>Service providers who assist us in operating our website and conducting our business</li>
    <li>Payment processors for secure transaction processing</li>
    <li>Shipping partners to deliver your orders</li>
    <li>Law enforcement or regulatory authorities when required by law</li>
    <li>Other parties with your explicit consent</li>
</ul>

<h2>Data Security</h2>
<p>We implement appropriate technical and organizational measures to protect your personal information against unauthorized access, alteration, disclosure, or destruction.</p>

<p>Our security measures include:</p>
<ul>
    <li>SSL encryption for data transmission</li>
    <li>Secure servers and databases</li>
    <li>Regular security audits and updates</li>
    <li>Limited access to personal information</li>
    <li>Employee training on data protection</li>
</ul>

<h2>Cookies</h2>
<p>We use cookies and similar tracking technologies to track activity on our website and hold certain information. Cookies are files with small amounts of data which may include an anonymous unique identifier.</p>

<div class="cookie-types">
    <div class="cookie-type">
        <h4>Essential Cookies</h4>
        <p>Required for the website to function properly</p>
    </div>
    <div class="cookie-type">
        <h4>Analytics Cookies</h4>
        <p>Help us understand how visitors interact with our website</p>
    </div>
    <div class="cookie-type">
        <h4>Marketing Cookies</h4>
        <p>Used to deliver relevant advertisements to you</p>
    </div>
</div>

<h2>Your Rights</h2>
<p>You have the following rights regarding your personal information:</p>

<div class="rights-cards">
    <div class="right-card">
        <h4>Access</h4>
        <p>Request access to your personal information</p>
    </div>
    <div class="right-card">
        <h4>Correction</h4>
        <p>Correct inaccurate or incomplete information</p>
    </div>
    <div class="right-card">
        <h4>Deletion</h4>
        <p>Request deletion of your information</p>
    </div>
    <div class="right-card">
        <h4>Opt-out</h4>
        <p>Opt-out of marketing communications</p>
    </div>
</div>

<h2>Children\'s Privacy</h2>
<p>Our website is not intended for children under 13 years of age. We do not knowingly collect personal information from children under 13. If you are a parent or guardian and believe your child has provided us with personal information, please contact us.</p>

<h2>Changes to This Policy</h2>
<p>We may update this privacy policy from time to time. We will notify you of any changes by posting the new policy on this page and updating the "Last updated" date at the top of this policy. You are advised to review this Privacy Policy periodically for any changes.</p>

<h2>Contact Us</h2>
<p>If you have questions about this Privacy Policy, please contact us:</p>

<ul>
    <li><strong>Email:</strong> privacy@editionbypunjab.com</li>
    <li><strong>Phone:</strong> +1 (555) 123-4567</li>
    <li><strong>Address:</strong> 123 Fashion Street, City, State 12345</li>
</ul>
        ';
    }

    private function getShippingContent()
    {
        return '
<h2>Processing Time</h2>
<p>All orders are processed within <strong>1-2 business days</strong>. Orders are not shipped or delivered on weekends or holidays. Same-day processing is available for orders placed before 12 PM EST.</p>

<h2>Shipping Rates & Delivery Times</h2>

<h3>Domestic Shipping (United States)</h3>
<table style="width: 100%; border-collapse: collapse; margin: 1rem 0;">
    <thead>
        <tr style="background: #f5f5f5;">
            <th style="padding: 0.75rem; border: 1px solid #ddd;">Shipping Method</th>
            <th style="padding: 0.75rem; border: 1px solid #ddd;">Delivery Time</th>
            <th style="padding: 0.75rem; border: 1px solid #ddd;">Cost</th>
            <th style="padding: 0.75rem; border: 1px solid #ddd;">Features</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td style="padding: 0.75rem; border: 1px solid #ddd;"><strong>Standard Shipping</strong></td>
            <td style="padding: 0.75rem; border: 1px solid #ddd;">5-7 business days</td>
            <td style="padding: 0.75rem; border: 1px solid #ddd;">$10.00</td>
            <td style="padding: 0.75rem; border: 1px solid #ddd;">Tracking, Insurance</td>
        </tr>
        <tr>
            <td style="padding: 0.75rem; border: 1px solid #ddd;"><strong>Express Shipping</strong></td>
            <td style="padding: 0.75rem; border: 1px solid #ddd;">2-3 business days</td>
            <td style="padding: 0.75rem; border: 1px solid #ddd;">$25.00</td>
            <td style="padding: 0.75rem; border: 1px solid #ddd;">Priority, Tracking, Insurance</td>
        </tr>
        <tr>
            <td style="padding: 0.75rem; border: 1px solid #ddd;"><strong>Priority Shipping</strong></td>
            <td style="padding: 0.75rem; border: 1px solid #ddd;">1-2 business days</td>
            <td style="padding: 0.75rem; border: 1px solid #ddd;">$40.00</td>
            <td style="padding: 0.75rem; border: 1px solid #ddd;">Next Day, Signature, Full Insurance</td>
        </tr>
    </tbody>
</table>

<div style="background: linear-gradient(135deg, #4CAF50 0%, #45a049 100%); color: white; padding: 2rem; margin: 2rem 0;">
    <h4 style="color: white;">FREE Standard Shipping</h4>
    <p style="color: white;">On all orders over $100 within the United States</p>
</div>

<h2>International Shipping</h2>

<div class="international-zones" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 1.5rem; margin: 2rem 0;">
    <div style="background: white; border: 1px solid #e0e0e0; padding: 1.5rem;">
        <h4>Zone 1: North America</h4>
        <ul>
            <li>Canada, Mexico</li>
            <li>7-14 business days</li>
            <li>Starting at $20</li>
        </ul>
    </div>
    <div style="background: white; border: 1px solid #e0e0e0; padding: 1.5rem;">
        <h4>Zone 2: Europe</h4>
        <ul>
            <li>EU Countries, UK</li>
            <li>10-18 business days</li>
            <li>Starting at $30</li>
        </ul>
    </div>
    <div style="background: white; border: 1px solid #e0e0e0; padding: 1.5rem;">
        <h4>Zone 3: Asia Pacific</h4>
        <ul>
            <li>Asia, Australia, NZ</li>
            <li>12-20 business days</li>
            <li>Starting at $35</li>
        </ul>
    </div>
    <div style="background: white; border: 1px solid #e0e0e0; padding: 1.5rem;">
        <h4>Zone 4: Rest of World</h4>
        <ul>
            <li>All other countries</li>
            <li>15-25 business days</li>
            <li>Starting at $40</li>
        </ul>
    </div>
</div>

<div style="background: #FFF3CD; border: 1px solid #FFC107; border-left-width: 4px; padding: 1.5rem; margin: 2rem 0;">
    <h4>Important: Customs & Duties</h4>
    <p>International customers are responsible for any customs duties, taxes, or fees imposed by their country. These charges are not included in our shipping costs.</p>
</div>

<h2>Order Tracking</h2>
<p>We provide comprehensive order tracking for all shipments:</p>

<ol>
    <li><strong>Shipping Confirmation:</strong> Receive email with tracking number once order ships</li>
    <li><strong>Track Your Order:</strong> Use tracking number on our website or carrier\'s site</li>
    <li><strong>Delivery Updates:</strong> Get real-time notifications about your package</li>
</ol>

<h2>Shipping Restrictions</h2>
<p>Please note the following shipping restrictions:</p>

<ul>
    <li><strong>Restricted Items:</strong> Some products may have shipping restrictions based on regulations</li>
    <li><strong>Size & Weight Limits:</strong> Oversized items may incur additional shipping charges</li>
    <li><strong>Location Restrictions:</strong> We cannot ship to P.O. boxes for certain items</li>
    <li><strong>Hazardous Materials:</strong> Special handling required for certain products</li>
</ul>

<h2>Damaged or Lost Packages</h2>
<p>If your package is damaged or lost during shipping:</p>

<ol>
    <li><strong>Report Issue:</strong> Contact us immediately if your package is damaged or lost</li>
    <li><strong>Document Damage:</strong> Take photos of damaged package and items</li>
    <li><strong>File Claim:</strong> We\'ll handle insurance claims with the carrier</li>
    <li><strong>Resolution:</strong> Receive replacement or full refund</li>
</ol>

<div style="background: linear-gradient(135deg, #E8F5E9 0%, #C8E6C9 100%); border: 1px solid #4CAF50; border-left-width: 4px; padding: 2rem; margin: 2rem 0;">
    <h4>Our Guarantee</h4>
    <p>All packages are fully insured. If your order is lost or damaged in transit, we will replace it or issue a full refund at no cost to you.</p>
</div>

<h2>Contact Us</h2>
<p>For shipping inquiries or assistance:</p>

<ul>
    <li><strong>Customer Support:</strong> Available 24/7 for shipping questions</li>
    <li><strong>Email:</strong> shipping@editionbypunjab.com</li>
    <li><strong>Phone:</strong> +1 (555) 123-4567</li>
</ul>
        ';
    }

    private function getRefundContent()
    {
        return '
<div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 2rem; margin-bottom: 4rem;">
    <div style="background: white; border: 1px solid #e0e0e0; padding: 2rem; text-align: center;">
        <h3>30 Days</h3>
        <p>Return Period</p>
    </div>
    <div style="background: white; border: 1px solid #e0e0e0; padding: 2rem; text-align: center;">
        <h3>Free</h3>
        <p>Return Shipping*</p>
    </div>
    <div style="background: white; border: 1px solid #e0e0e0; padding: 2rem; text-align: center;">
        <h3>100%</h3>
        <p>Money Back</p>
    </div>
    <div style="background: white; border: 1px solid #e0e0e0; padding: 2rem; text-align: center;">
        <h3>5-7 Days</h3>
        <p>Refund Processing</p>
    </div>
</div>

<h2>Return Period</h2>
<div style="background: linear-gradient(135deg, #f8f8f8 0%, #fff 100%); padding: 1.5rem; border-left: 4px solid #000; margin: 2rem 0;">
    <p>We accept returns within <strong>30 days</strong> of delivery. To be eligible for a return, your item must be unused, unworn, and in the same condition that you received it. It must also be in the original packaging with all tags attached.</p>
</div>

<h2>Return Process</h2>
<ol>
    <li><strong>Initiate Return:</strong> Contact our customer service team via email or through your account dashboard</li>
    <li><strong>Get RMA Number:</strong> Receive your Return Merchandise Authorization (RMA) number within 24 hours</li>
    <li><strong>Pack Items:</strong> Securely pack the item with all original packaging, tags, and accessories</li>
    <li><strong>Ship Back:</strong> Ship the item using the prepaid label or a trackable shipping method</li>
    <li><strong>Receive Refund:</strong> Get your refund processed within 5-7 business days of receipt</li>
</ol>

<h2>Refund Processing</h2>
<p>Once we receive your returned item, we will:</p>

<ol>
    <li><strong>Inspect the Item:</strong> Within 2 business days of receipt</li>
    <li><strong>Send Confirmation:</strong> Email notification of approval or rejection</li>
    <li><strong>Process Refund:</strong> 5-7 business days to original payment method</li>
</ol>

<h2>Non-Returnable Items</h2>
<p>The following items cannot be returned:</p>

<div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 1.5rem; margin: 2rem 0;">
    <div style="text-align: center; padding: 1.5rem; background: #FFF3CD; border: 1px solid #FFC107;">
        <h4>Sale Items</h4>
        <p>Final sale and clearance items</p>
    </div>
    <div style="text-align: center; padding: 1.5rem; background: #FFF3CD; border: 1px solid #FFC107;">
        <h4>Personalized</h4>
        <p>Custom-made or personalized products</p>
    </div>
    <div style="text-align: center; padding: 1.5rem; background: #FFF3CD; border: 1px solid #FFC107;">
        <h4>Gift Cards</h4>
        <p>Digital and physical gift cards</p>
    </div>
    <div style="text-align: center; padding: 1.5rem; background: #FFF3CD; border: 1px solid #FFC107;">
        <h4>Intimate Items</h4>
        <p>Undergarments and swimwear</p>
    </div>
</div>

<h2>Exchanges</h2>
<div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 1.5rem; margin: 2rem 0;">
    <div style="padding: 1.5rem; background: #f8f8f8; border-left: 3px solid #4CAF50;">
        <h4>Size Exchanges</h4>
        <p>We offer free size exchanges within 30 days for items in stock</p>
    </div>
    <div style="padding: 1.5rem; background: #f8f8f8; border-left: 3px solid #4CAF50;">
        <h4>Color Exchanges</h4>
        <p>Exchange for a different color if available in the same style</p>
    </div>
    <div style="padding: 1.5rem; background: #f8f8f8; border-left: 3px solid #4CAF50;">
        <h4>Exchange Shipping</h4>
        <p>Free shipping both ways for exchanges on orders over $100</p>
    </div>
</div>

<h2>Damaged or Defective Items</h2>
<div style="background: #FFEBEE; border: 1px solid #EF5350; border-left-width: 4px; padding: 1.5rem; margin: 2rem 0;">
    <h4>Report Immediately</h4>
    <p>If you receive a damaged or defective item, please contact us within 48 hours with photos of the damage.</p>
</div>

<p>We will:</p>
<ul>
    <li>Arrange for immediate replacement</li>
    <li>Provide prepaid return shipping label</li>
    <li>Offer full refund including original shipping costs</li>
    <li>Expedite processing of your case</li>
</ul>

<h2>International Returns</h2>
<p>For international orders:</p>
<ul>
    <li>Return period extends to 45 days from delivery</li>
    <li>Customer is responsible for return shipping costs</li>
    <li>Customs duties and taxes are non-refundable</li>
    <li>Refund processing may take 10-14 business days</li>
</ul>

<h2>Contact Us</h2>
<p>For questions about returns or refunds:</p>

<div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 1.5rem; margin: 2rem 0;">
    <div style="text-align: center; padding: 2rem; background: white; border: 1px solid #e0e0e0;">
        <h4>Email</h4>
        <p>returns@editionbypunjab.com</p>
        <small>Response within 24 hours</small>
    </div>
    <div style="text-align: center; padding: 2rem; background: white; border: 1px solid #e0e0e0;">
        <h4>Phone</h4>
        <p>+1 (555) 123-4567</p>
        <small>Mon-Fri 9AM-6PM EST</small>
    </div>
    <div style="text-align: center; padding: 2rem; background: white; border: 1px solid #e0e0e0;">
        <h4>Live Chat</h4>
        <p>Available on website</p>
        <small>24/7 Support</small>
    </div>
</div>
        ';
    }
}