<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\StyleGuide;

class StyleGuideSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $styleGuides = [
            [
                'name' => 'Melbourne',
                'slug' => 'melbourne',
                'tagline' => 'Creative Capital Style',
                'description' => 'Artistic, layered, and experimental fashion inspired by Melbourne\'s creative culture',
                'region' => 'Victoria',
                'population' => '5.2M',
                'fashion_score' => 9,
                'streetwear_popularity' => 85,
                'meta_title' => 'Melbourne Streetwear Style Guide | Creative Fashion Tips',
                'meta_description' => 'Discover Melbourne streetwear style with our comprehensive guide. Artistic layering, vintage mixing, and creative fashion tips for Melbourne\'s unique style.',
                'keywords' => 'melbourne streetwear, melbourne fashion, creative style melbourne, australian streetwear melbourne, melbourne style guide',
                'climate' => 'Variable - layers essential',
                'vibe' => 'Artistic, Creative, Experimental',
                'hero_image' => 'style-guides/melbourne-hero.jpg',
                'content' => $this->getMelbourneContent(),
                'styling_tips' => [
                    'Master the art of layering for Melbourne\'s unpredictable weather',
                    'Mix vintage finds with contemporary pieces',
                    'Embrace artistic prints and unique silhouettes',
                    'Black is always a safe choice for Melbourne\'s creative scene'
                ],
                'style_characteristics' => [
                    ['title' => 'All-Black Everything', 'description' => 'Melbourne\'s unofficial uniform. Black provides the perfect canvas for creative expression.'],
                    ['title' => 'Layering Mastery', 'description' => 'Essential skill for Melbourne\'s "four seasons in one day" weather patterns.'],
                    ['title' => 'Artistic Expression', 'description' => 'Bold prints, unique silhouettes, and pieces that tell a creative story.']
                ],
                'key_pieces' => ['Oversized Hoodie', 'Denim Jacket', 'Black Skinny Jeans', 'Statement Sneakers', 'Artistic Tee', 'Layering Cardigan'],
                'seasonal_styling' => [
                    'spring' => ['season' => 'Spring', 'icon' => 'seedling', 'description' => 'Light layers and transitional pieces', 'tips' => ['Denim jackets over hoodies', 'Comfortable sneakers', 'Light scarves for style']],
                    'summer' => ['season' => 'Summer', 'icon' => 'sun', 'description' => 'Breathable fabrics with style', 'tips' => ['Cotton tees in artistic prints', 'Lightweight fabrics', 'Sun protection accessories']],
                    'autumn' => ['season' => 'Autumn', 'icon' => 'leaf', 'description' => 'Perfect hoodie weather', 'tips' => ['Cozy textures', 'Earth tones', 'Layered looks']],
                    'winter' => ['season' => 'Winter', 'icon' => 'snowflake', 'description' => 'Serious layering time', 'tips' => ['Heavy hoodies', 'Thermal layers', 'Statement outerwear']]
                ],
                'cultural_influences' => [
                    ['aspect' => 'Coffee Culture', 'description' => 'Melbourne\'s cafe scene influences relaxed, artisanal fashion choices'],
                    ['aspect' => 'Street Art', 'description' => 'Vibrant laneways inspire bold graphics and artistic expression'],
                    ['aspect' => 'Music Scene', 'description' => 'Independent music culture drives authentic, non-conformist style choices']
                ],
                'color_palette' => [
                    ['name' => 'Melbourne Black', 'hex' => '#000000'],
                    ['name' => 'Charcoal', 'hex' => '#36454F'],
                    ['name' => 'Burgundy', 'hex' => '#800020'],
                    ['name' => 'Forest Green', 'hex' => '#228B22']
                ],
                'shopping_areas' => [
                    ['name' => 'Chapel Street', 'description' => 'Eclectic mix of vintage and contemporary streetwear'],
                    ['name' => 'Fitzroy', 'description' => 'Independent designers and unique boutiques'],
                    ['name' => 'CBD Laneways', 'description' => 'Hidden gems and emerging local brands']
                ],
                'weather' => [
                    'avg_temp' => '15-20°C',
                    'rainfall' => 'Moderate, year-round',
                    'best_months' => 'Mar-May, Sep-Nov',
                    'style_note' => 'Always be prepared for sudden weather changes with versatile layers.'
                ],
                'style_gallery' => [
                    ['image' => 'gallery/melbourne-1.jpg', 'description' => 'Classic Melbourne all-black', 'style_type' => 'Minimalist', 'alt_text' => 'Person wearing all-black Melbourne street style'],
                    ['image' => 'gallery/melbourne-2.jpg', 'description' => 'Artistic layering', 'style_type' => 'Creative', 'alt_text' => 'Creative layered outfit with artistic prints'],
                    ['image' => 'gallery/melbourne-3.jpg', 'description' => 'Street art inspired', 'style_type' => 'Urban', 'alt_text' => 'Urban street style inspired by Melbourne street art'],
                    ['image' => 'gallery/melbourne-4.jpg', 'description' => 'Coffee culture casual', 'style_type' => 'Relaxed', 'alt_text' => 'Relaxed casual outfit perfect for Melbourne cafe culture']
                ],
                'is_active' => true,
                'sort_order' => 1
            ],
            [
                'name' => 'Sydney',
                'slug' => 'sydney',
                'tagline' => 'Coastal Cool Vibes',
                'description' => 'Effortless beach-to-city style that embodies Sydney\'s relaxed sophistication',
                'region' => 'New South Wales',
                'population' => '5.3M',
                'fashion_score' => 8,
                'streetwear_popularity' => 78,
                'meta_title' => 'Sydney Streetwear Style Guide | Beach to City Fashion',
                'meta_description' => 'Master Sydney streetwear style with our guide to coastal cool fashion. From beach to city, discover how to dress for Sydney\'s lifestyle.',
                'keywords' => 'sydney streetwear, sydney fashion, coastal fashion, beach style sydney, sydney style guide',
                'climate' => 'Temperate - versatile pieces',
                'vibe' => 'Relaxed, Sophisticated, Coastal',
                'hero_image' => 'style-guides/sydney-hero.jpg',
                'content' => $this->getSydneyContent(),
                'styling_tips' => [
                    'Choose pieces that work from beach to boardroom',
                    'Invest in quality basics in neutral tones',
                    'Embrace the effortless sophistication Sydney is known for',
                    'Don\'t forget sun protection - style and safety combined'
                ],
                'style_characteristics' => [
                    ['title' => 'Beach to City', 'description' => 'Versatile pieces that transition seamlessly from harbor walks to business meetings.'],
                    ['title' => 'Quality Basics', 'description' => 'Investment pieces in premium materials and timeless cuts.'],
                    ['title' => 'Effortless Sophistication', 'description' => 'Looking polished without trying too hard - the Sydney way.']
                ],
                'key_pieces' => ['Premium Cotton Tee', 'Classic Denim', 'Clean White Sneakers', 'Light Jacket', 'Quality Hoodie', 'Sun-Smart Accessories'],
                'seasonal_styling' => [
                    'spring' => ['season' => 'Spring', 'icon' => 'seedling', 'description' => 'Perfect weather for layering', 'tips' => ['Light jackets for evening', 'Breathable cottons', 'Comfortable walking shoes']],
                    'summer' => ['season' => 'Summer', 'icon' => 'sun', 'description' => 'Beach-ready with city polish', 'tips' => ['UV protection built-in', 'Moisture-wicking fabrics', 'Easy beach-to-bar transitions']],
                    'autumn' => ['season' => 'Autumn', 'icon' => 'leaf', 'description' => 'Ideal conditions for streetwear', 'tips' => ['Perfect hoodie weather', 'Layered textures', 'Comfortable all-day wear']],
                    'winter' => ['season' => 'Winter', 'icon' => 'cloud-rain', 'description' => 'Mild winter styling', 'tips' => ['Light layering sufficient', 'Water-resistant pieces', 'Versatile wardrobe staples']]
                ],
                'cultural_influences' => [
                    ['aspect' => 'Harbor Culture', 'description' => 'Waterfront lifestyle inspires relaxed yet polished fashion choices'],
                    ['aspect' => 'Beach Lifestyle', 'description' => 'Coastal living demands versatile pieces that work for multiple occasions'],
                    ['aspect' => 'Business District', 'description' => 'CBD influence brings elevated basics and smart-casual elements']
                ],
                'color_palette' => [
                    ['name' => 'Ocean Blue', 'hex' => '#006994'],
                    ['name' => 'Sand Beige', 'hex' => '#F5E6D3'],
                    ['name' => 'Harbor Grey', 'hex' => '#708090'],
                    ['name' => 'Sunset Orange', 'hex' => '#FF8C69']
                ],
                'shopping_areas' => [
                    ['name' => 'Surry Hills', 'description' => 'Independent boutiques and creative streetwear brands'],
                    ['name' => 'Newtown', 'description' => 'Alternative fashion and vintage finds'],
                    ['name' => 'Bondi Junction', 'description' => 'Beach-to-city fashion and activewear specialists']
                ],
                'weather' => [
                    'avg_temp' => '18-23°C',
                    'rainfall' => 'Moderate, winter peaks',
                    'best_months' => 'Mar-May, Sep-Nov',
                    'style_note' => 'Mild climate allows for year-round versatile styling with light layers.'
                ],
                'style_gallery' => [
                    ['image' => 'gallery/sydney-1.jpg', 'description' => 'Beach to city transition', 'style_type' => 'Versatile', 'alt_text' => 'Versatile outfit transitioning from beach to city'],
                    ['image' => 'gallery/sydney-2.jpg', 'description' => 'Harbor walk ready', 'style_type' => 'Casual', 'alt_text' => 'Casual outfit perfect for Sydney harbor walks'],
                    ['image' => 'gallery/sydney-3.jpg', 'description' => 'Effortless sophistication', 'style_type' => 'Smart-Casual', 'alt_text' => 'Smart casual look embodying Sydney sophistication'],
                    ['image' => 'gallery/sydney-4.jpg', 'description' => 'Coastal cool vibes', 'style_type' => 'Relaxed', 'alt_text' => 'Relaxed coastal outfit with cool vibes']
                ],
                'is_active' => true,
                'sort_order' => 2
            ],
            [
                'name' => 'Brisbane',
                'slug' => 'brisbane',
                'tagline' => 'Tropical Streetwear',
                'description' => 'Breathable, bright, and bold fashion perfect for Queensland\'s sunny climate',
                'region' => 'Queensland',
                'population' => '2.6M',
                'fashion_score' => 7,
                'streetwear_popularity' => 72,
                'meta_title' => 'Brisbane Streetwear Style Guide | Tropical Fashion Tips',
                'meta_description' => 'Navigate Brisbane\'s tropical climate with style. Our guide to breathable streetwear, bold colors, and comfortable fashion for Queensland living.',
                'keywords' => 'brisbane streetwear, brisbane fashion, tropical streetwear, queensland fashion, brisbane style guide',
                'climate' => 'Subtropical - breathable fabrics',
                'vibe' => 'Relaxed, Colorful, Comfortable',
                'hero_image' => 'style-guides/brisbane-hero.jpg',
                'content' => $this->getBrisbaneContent(),
                'styling_tips' => [
                    'Prioritize breathable, moisture-wicking fabrics',
                    'Don\'t shy away from bold tropical colors',
                    'Lightweight layers for air-conditioned indoor spaces',
                    'Comfortable footwear is essential for Brisbane\'s walking culture'
                ],
                'style_characteristics' => [
                    ['title' => 'Climate-Smart', 'description' => 'Breathable fabrics and UV protection built into everyday pieces.'],
                    ['title' => 'Bold Colors', 'description' => 'Tropical hues that reflect Queensland\'s vibrant outdoor lifestyle.'],
                    ['title' => 'Comfort First', 'description' => 'Functional fashion that works in heat and humidity.']
                ],
                'key_pieces' => ['Breathable Tee', 'Lightweight Shorts', 'UV-Protection Hoodie', 'Comfortable Sneakers', 'Sun Hat', 'Quick-Dry Fabrics'],
                'seasonal_styling' => [
                    'wet_season' => ['season' => 'Wet Season', 'icon' => 'cloud-rain', 'description' => 'Nov-Apr: Hot and humid', 'tips' => ['Quick-dry fabrics', 'Covered footwear', 'Lightweight rain protection']],
                    'dry_season' => ['season' => 'Dry Season', 'icon' => 'sun', 'description' => 'May-Oct: Perfect weather', 'tips' => ['Light layering possible', 'Comfortable all-day wear', 'Sun protection essential']]
                ],
                'cultural_influences' => [
                    ['aspect' => 'Outdoor Lifestyle', 'description' => 'Year-round outdoor activities influence practical, comfortable fashion choices'],
                    ['aspect' => 'River Culture', 'description' => 'Brisbane River lifestyle promotes relaxed, water-friendly fashion'],
                    ['aspect' => 'Subtropical Living', 'description' => 'Hot climate demands breathable, functional yet stylish clothing']
                ],
                'color_palette' => [
                    ['name' => 'Tropical Coral', 'hex' => '#FF7F7F'],
                    ['name' => 'Sunshine Yellow', 'hex' => '#FFD700'],
                    ['name' => 'Palm Green', 'hex' => '#32CD32'],
                    ['name' => 'Sky Blue', 'hex' => '#87CEEB']
                ],
                'shopping_areas' => [
                    ['name' => 'Fortitude Valley', 'description' => 'Alternative fashion and streetwear boutiques'],
                    ['name' => 'West End', 'description' => 'Sustainable and locally-made fashion'],
                    ['name' => 'Queen Street Mall', 'description' => 'Mainstream and activewear brands']
                ],
                'weather' => [
                    'avg_temp' => '20-28°C',
                    'rainfall' => 'High in summer, low in winter',
                    'best_months' => 'Apr-Oct',
                    'style_note' => 'Hot, humid summers require strategic fabric choices and breathable styling.'
                ],
                'style_gallery' => [
                    ['image' => 'gallery/brisbane-1.jpg', 'description' => 'Tropical color blocking', 'style_type' => 'Bold', 'alt_text' => 'Bold tropical color blocking outfit'],
                    ['image' => 'gallery/brisbane-2.jpg', 'description' => 'Climate-smart casual', 'style_type' => 'Practical', 'alt_text' => 'Practical climate-smart casual wear'],
                    ['image' => 'gallery/brisbane-3.jpg', 'description' => 'River walk ready', 'style_type' => 'Active', 'alt_text' => 'Active wear perfect for Brisbane river walks'],
                    ['image' => 'gallery/brisbane-4.jpg', 'description' => 'Subtropical comfort', 'style_type' => 'Relaxed', 'alt_text' => 'Comfortable relaxed style for subtropical weather']
                ],
                'is_active' => true,
                'sort_order' => 3
            ]
        ];

        foreach ($styleGuides as $guide) {
            StyleGuide::updateOrCreate(
                ['slug' => $guide['slug']],
                $guide
            );
        }
    }

    private function getMelbourneContent()
    {
        return '<h2>Melbourne: Where Creativity Meets Street Style</h2>
        
        <p>Melbourne\'s fashion scene is as dynamic and unpredictable as its famous weather. The city\'s creative energy flows through its fashion choices, creating a unique style that celebrates artistic expression and individual creativity.</p>
        
        <h3>The Melbourne Aesthetic</h3>
        
        <div class="row">
            <div class="col-md-6">
                <h4>Layering Mastery</h4>
                <p>Melbourne\'s "four seasons in one day" weather demands layering skills. Think lightweight cardigans over tees, denim jackets over hoodies, and accessories that can be added or removed as needed.</p>
            </div>
            <div class="col-md-6">
                <h4>Artistic Expression</h4>
                <p>Melbourne streetwear embraces bold prints, unique silhouettes, and pieces that tell a story. It\'s not uncommon to see vintage band tees paired with contemporary tailoring.</p>
            </div>
        </div>
        
        <h3>Melbourne Street Style Essentials</h3>
        
        <ul>
            <li><strong>The Perfect Hoodie:</strong> Oversized but not sloppy, in neutral or artistic prints</li>
            <li><strong>Layering Pieces:</strong> Lightweight jackets, cardigans, and vests</li>
            <li><strong>Statement Accessories:</strong> Unique jewelry, artistic bags, creative footwear</li>
            <li><strong>All-Black Everything:</strong> Melbourne\'s unofficial uniform, always chic</li>
        </ul>';
    }

    private function getSydneyContent()
    {
        return '<h2>Sydney: Effortless Coastal Sophistication</h2>
        
        <p>Sydney style embodies the city\'s laid-back yet sophisticated lifestyle. It\'s about looking effortlessly put-together whether you\'re catching waves at Bondi or attending a rooftop bar in the CBD.</p>
        
        <h3>The Sydney Vibe</h3>
        
        <div class="row">
            <div class="col-md-6">
                <h4>Beach to City</h4>
                <p>Sydney fashion is about versatility. Pieces need to work whether you\'re walking along the harbour or grabbing coffee in Surry Hills.</p>
            </div>
            <div class="col-md-6">
                <h4>Relaxed Sophistication</h4>
                <p>Think elevated basics, quality fabrics, and timeless silhouettes that never try too hard but always look right.</p>
            </div>
        </div>
        
        <h3>Sydney Streetwear Staples</h3>
        
        <ul>
            <li><strong>Quality Basics:</strong> Premium cotton tees and well-fitted hoodies</li>
            <li><strong>Denim Done Right:</strong> Classic cuts in quality washes</li>
            <li><strong>Versatile Footwear:</strong> Clean sneakers that work everywhere</li>
            <li><strong>Sun-Smart Accessories:</strong> Stylish sunglasses and caps</li>
        </ul>';
    }

    private function getBrisbaneContent()
    {
        return '<h2>Brisbane: Tropical Streetwear Done Right</h2>
        
        <p>Brisbane\'s subtropical climate demands smart fabric choices and breathable styling. The city\'s outdoor lifestyle and vibrant culture influence fashion choices that prioritize comfort without sacrificing style.</p>
        
        <h3>Climate-Smart Fashion</h3>
        
        <div class="row">
            <div class="col-md-6">
                <h4>Fabric Focus</h4>
                <p>Cotton blends, linen, and moisture-wicking materials are essential. Avoid heavy fabrics that trap heat and humidity.</p>
            </div>
            <div class="col-md-6">
                <h4>Color Psychology</h4>
                <p>Light colors reflect heat while bold tropical hues embrace Brisbane\'s vibrant outdoor culture.</p>
            </div>
        </div>
        
        <h3>Brisbane Style Essentials</h3>
        
        <ul>
            <li><strong>Breathable Tees:</strong> Cotton and bamboo blends in light colors</li>
            <li><strong>Lightweight Hoodies:</strong> For air-conditioned spaces and cooler evenings</li>
            <li><strong>Comfortable Shorts:</strong> Quality cuts that look intentional, not sloppy</li>
            <li><strong>Sun Protection:</strong> UPF clothing, wide-brim hats, and UV sunglasses</li>
        </ul>';
    }
}