@extends('layouts.app')

@section('title', 'About Us')
@section('meta_description', 'Learn about our company, mission, vision and export capabilities')

@section('content')
<!-- Premium About Hero -->
<section class="about-hero-premium">
    <div class="hero-overlay"></div>
    <div class="container">
        <div class="hero-content-center" data-aos="fade-up">
            <span class="hero-label">ABOUT US</span>
            <h1 class="hero-title-premium">{{ $companyInfo->company_name }}</h1>
            <p class="hero-subtitle">Redefining Fashion Since {{ date('Y') - ($companyInfo->years_experience ?? 10) }}</p>
        </div>
    </div>
    <div class="scroll-indicator">
        <span></span>
    </div>
</section>

<!-- About Introduction -->
<section class="about-intro-premium">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6" data-aos="fade-right">
                <div class="intro-content">
                    <span class="section-label-premium">OUR STORY</span>
                    <h2 class="section-title-premium">Crafting Excellence<br>Through Innovation</h2>
                    <p class="intro-text">{{ $companyInfo->about_us }}</p>
                    <div class="intro-stats">
                        <div class="stat-item">
                            <span class="stat-number" data-count="{{ $companyInfo->years_experience }}">0</span>
                            <span class="stat-label">Years of Excellence</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number" data-count="{{ $companyInfo->happy_clients }}">0</span>
                            <span class="stat-label">Happy Clients</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number" data-count="{{ $companyInfo->products_count }}">0</span>
                            <span class="stat-label">Products</span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6" data-aos="fade-left">
                <div class="intro-image-wrapper">
                    <div class="image-frame">
                        <img src="/api/placeholder/600/700" alt="About Us" class="intro-image">
                    </div>
                    <div class="experience-badge">
                        <div class="badge-content">
                            <span class="badge-number">{{ $companyInfo->years_experience }}+</span>
                            <span class="badge-text">YEARS</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Mission & Vision -->
<section class="mission-vision-premium">
    <div class="container">
        <div class="row">
            <div class="col-lg-6" data-aos="zoom-in">
                <div class="mv-card mission">
                    <div class="mv-icon">
                        <i class="fas fa-bullseye"></i>
                    </div>
                    <h3 class="mv-title">OUR MISSION</h3>
                    <p class="mv-text">{{ $companyInfo->mission }}</p>
                    <div class="mv-decoration"></div>
                </div>
            </div>
            <div class="col-lg-6" data-aos="zoom-in" data-aos-delay="100">
                <div class="mv-card vision">
                    <div class="mv-icon">
                        <i class="fas fa-eye"></i>
                    </div>
                    <h3 class="mv-title">OUR VISION</h3>
                    <p class="mv-text">{{ $companyInfo->vision }}</p>
                    <div class="mv-decoration"></div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Premium Features -->
<section class="features-premium">
    <div class="container">
        <div class="section-header-center" data-aos="fade-up">
            <span class="section-label-premium">WHY CHOOSE US</span>
            <h2 class="section-title-premium">Excellence in Every Detail</h2>
        </div>
        
        <div class="features-grid">
            <div class="feature-card-premium" data-aos="fade-up">
                <div class="feature-icon">
                    <i class="fas fa-award"></i>
                </div>
                <h4 class="feature-title">Premium Quality</h4>
                <p class="feature-text">We maintain the highest standards of quality in all our products</p>
            </div>
            
            <div class="feature-card-premium" data-aos="fade-up" data-aos-delay="100">
                <div class="feature-icon">
                    <i class="fas fa-shipping-fast"></i>
                </div>
                <h4 class="feature-title">Fast Delivery</h4>
                <p class="feature-text">Efficient logistics ensuring timely delivery worldwide</p>
            </div>
            
            <div class="feature-card-premium" data-aos="fade-up" data-aos-delay="200">
                <div class="feature-icon">
                    <i class="fas fa-dollar-sign"></i>
                </div>
                <h4 class="feature-title">Best Prices</h4>
                <p class="feature-text">Competitive pricing without compromising on quality</p>
            </div>
            
            <div class="feature-card-premium" data-aos="fade-up" data-aos-delay="300">
                <div class="feature-icon">
                    <i class="fas fa-headset"></i>
                </div>
                <h4 class="feature-title">24/7 Support</h4>
                <p class="feature-text">Dedicated support team available round the clock</p>
            </div>
            
            <div class="feature-card-premium" data-aos="fade-up" data-aos-delay="400">
                <div class="feature-icon">
                    <i class="fas fa-certificate"></i>
                </div>
                <h4 class="feature-title">Certified Quality</h4>
                <p class="feature-text">International certifications and quality standards</p>
            </div>
            
            <div class="feature-card-premium" data-aos="fade-up" data-aos-delay="500">
                <div class="feature-icon">
                    <i class="fas fa-handshake"></i>
                </div>
                <h4 class="feature-title">Partnership</h4>
                <p class="feature-text">Building lasting relationships with our clients</p>
            </div>
        </div>
    </div>
</section>

<!-- Global Presence -->
<section class="global-presence-premium">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6" data-aos="fade-right">
                <div class="presence-content">
                    <span class="section-label-premium">GLOBAL REACH</span>
                    <h2 class="section-title-premium">Serving Clients Worldwide</h2>
                    <p class="presence-text">{{ $companyInfo->export_countries }}</p>
                    <div class="regions-grid">
                        <div class="region-item">
                            <i class="fas fa-check-circle"></i>
                            <span>North America</span>
                        </div>
                        <div class="region-item">
                            <i class="fas fa-check-circle"></i>
                            <span>Europe</span>
                        </div>
                        <div class="region-item">
                            <i class="fas fa-check-circle"></i>
                            <span>Middle East</span>
                        </div>
                        <div class="region-item">
                            <i class="fas fa-check-circle"></i>
                            <span>Asia Pacific</span>
                        </div>
                        <div class="region-item">
                            <i class="fas fa-check-circle"></i>
                            <span>Africa</span>
                        </div>
                        <div class="region-item">
                            <i class="fas fa-check-circle"></i>
                            <span>Latin America</span>
                        </div>
                    </div>
                    <div class="export-stats">
                        <div class="export-stat">
                            <span class="stat-value">50+</span>
                            <span class="stat-desc">Countries</span>
                        </div>
                        <div class="export-stat">
                            <span class="stat-value">{{ $companyInfo->happy_clients }}+</span>
                            <span class="stat-desc">Global Clients</span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6" data-aos="fade-left">
                <div class="world-map-container">
                    <img src="/api/placeholder/600/400" alt="World Map" class="world-map">
                    <div class="map-pins">
                        <span class="pin" style="top: 30%; left: 20%;"></span>
                        <span class="pin" style="top: 25%; left: 45%;"></span>
                        <span class="pin" style="top: 40%; left: 60%;"></span>
                        <span class="pin" style="top: 50%; left: 70%;"></span>
                        <span class="pin" style="top: 60%; left: 55%;"></span>
                        <span class="pin" style="top: 70%; left: 25%;"></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Premium Testimonials -->
@if($testimonials->count() > 0)
<section class="testimonials-premium">
    <div class="container">
        <div class="section-header-center" data-aos="fade-up">
            <span class="section-label-premium">TESTIMONIALS</span>
            <h2 class="section-title-premium">What Our Clients Say</h2>
        </div>
        
        <div class="swiper testimonialsSwiper" data-aos="fade-up">
            <div class="swiper-wrapper">
                @foreach($testimonials as $testimonial)
                <div class="swiper-slide">
                    <div class="testimonial-card-premium">
                        <div class="quote-icon">
                            <i class="fas fa-quote-left"></i>
                        </div>
                        <div class="testimonial-rating">
                            @for($i = 1; $i <= 5; $i++)
                                <i class="fas fa-star {{ $i <= $testimonial->rating ? 'active' : '' }}"></i>
                            @endfor
                        </div>
                        <p class="testimonial-text">"{{ $testimonial->content }}"</p>
                        <div class="testimonial-author">
                            @if($testimonial->client_image)
                            <img src="{{ asset('storage/' . $testimonial->client_image) }}" 
                                 alt="{{ $testimonial->client_name }}" 
                                 class="author-image">
                            @else
                            <div class="author-placeholder">
                                <i class="fas fa-user"></i>
                            </div>
                            @endif
                            <div class="author-info">
                                <h5 class="author-name">{{ $testimonial->client_name }}</h5>
                                <p class="author-position">
                                    {{ $testimonial->client_position }}
                                    @if($testimonial->client_company)
                                        <br>{{ $testimonial->client_company }}
                                    @endif
                                </p>
                                <p class="author-country">{{ $testimonial->client_country }}</p>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
            <div class="swiper-pagination"></div>
        </div>
    </div>
</section>
@endif

<!-- Call to Action -->
<section class="cta-premium">
    <div class="cta-bg"></div>
    <div class="container">
        <div class="cta-content" data-aos="zoom-in">
            <h2 class="cta-title">Ready to Partner with Us?</h2>
            <p class="cta-subtitle">Join hundreds of satisfied clients worldwide</p>
            <div class="cta-buttons">
                <a href="{{ route('products') }}" class="btn-cta-primary">
                    VIEW PRODUCTS
                </a>
                <a href="{{ route('contact') }}" class="btn-cta-secondary">
                    GET IN TOUCH
                </a>
            </div>
        </div>
    </div>
</section>

@push('styles')
<style>
/* About Hero */
.about-hero-premium {
    height: 70vh;
    min-height: 500px;
    background: linear-gradient(135deg, #000 0%, #333 100%);
    position: relative;
    display: flex;
    align-items: center;
    justify-content: center;
    overflow: hidden;
}

.about-hero-premium::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-image: url('/images/about-hero.jpg');
    background-size: cover;
    background-position: center;
    opacity: 0.3;
}

.hero-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: radial-gradient(circle at center, transparent 0%, rgba(0,0,0,0.7) 100%);
}

.hero-content-center {
    text-align: center;
    color: white;
    position: relative;
    z-index: 2;
}

.hero-label {
    display: inline-block;
    padding: 0.5rem 1.5rem;
    background: rgba(255,255,255,0.1);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255,255,255,0.2);
    font-size: 0.75rem;
    letter-spacing: 0.2em;
    font-weight: 600;
    margin-bottom: 2rem;
}

.hero-title-premium {
    font-size: clamp(2.5rem, 6vw, 4rem);
    font-weight: 900;
    margin-bottom: 1rem;
    font-family: 'Space Grotesk', sans-serif;
}

.hero-subtitle {
    font-size: 1.25rem;
    opacity: 0.9;
}

.scroll-indicator {
    position: absolute;
    bottom: 2rem;
    left: 50%;
    transform: translateX(-50%);
}

.scroll-indicator span {
    display: block;
    width: 24px;
    height: 36px;
    border: 2px solid white;
    border-radius: 12px;
    position: relative;
}

.scroll-indicator span::after {
    content: '';
    position: absolute;
    top: 6px;
    left: 50%;
    transform: translateX(-50%);
    width: 4px;
    height: 8px;
    background: white;
    border-radius: 2px;
    animation: scroll-down 2s infinite;
}

@keyframes scroll-down {
    0% { transform: translateX(-50%) translateY(0); opacity: 1; }
    100% { transform: translateX(-50%) translateY(12px); opacity: 0; }
}

/* About Introduction */
.about-intro-premium {
    padding: 5rem 0;
    background: white;
}

.section-label-premium {
    display: inline-block;
    padding: 0.5rem 1rem;
    background: #000;
    color: white;
    font-size: 0.625rem;
    letter-spacing: 0.2em;
    font-weight: 600;
    margin-bottom: 1rem;
}

.section-title-premium {
    font-size: clamp(2rem, 4vw, 3rem);
    font-weight: 900;
    line-height: 1.1;
    margin-bottom: 2rem;
    font-family: 'Space Grotesk', sans-serif;
}

.intro-text {
    font-size: 1.125rem;
    line-height: 1.8;
    color: #666;
    margin-bottom: 3rem;
}

.intro-stats {
    display: flex;
    gap: 3rem;
}

.stat-item {
    text-align: center;
}

.stat-number {
    display: block;
    font-size: 3rem;
    font-weight: 900;
    color: #000;
    margin-bottom: 0.5rem;
    font-family: 'Space Grotesk', sans-serif;
}

.stat-label {
    font-size: 0.875rem;
    color: #666;
    letter-spacing: 0.05em;
}

.intro-image-wrapper {
    position: relative;
}

.image-frame {
    position: relative;
    overflow: hidden;
    border-radius: 0;
    box-shadow: 0 20px 60px rgba(0,0,0,0.1);
}

.intro-image {
    width: 100%;
    height: auto;
    display: block;
}

.experience-badge {
    position: absolute;
    bottom: -2rem;
    right: 2rem;
    width: 120px;
    height: 120px;
    background: #000;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 10px 30px rgba(0,0,0,0.2);
}

.badge-content {
    text-align: center;
    color: white;
}

.badge-number {
    display: block;
    font-size: 2rem;
    font-weight: 900;
}

.badge-text {
    font-size: 0.75rem;
    letter-spacing: 0.1em;
}

/* Mission & Vision */
.mission-vision-premium {
    padding: 5rem 0;
    background: #f8f8f8;
}

.mv-card {
    background: white;
    padding: 3rem;
    text-align: center;
    position: relative;
    transition: all 0.3s;
    height: 100%;
}

.mv-card:hover {
    transform: translateY(-10px);
    box-shadow: 0 20px 60px rgba(0,0,0,0.1);
}

.mv-icon {
    width: 80px;
    height: 80px;
    margin: 0 auto 2rem;
    background: linear-gradient(135deg, #000 0%, #333 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 2rem;
}

.mv-title {
    font-size: 1.125rem;
    font-weight: 700;
    letter-spacing: 0.1em;
    margin-bottom: 1.5rem;
}

.mv-text {
    color: #666;
    line-height: 1.8;
}

.mv-decoration {
    position: absolute;
    top: 0;
    left: 0;
    width: 60px;
    height: 60px;
    border-top: 3px solid #000;
    border-left: 3px solid #000;
}

/* Premium Features */
.features-premium {
    padding: 5rem 0;
    background: white;
}

.section-header-center {
    text-align: center;
    margin-bottom: 4rem;
}

.features-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
    gap: 2rem;
}

.feature-card-premium {
    padding: 2rem;
    text-align: center;
    border: 1px solid #e0e0e0;
    transition: all 0.3s;
    background: white;
}

.feature-card-premium:hover {
    border-color: #000;
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.feature-icon {
    width: 60px;
    height: 60px;
    margin: 0 auto 1.5rem;
    background: #f8f8f8;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    color: #000;
    transition: all 0.3s;
}

.feature-card-premium:hover .feature-icon {
    background: #000;
    color: white;
}

.feature-title {
    font-size: 1.125rem;
    font-weight: 700;
    margin-bottom: 1rem;
}

.feature-text {
    color: #666;
    line-height: 1.6;
}

/* Global Presence */
.global-presence-premium {
    padding: 5rem 0;
    background: linear-gradient(135deg, #f8f8f8 0%, #fff 100%);
}

.presence-text {
    font-size: 1.125rem;
    color: #666;
    margin-bottom: 2rem;
    line-height: 1.8;
}

.regions-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 1rem;
    margin-bottom: 3rem;
}

.region-item {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.region-item i {
    color: #4CAF50;
}

.export-stats {
    display: flex;
    gap: 3rem;
}

.export-stat {
    text-align: center;
}

.stat-value {
    display: block;
    font-size: 2.5rem;
    font-weight: 900;
    color: #000;
    margin-bottom: 0.5rem;
}

.stat-desc {
    font-size: 0.875rem;
    color: #666;
    letter-spacing: 0.05em;
}

.world-map-container {
    position: relative;
}

.world-map {
    width: 100%;
    height: auto;
}

.map-pins {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
}

.pin {
    position: absolute;
    width: 16px;
    height: 16px;
    background: #ff3333;
    border-radius: 50%;
    border: 3px solid white;
    box-shadow: 0 2px 10px rgba(0,0,0,0.2);
    animation: pulse 2s infinite;
}

/* Testimonials */
.testimonials-premium {
    padding: 5rem 0;
    background: white;
}

.testimonial-card-premium {
    background: white;
    padding: 3rem;
    text-align: center;
    border: 1px solid #e0e0e0;
    height: 100%;
}

.quote-icon {
    font-size: 3rem;
    color: #e0e0e0;
    margin-bottom: 1.5rem;
}

.testimonial-rating {
    margin-bottom: 1.5rem;
}

.testimonial-rating i {
    color: #e0e0e0;
    margin: 0 2px;
}

.testimonial-rating i.active {
    color: #FFB800;
}

.testimonial-text {
    font-size: 1.125rem;
    line-height: 1.8;
    color: #333;
    margin-bottom: 2rem;
    font-style: italic;
}

.testimonial-author {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 1rem;
}

.author-image {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    object-fit: cover;
}

.author-placeholder {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    background: #f8f8f8;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #999;
}

.author-info {
    text-align: left;
}

.author-name {
    font-weight: 700;
    margin-bottom: 0.25rem;
}

.author-position {
    font-size: 0.875rem;
    color: #666;
    margin-bottom: 0.25rem;
}

.author-country {
    font-size: 0.75rem;
    color: #999;
}

/* CTA Section */
.cta-premium {
    padding: 6rem 0;
    position: relative;
    overflow: hidden;
}

.cta-bg {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(135deg, #000 0%, #333 100%);
    opacity: 0.95;
}

.cta-content {
    position: relative;
    z-index: 2;
    text-align: center;
    color: white;
}

.cta-title {
    font-size: 3rem;
    font-weight: 900;
    margin-bottom: 1rem;
}

.cta-subtitle {
    font-size: 1.25rem;
    opacity: 0.9;
    margin-bottom: 3rem;
}

.cta-buttons {
    display: flex;
    gap: 1rem;
    justify-content: center;
    flex-wrap: wrap;
}

.btn-cta-primary {
    padding: 1rem 2.5rem;
    background: white;
    color: #000;
    text-decoration: none;
    font-weight: 700;
    letter-spacing: 0.05em;
    transition: all 0.3s;
}

.btn-cta-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 30px rgba(255,255,255,0.2);
}

.btn-cta-secondary {
    padding: 1rem 2.5rem;
    background: transparent;
    color: white;
    border: 2px solid white;
    text-decoration: none;
    font-weight: 700;
    letter-spacing: 0.05em;
    transition: all 0.3s;
}

.btn-cta-secondary:hover {
    background: white;
    color: #000;
}

/* Responsive */
@media (max-width: 768px) {
    .hero-title-premium {
        font-size: 2rem;
    }
    
    .intro-stats {
        justify-content: space-around;
    }
    
    .stat-number {
        font-size: 2rem;
    }
    
    .features-grid {
        grid-template-columns: 1fr;
    }
    
    .regions-grid {
        grid-template-columns: 1fr;
    }
    
    .cta-title {
        font-size: 2rem;
    }
}
</style>
@endpush

@push('scripts')
<script>
// Initialize Swiper for testimonials
var testimonialsSwiper = new Swiper('.testimonialsSwiper', {
    slidesPerView: 1,
    spaceBetween: 30,
    loop: true,
    autoplay: {
        delay: 5000,
        disableOnInteraction: false,
    },
    pagination: {
        el: '.swiper-pagination',
        clickable: true,
    },
    breakpoints: {
        768: {
            slidesPerView: 2,
        },
        1024: {
            slidesPerView: 3,
        }
    }
});

// Counter animation
const counters = document.querySelectorAll('.stat-number');
const speed = 200;

counters.forEach(counter => {
    const animate = () => {
        const value = +counter.getAttribute('data-count');
        const data = +counter.innerText;
        const time = value / speed;
        
        if (data < value) {
            counter.innerText = Math.ceil(data + time);
            setTimeout(animate, 1);
        } else {
            counter.innerText = value + '+';
        }
    }
    
    // Start animation when element is in viewport
    const observer = new IntersectionObserver(entries => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                animate();
                observer.unobserve(entry.target);
            }
        });
    });
    
    observer.observe(counter);
});
</script>
@endpush
@endsection