@extends('layouts.app')

@section('title', 'My Addresses')
@section('meta_description', 'Manage your shipping addresses')

@section('content')
<!-- Premium Account Hero -->
<section class="account-hero-premium">
    <div class="hero-overlay"></div>
    <div class="container">
        <div class="hero-content-account" data-aos="fade-up">
            <h1 class="hero-title-account">MY ADDRESSES</h1>
            <p class="hero-subtitle-account">Manage your shipping destinations</p>
        </div>
    </div>
</section>

<!-- Addresses Content -->
<section class="account-section-premium">
    <div class="container">
        <div class="row">
            <!-- Premium Sidebar -->
            <div class="col-lg-3" data-aos="fade-right">
                @include('account.sidebar')
            </div>

            <!-- Addresses Content -->
            <div class="col-lg-9">
                <!-- Header with Add Button -->
                <div class="addresses-header-premium" data-aos="fade-up">
                    <h2 class="section-title-account">Shipping Addresses</h2>
                    <button type="button" class="btn-add-address" data-bs-toggle="modal" data-bs-target="#addAddressModal">
                        <i class="fas fa-plus"></i>
                        Add New Address
                    </button>
                </div>

                @if(session('success'))
                <div class="alert-premium success" data-aos="fade-down">
                    <i class="fas fa-check-circle"></i>
                    <span>{{ session('success') }}</span>
                    <button class="alert-close" onclick="this.parentElement.remove()">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                @endif

                @if($addresses->count() > 0)
                <!-- Addresses Grid -->
                <div class="addresses-grid-premium">
                    @foreach($addresses as $index => $address)
                    <div class="address-card-premium" data-aos="zoom-in" data-aos-delay="{{ $index * 100 }}">
                        @if($address->is_default)
                        <div class="default-badge">
                            <i class="fas fa-star"></i>
                            Default
                        </div>
                        @endif
                        
                        <div class="address-content">
                            <h4 class="address-name">
                                {{ $address->first_name }} {{ $address->last_name }}
                            </h4>
                            
                            <div class="address-details">
                                <p>{{ $address->address_line_1 }}</p>
                                @if($address->address_line_2)
                                <p>{{ $address->address_line_2 }}</p>
                                @endif
                                <p>{{ $address->city }}, {{ $address->state }} {{ $address->postal_code }}</p>
                                <p>{{ $address->country }}</p>
                            </div>
                            
                            <div class="address-contact">
                                <i class="fas fa-phone"></i>
                                {{ $address->phone }}
                            </div>
                        </div>
                        
                        <div class="address-actions">
                            <button type="button" class="btn-address-action edit" 
                                    data-bs-toggle="modal" 
                                    data-bs-target="#editAddressModal{{ $address->id }}">
                                <i class="fas fa-edit"></i>
                                Edit
                            </button>
                            
                            @if(!$address->is_default)
                            <form action="{{ route('account.address.update', $address->id) }}" method="POST" class="d-inline">
                                @csrf
                                @method('PUT')
                                <input type="hidden" name="is_default" value="1">
                                <input type="hidden" name="first_name" value="{{ $address->first_name }}">
                                <input type="hidden" name="last_name" value="{{ $address->last_name }}">
                                <input type="hidden" name="phone" value="{{ $address->phone }}">
                                <input type="hidden" name="address_line_1" value="{{ $address->address_line_1 }}">
                                <input type="hidden" name="address_line_2" value="{{ $address->address_line_2 }}">
                                <input type="hidden" name="city" value="{{ $address->city }}">
                                <input type="hidden" name="state" value="{{ $address->state }}">
                                <input type="hidden" name="postal_code" value="{{ $address->postal_code }}">
                                <input type="hidden" name="country" value="{{ $address->country }}">
                                <button type="submit" class="btn-address-action default">
                                    <i class="fas fa-star"></i>
                                    Set Default
                                </button>
                            </form>
                            @endif
                            
                            <form action="{{ route('account.address.delete', $address->id) }}" method="POST" 
                                  class="d-inline delete-form">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn-address-action delete">
                                    <i class="fas fa-trash"></i>
                                    Delete
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Edit Address Modal -->
                    <div class="modal fade premium-modal" id="editAddressModal{{ $address->id }}" tabindex="-1">
                        <div class="modal-dialog modal-lg modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header-premium">
                                    <h5 class="modal-title-premium">
                                        <i class="fas fa-edit"></i>
                                        Edit Address
                                    </h5>
                                    <button type="button" class="btn-close-premium" data-bs-dismiss="modal">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </div>
                                <form action="{{ route('account.address.update', $address->id) }}" method="POST">
                                    @csrf
                                    @method('PUT')
                                    <div class="modal-body-premium">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group-premium">
                                                    <label class="form-label-premium">First Name *</label>
                                                    <input type="text" class="form-control-premium" name="first_name" 
                                                           value="{{ $address->first_name }}" required>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group-premium">
                                                    <label class="form-label-premium">Last Name *</label>
                                                    <input type="text" class="form-control-premium" name="last_name" 
                                                           value="{{ $address->last_name }}" required>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="form-group-premium">
                                            <label class="form-label-premium">Phone *</label>
                                            <input type="tel" class="form-control-premium" name="phone" 
                                                   value="{{ $address->phone }}" required>
                                        </div>
                                        
                                        <div class="form-group-premium">
                                            <label class="form-label-premium">Address Line 1 *</label>
                                            <input type="text" class="form-control-premium" name="address_line_1" 
                                                   value="{{ $address->address_line_1 }}" required>
                                        </div>
                                        
                                        <div class="form-group-premium">
                                            <label class="form-label-premium">Address Line 2</label>
                                            <input type="text" class="form-control-premium" name="address_line_2" 
                                                   value="{{ $address->address_line_2 }}">
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group-premium">
                                                    <label class="form-label-premium">City *</label>
                                                    <input type="text" class="form-control-premium" name="city" 
                                                           value="{{ $address->city }}" required>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group-premium">
                                                    <label class="form-label-premium">State/Province *</label>
                                                    <input type="text" class="form-control-premium" name="state" 
                                                           value="{{ $address->state }}" required>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group-premium">
                                                    <label class="form-label-premium">Postal Code *</label>
                                                    <input type="text" class="form-control-premium" name="postal_code" 
                                                           value="{{ $address->postal_code }}" required>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group-premium">
                                                    <label class="form-label-premium">Country *</label>
                                                    <input type="text" class="form-control-premium" name="country" 
                                                           value="{{ $address->country }}" required>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="form-check-premium">
                                            <input class="form-check-input-premium" type="checkbox" name="is_default" 
                                                   id="is_default_edit{{ $address->id }}" 
                                                   {{ $address->is_default ? 'checked' : '' }}>
                                            <label class="form-check-label-premium" for="is_default_edit{{ $address->id }}">
                                                Set as default address
                                            </label>
                                        </div>
                                    </div>
                                    <div class="modal-footer-premium">
                                        <button type="button" class="btn-modal-cancel" data-bs-dismiss="modal">Cancel</button>
                                        <button type="submit" class="btn-modal-submit">
                                            <i class="fas fa-save"></i>
                                            Save Changes
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
                @else
                <!-- Empty State -->
                <div class="empty-addresses-premium" data-aos="zoom-in">
                    <div class="empty-icon">
                        <i class="fas fa-map-marker-alt"></i>
                    </div>
                    <h3>No Addresses Saved</h3>
                    <p>Add your first shipping address to get started</p>
                    <button type="button" class="btn-add-first" data-bs-toggle="modal" data-bs-target="#addAddressModal">
                        <i class="fas fa-plus"></i>
                        Add Your First Address
                    </button>
                </div>
                @endif
            </div>
        </div>
    </div>
</section>

<!-- Add Address Modal -->
<div class="modal fade premium-modal" id="addAddressModal" tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header-premium">
                <h5 class="modal-title-premium">
                    <i class="fas fa-plus"></i>
                    Add New Address
                </h5>
                <button type="button" class="btn-close-premium" data-bs-dismiss="modal">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <form action="{{ route('account.address.add') }}" method="POST">
                @csrf
                <div class="modal-body-premium">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group-premium">
                                <label class="form-label-premium">First Name *</label>
                                <input type="text" class="form-control-premium @error('first_name') is-invalid @enderror" 
                                       name="first_name" value="{{ old('first_name') }}" required>
                                @error('first_name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group-premium">
                                <label class="form-label-premium">Last Name *</label>
                                <input type="text" class="form-control-premium @error('last_name') is-invalid @enderror" 
                                       name="last_name" value="{{ old('last_name') }}" required>
                                @error('last_name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-group-premium">
                        <label class="form-label-premium">Phone *</label>
                        <input type="tel" class="form-control-premium @error('phone') is-invalid @enderror" 
                               name="phone" value="{{ old('phone') }}" required>
                        @error('phone')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="form-group-premium">
                        <label class="form-label-premium">Address Line 1 *</label>
                        <input type="text" class="form-control-premium @error('address_line_1') is-invalid @enderror" 
                               name="address_line_1" value="{{ old('address_line_1') }}" required>
                        @error('address_line_1')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="form-group-premium">
                        <label class="form-label-premium">Address Line 2</label>
                        <input type="text" class="form-control-premium @error('address_line_2') is-invalid @enderror" 
                               name="address_line_2" value="{{ old('address_line_2') }}">
                        @error('address_line_2')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group-premium">
                                <label class="form-label-premium">City *</label>
                                <input type="text" class="form-control-premium @error('city') is-invalid @enderror" 
                                       name="city" value="{{ old('city') }}" required>
                                @error('city')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group-premium">
                                <label class="form-label-premium">State/Province *</label>
                                <input type="text" class="form-control-premium @error('state') is-invalid @enderror" 
                                       name="state" value="{{ old('state') }}" required>
                                @error('state')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group-premium">
                                <label class="form-label-premium">Postal Code *</label>
                                <input type="text" class="form-control-premium @error('postal_code') is-invalid @enderror" 
                                       name="postal_code" value="{{ old('postal_code') }}" required>
                                @error('postal_code')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group-premium">
                                <label class="form-label-premium">Country *</label>
                                <select class="form-select-premium @error('country') is-invalid @enderror" name="country" required>
                                    <option value="">Select Country</option>
                                    <option value="United States">United States</option>
                                    <option value="Canada">Canada</option>
                                    <option value="United Kingdom">United Kingdom</option>
                                    <option value="Australia">Australia</option>
                                    <option value="India">India</option>
                                    <option value="Pakistan">Pakistan</option>
                                    <option value="Other">Other</option>
                                </select>
                                @error('country')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-check-premium">
                        <input class="form-check-input-premium" type="checkbox" name="is_default" id="is_default">
                        <label class="form-check-label-premium" for="is_default">
                            Set as default address
                        </label>
                    </div>
                </div>
                <div class="modal-footer-premium">
                    <button type="button" class="btn-modal-cancel" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn-modal-submit">
                        <i class="fas fa-plus"></i>
                        Add Address
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('styles')
<style>
/* Hero Styles (reused) */
.account-hero-premium {
    height: 30vh;
    min-height: 250px;
    background: linear-gradient(135deg, #000 0%, #333 100%);
    position: relative;
    display: flex;
    align-items: center;
    overflow: hidden;
}

.account-hero-premium::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: repeating-linear-gradient(
        45deg,
        transparent,
        transparent 35px,
        rgba(255,255,255,.02) 35px,
        rgba(255,255,255,.02) 70px
    );
}

.account-section-premium {
    padding: 4rem 0;
    background: #fafafa;
    min-height: 60vh;
}

/* Header */
.addresses-header-premium {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 2rem;
    flex-wrap: wrap;
    gap: 1rem;
}

.section-title-account {
    font-size: 1.75rem;
    font-weight: 800;
    color: #000;
    margin: 0;
    font-family: 'Space Grotesk', sans-serif;
}

.btn-add-address {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.875rem 1.5rem;
    background: #000;
    color: white;
    border: none;
    font-weight: 600;
    letter-spacing: 0.05em;
    transition: all 0.3s;
    cursor: pointer;
}

.btn-add-address:hover {
    background: #333;
    transform: translateY(-2px);
}

/* Alert */
.alert-premium {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem 1.5rem;
    margin-bottom: 2rem;
    background: white;
    border-left: 4px solid;
    box-shadow: 0 5px 15px rgba(0,0,0,0.05);
    position: relative;
}

.alert-premium.success {
    border-color: #4CAF50;
    color: #4CAF50;
}

.alert-close {
    position: absolute;
    right: 1rem;
    background: none;
    border: none;
    color: inherit;
    cursor: pointer;
    opacity: 0.5;
    transition: opacity 0.3s;
}

.alert-close:hover {
    opacity: 1;
}

/* Addresses Grid */
.addresses-grid-premium {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
    gap: 1.5rem;
}

.address-card-premium {
    background: white;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
    position: relative;
    overflow: hidden;
    transition: all 0.3s;
}

.address-card-premium:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 40px rgba(0,0,0,0.1);
}

.address-card-premium::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 3px;
    background: linear-gradient(90deg, #000 0%, #333 100%);
    transform: scaleX(0);
    transition: transform 0.3s;
}

.address-card-premium:hover::before {
    transform: scaleX(1);
}

.default-badge {
    position: absolute;
    top: 1rem;
    right: 1rem;
    background: linear-gradient(135deg, #FFD700 0%, #FFA500 100%);
    color: white;
    padding: 0.25rem 0.75rem;
    border-radius: 20px;
    font-size: 0.75rem;
    font-weight: 600;
    display: flex;
    align-items: center;
    gap: 0.25rem;
}

.address-content {
    padding: 2rem;
}

.address-name {
    font-size: 1.125rem;
    font-weight: 700;
    color: #000;
    margin-bottom: 1rem;
}

.address-details {
    color: #666;
    line-height: 1.6;
    margin-bottom: 1rem;
}

.address-details p {
    margin-bottom: 0.25rem;
}

.address-contact {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    color: #666;
    font-size: 0.875rem;
    padding-top: 1rem;
    border-top: 1px solid #f0f0f0;
}

.address-actions {
    display: flex;
    gap: 0.5rem;
    padding: 1rem 2rem;
    background: #fafafa;
    border-top: 1px solid #f0f0f0;
}

.btn-address-action {
    flex: 1;
    padding: 0.5rem;
    background: white;
    border: 1px solid #e0e0e0;
    color: #666;
    font-size: 0.875rem;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 0.25rem;
}

.btn-address-action:hover {
    background: #000;
    border-color: #000;
    color: white;
}

.btn-address-action.edit:hover {
    background: #2196F3;
    border-color: #2196F3;
}

.btn-address-action.default:hover {
    background: #FFA500;
    border-color: #FFA500;
}

.btn-address-action.delete:hover {
    background: #f44336;
    border-color: #f44336;
}

/* Empty State */
.empty-addresses-premium {
    background: white;
    padding: 5rem 2rem;
    text-align: center;
    box-shadow: 0 10px 30px rgba(0,0,0,0.05);
}

.empty-icon {
    width: 100px;
    height: 100px;
    margin: 0 auto 2rem;
    background: linear-gradient(135deg, #f0f0f0 0%, #e0e0e0 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 3rem;
    color: #999;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { transform: scale(1); }
    50% { transform: scale(1.05); }
}

.empty-addresses-premium h3 {
    font-size: 1.75rem;
    font-weight: 700;
    color: #333;
    margin-bottom: 0.5rem;
}

.empty-addresses-premium p {
    color: #666;
    margin-bottom: 2rem;
}

.btn-add-first {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 1rem 2.5rem;
    background: #000;
    color: white;
    border: none;
    font-weight: 700;
    letter-spacing: 0.05em;
    cursor: pointer;
    transition: all 0.3s;
}

.btn-add-first:hover {
    background: #333;
    transform: translateY(-2px);
}

/* Premium Modal */
.premium-modal .modal-content {
    border: none;
    box-shadow: 0 20px 60px rgba(0,0,0,0.2);
}

.modal-header-premium {
    background: linear-gradient(135deg, #000 0%, #333 100%);
    color: white;
    padding: 1.5rem;
    border: none;
}

.modal-title-premium {
    font-size: 1.25rem;
    font-weight: 700;
    display: flex;
    align-items: center;
    gap: 0.75rem;
    margin: 0;
}

.btn-close-premium {
    background: none;
    border: none;
    color: white;
    font-size: 1.25rem;
    cursor: pointer;
    opacity: 0.8;
    transition: opacity 0.3s;
}

.btn-close-premium:hover {
    opacity: 1;
}

.modal-body-premium {
    padding: 2rem;
}

.form-group-premium {
    margin-bottom: 1.5rem;
}

.form-label-premium {
    display: block;
    margin-bottom: 0.5rem;
    font-weight: 600;
    color: #333;
    font-size: 0.875rem;
    text-transform: uppercase;
    letter-spacing: 0.05em;
}

.form-control-premium,
.form-select-premium {
    width: 100%;
    padding: 0.875rem;
    border: 2px solid #e0e0e0;
    background: white;
    font-size: 1rem;
    transition: all 0.3s;
}

.form-control-premium:focus,
.form-select-premium:focus {
    outline: none;
    border-color: #000;
    box-shadow: 0 0 0 3px rgba(0,0,0,0.05);
}

.form-check-premium {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.form-check-input-premium {
    width: 20px;
    height: 20px;
    cursor: pointer;
}

.form-check-label-premium {
    cursor: pointer;
    user-select: none;
}

.modal-footer-premium {
    padding: 1.5rem;
    background: #fafafa;
    border: none;
    display: flex;
    justify-content: flex-end;
    gap: 1rem;
}

.btn-modal-cancel {
    padding: 0.75rem 1.5rem;
    background: white;
    border: 2px solid #e0e0e0;
    color: #666;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s;
}

.btn-modal-cancel:hover {
    background: #f0f0f0;
    border-color: #999;
    color: #333;
}

.btn-modal-submit {
    padding: 0.75rem 1.5rem;
    background: #000;
    border: none;
    color: white;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.btn-modal-submit:hover {
    background: #333;
    transform: translateY(-2px);
}

/* Responsive */
@media (max-width: 768px) {
    .addresses-grid-premium {
        grid-template-columns: 1fr;
    }
    
    .addresses-header-premium {
        flex-direction: column;
        align-items: flex-start;
    }
    
    .btn-add-address {
        width: 100%;
        justify-content: center;
    }
}
</style>
@endpush

@push('scripts')
<script>
// Delete confirmation
document.querySelectorAll('.delete-form').forEach(form => {
    form.addEventListener('submit', function(e) {
        e.preventDefault();
        if (confirm('Are you sure you want to delete this address? This action cannot be undone.')) {
            this.submit();
        }
    });
});

// Add floating label effect
document.querySelectorAll('.form-control-premium').forEach(input => {
    input.addEventListener('focus', function() {
        this.parentElement.classList.add('focused');
    });
    
    input.addEventListener('blur', function() {
        if (!this.value) {
            this.parentElement.classList.remove('focused');
        }
    });
});

// Card hover effect
document.querySelectorAll('.address-card-premium').forEach(card => {
    card.addEventListener('mouseenter', function() {
        this.style.transform = 'translateY(-5px) scale(1.02)';
    });
    
    card.addEventListener('mouseleave', function() {
        this.style.transform = 'translateY(0) scale(1)';
    });
});
</script>
@endpush
@endsection