@extends('admin.layouts.admin')

@section('title', 'Banner Management')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1>Banner Management</h1>
    <a href="{{ route('admin.banners.create') }}" class="btn btn-primary">
        <i class="fas fa-plus me-2"></i>Add New Banner
    </a>
</div>

@if(session('success'))
<div class="alert alert-success alert-dismissible fade show">
    {{ session('success') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
@endif

<!-- Image Size Guidelines -->
<div class="card mb-4">
    <div class="card-header bg-info text-white">
        <h5 class="mb-0"><i class="fas fa-info-circle me-2"></i>Image Size Guidelines</h5>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-4 col-lg-2">
                <h6><i class="fas fa-desktop me-2"></i>Hero Banners</h6>
                <p class="mb-0"><strong>Size:</strong> 1920x800px</p>
                <p class="text-muted small">Full-width hero images</p>
            </div>
            <div class="col-md-4 col-lg-2">
                <h6><i class="fas fa-square me-2"></i>Promo Left</h6>
                <p class="mb-0"><strong>Size:</strong> 600x400px</p>
                <p class="text-muted small">Left promo banner</p>
            </div>
            <div class="col-md-4 col-lg-2">
                <h6><i class="fas fa-square me-2"></i>Promo Right</h6>
                <p class="mb-0"><strong>Size:</strong> 600x400px</p>
                <p class="text-muted small">Right promo banner</p>
            </div>
            <div class="col-md-6 col-lg-3">
                <h6><i class="fas fa-images me-2"></i>Home Hero Slider</h6>
                <p class="mb-0"><strong>Size:</strong> 1920x600px</p>
                <p class="text-muted small">Animated slider below hero</p>
            </div>
            <div class="col-md-6 col-lg-3">
                <h6><i class="fas fa-layer-group me-2"></i>Below Categories</h6>
                <p class="mb-0"><strong>Size:</strong> 1920x400px</p>
                <p class="text-muted small">Slider after categories section</p>
            </div>
            <div class="col-md-6 col-lg-3">
                <h6><i class="fas fa-train me-2"></i>Train Slider</h6>
                <p class="mb-0"><strong>Size:</strong> 400x300px</p>
                <p class="text-muted small">Horizontal scrolling train above categories</p>
            </div>
        </div>
    </div>
</div>

<!-- Banners Table -->
<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th width="100">Image</th>
                        <th>Title</th>
                        <th>Position</th>
                        <th>Order</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($banners as $banner)
                    <tr>
                        <td>
                            <div class="position-relative">
                                <img src="{{ $banner->getPrimaryImageUrl() }}"
                                     alt="{{ $banner->title }}"
                                     class="img-thumbnail"
                                     style="width: 100px; height: 60px; object-fit: cover;">
                                @if($banner->isSlideshow())
                                    <span class="position-absolute top-0 end-0 badge bg-primary rounded-pill"
                                          style="transform: translate(50%, -50%);">
                                        <i class="fas fa-images"></i>
                                    </span>
                                @endif
                            </div>
                        </td>
                        <td>
                            <strong>{{ $banner->title }}</strong>
                            @if($banner->subtitle)
                            <br><small class="text-muted">{{ $banner->subtitle }}</small>
                            @endif
                        </td>
                        <td>
                            @switch($banner->position)
                                @case('hero')
                                    <span class="badge bg-primary">Hero Banner</span>
                                    @break
                                @case('promo_left')
                                    <span class="badge bg-info">Promo Left</span>
                                    @break
                                @case('promo_right')
                                    <span class="badge bg-info">Promo Right</span>
                                    @break
                                @case('home_hero_slider')
                                    <span class="badge bg-success">
                                        <i class="fas fa-images me-1"></i>Home Hero Slider
                                    </span>
                                    @break
                                @case('below_categories_slider')
                                    <span class="badge bg-warning">
                                        <i class="fas fa-layer-group me-1"></i>Below Categories
                                    </span>
                                    @break
                                @case('train_slider')
                                    <span class="badge bg-secondary">
                                        <i class="fas fa-train me-1"></i>Train Slider
                                    </span>
                                    @break
                            @endswitch
                        </td>
                        <td>{{ $banner->sort_order }}</td>
                        <td>
                            <form action="{{ route('admin.banners.toggleActive', $banner) }}" method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-sm btn-{{ $banner->is_active ? 'success' : 'secondary' }}">
                                    {{ $banner->is_active ? 'Active' : 'Inactive' }}
                                </button>
                            </form>
                        </td>
                        <td>
                            <div class="btn-group" role="group">
                                <a href="{{ route('admin.banners.edit', $banner) }}" 
                                   class="btn btn-sm btn-warning" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="{{ route('admin.banners.destroy', $banner) }}" 
                                      method="POST" 
                                      class="d-inline"
                                      onsubmit="return confirm('Are you sure you want to delete this banner?');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger" title="Delete">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="text-center py-4">
                            <i class="fas fa-images fa-3x text-muted mb-3"></i>
                            <p class="text-muted">No banners found. Create your first banner!</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        
        {{ $banners->links('pagination::bootstrap-5') }}
    </div>
</div>
@endsection