@extends('admin.layouts.admin')

@section('title', 'Blog Management')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h1 class="h3 mb-0">Blog Management</h1>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                <li class="breadcrumb-item active">Blogs</li>
            </ol>
        </nav>
    </div>
    <a href="{{ route('admin.blogs.create') }}" class="btn btn-primary">
        <i class="fas fa-plus"></i> Add New Blog Post
    </a>
</div>
<div class="card">
    <div class="card-header">
        <h3 class="card-title mb-0">Blog Posts</h3>
    </div>

                <div class="card-body">
                    @if($blogs->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th width="80">Image</th>
                                        <th>Title</th>
                                        <th width="100">Author</th>
                                        <th width="80">Status</th>
                                        <th width="80">Featured</th>
                                        <th width="100">Published Date</th>
                                        <th width="80">Views</th>
                                        <th width="200">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($blogs as $blog)
                                    <tr>
                                        <td>
                                            @if($blog->featured_image)
                                                <img src="{{ \App\Helpers\ImageHelper::getImageUrl($blog->featured_image) }}" 
                                                     alt="{{ $blog->title }}" 
                                                     class="img-fluid rounded" 
                                                     style="max-width: 60px; height: 40px; object-fit: cover;">
                                            @else
                                                <div class="bg-light rounded d-flex align-items-center justify-content-center" 
                                                     style="width: 60px; height: 40px;">
                                                    <i class="fas fa-image text-muted"></i>
                                                </div>
                                            @endif
                                        </td>
                                        <td>
                                            <strong>{{ $blog->title }}</strong>
                                            <br>
                                            <small class="text-muted">{{ Str::limit($blog->excerpt, 50) }}</small>
                                        </td>
                                        <td>{{ $blog->author }}</td>
                                        <td>
                                            <form action="{{ route('admin.blogs.toggle-published', $blog) }}" method="POST" style="display: inline;">
                                                @csrf
                                                <button type="submit" class="btn btn-sm {{ $blog->is_published ? 'btn-success' : 'btn-secondary' }}" 
                                                        onclick="return confirm('Are you sure?')">
                                                    {{ $blog->is_published ? 'Published' : 'Draft' }}
                                                </button>
                                            </form>
                                        </td>
                                        <td>
                                            <form action="{{ route('admin.blogs.toggle-featured', $blog) }}" method="POST" style="display: inline;">
                                                @csrf
                                                <button type="submit" class="btn btn-sm {{ $blog->is_featured ? 'btn-warning' : 'btn-outline-secondary' }}" 
                                                        onclick="return confirm('Are you sure?')">
                                                    <i class="fas fa-star"></i>
                                                </button>
                                            </form>
                                        </td>
                                        <td>
                                            {{ $blog->published_at ? $blog->published_at->format('M d, Y') : '-' }}
                                        </td>
                                        <td>
                                            <span class="badge badge-info">{{ number_format($blog->views) }}</span>
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('blogs.show', $blog->slug) }}" 
                                                   class="btn btn-sm btn-info" 
                                                   target="_blank" 
                                                   title="View">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('admin.blogs.edit', $blog) }}" 
                                                   class="btn btn-sm btn-warning" 
                                                   title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="{{ route('admin.blogs.destroy', $blog) }}" 
                                                      method="POST" 
                                                      style="display: inline;"
                                                      onsubmit="return confirm('Are you sure you want to delete this blog post?')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" 
                                                            class="btn btn-sm btn-danger" 
                                                            title="Delete">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        <div class="d-flex justify-content-center">
                            {{ $blogs->links() }}
                        </div>
                    @else
                        <div class="text-center py-4">
                            <i class="fas fa-blog fa-3x text-muted mb-3"></i>
                            <h4>No Blog Posts Found</h4>
                            <p class="text-muted">Create your first blog post to get started.</p>
                            <a href="{{ route('admin.blogs.create') }}" class="btn btn-primary">
                                <i class="fas fa-plus"></i> Add New Blog Post
                            </a>
                        </div>
                    @endif
    </div>
</div>

@push('styles')
<style>
    .btn-group .btn {
        border-radius: 0;
    }
    .btn-group .btn:first-child {
        border-top-left-radius: 0.25rem;
        border-bottom-left-radius: 0.25rem;
    }
    .btn-group .btn:last-child {
        border-top-right-radius: 0.25rem;
        border-bottom-right-radius: 0.25rem;
    }
</style>
@endpush
@endsection