@extends('admin.layouts.admin')

@section('title', 'View Community Page')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1>{{ $communityPage->title }}</h1>
    <div class="d-flex gap-2">
        <a href="{{ route('admin.community-pages.edit', $communityPage) }}" class="btn btn-primary">
            <i class="fas fa-edit me-2"></i>Edit Page
        </a>
        <a href="{{ route('admin.community-pages.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-2"></i>Back to Pages
        </a>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Page Content</h5>
                <div class="d-flex gap-2">
                    <span class="badge {{ $communityPage->is_active ? 'bg-success' : 'bg-secondary' }}">
                        {{ $communityPage->is_active ? 'Active' : 'Inactive' }}
                    </span>
                    <code class="text-muted">{{ $communityPage->page_key }}</code>
                </div>
            </div>
            <div class="card-body">
                @if($communityPage->content)
                    <div class="content-preview">
                        {!! $communityPage->content !!}
                    </div>
                @else
                    <p class="text-muted text-center py-4">
                        <i class="fas fa-file-text fa-2x mb-2"></i><br>
                        No content has been added to this page yet.
                    </p>
                @endif
            </div>
        </div>

        @if($communityPage->images && count($communityPage->images) > 0)
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-images me-2"></i>Page Images 
                    <span class="badge bg-info">{{ count($communityPage->images) }}</span>
                </h5>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    @foreach($communityPage->images as $image)
                    <div class="col-md-4">
                        <div class="card">
                            <img src="{{ \App\Helpers\ImageHelper::getImageUrl($image) }}" class="card-img-top" style="height: 200px; object-fit: cover;">
                            <div class="card-body p-2">
                                <small class="text-muted d-block">{{ basename($image) }}</small>
                                <button class="btn btn-sm btn-outline-primary mt-1" onclick="viewFullImage('{{ \App\Helpers\ImageHelper::getImageUrl($image) }}')">
                                    <i class="fas fa-expand-alt"></i> View Full
                                </button>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
        @endif
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Page Information</h5>
            </div>
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-sm-5"><strong>Page Key:</strong></div>
                    <div class="col-sm-7"><code>{{ $communityPage->page_key }}</code></div>
                </div>
                <div class="row mb-3">
                    <div class="col-sm-5"><strong>Status:</strong></div>
                    <div class="col-sm-7">
                        <span class="badge {{ $communityPage->is_active ? 'bg-success' : 'bg-secondary' }}">
                            {{ $communityPage->is_active ? 'Active' : 'Inactive' }}
                        </span>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-sm-5"><strong>Images:</strong></div>
                    <div class="col-sm-7">{{ count($communityPage->images ?? []) }} images</div>
                </div>
                <div class="row mb-3">
                    <div class="col-sm-5"><strong>Created:</strong></div>
                    <div class="col-sm-7">{{ $communityPage->created_at->format('M d, Y') }}</div>
                </div>
                <div class="row mb-3">
                    <div class="col-sm-5"><strong>Updated:</strong></div>
                    <div class="col-sm-7">{{ $communityPage->updated_at->format('M d, Y') }}</div>
                </div>
            </div>
        </div>

        @if($communityPage->meta_title || $communityPage->meta_description)
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">SEO Information</h5>
            </div>
            <div class="card-body">
                @if($communityPage->meta_title)
                <div class="mb-3">
                    <label class="form-label"><strong>Meta Title:</strong></label>
                    <p class="mb-0">{{ $communityPage->meta_title }}</p>
                    <small class="text-muted">{{ strlen($communityPage->meta_title) }} characters</small>
                </div>
                @endif
                
                @if($communityPage->meta_description)
                <div class="mb-3">
                    <label class="form-label"><strong>Meta Description:</strong></label>
                    <p class="mb-0">{{ $communityPage->meta_description }}</p>
                    <small class="text-muted">{{ strlen($communityPage->meta_description) }} characters</small>
                </div>
                @endif
            </div>
        </div>
        @endif

        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">Quick Actions</h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <button type="button" class="btn btn-outline-{{ $communityPage->is_active ? 'warning' : 'success' }}" 
                            onclick="toggleStatus({{ $communityPage->id }})">
                        <i class="fas fa-{{ $communityPage->is_active ? 'pause' : 'play' }}"></i> 
                        {{ $communityPage->is_active ? 'Deactivate' : 'Activate' }} Page
                    </button>
                    
                    <a href="{{ route('admin.community-pages.edit', $communityPage) }}" class="btn btn-outline-primary">
                        <i class="fas fa-edit"></i> Edit Page
                    </a>
                    
                    <form method="POST" action="{{ route('admin.community-pages.destroy', $communityPage) }}" style="display:inline;">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-outline-danger w-100" 
                                onclick="return confirm('Are you sure you want to delete this page and all its images?')">
                            <i class="fas fa-trash"></i> Delete Page
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Image Modal -->
<div class="modal fade" id="imageModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Page Image</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body text-center">
                <img id="modalImage" src="" class="img-fluid" style="max-width: 100%; height: auto;">
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// Toggle page status
function toggleStatus(pageId) {
    fetch(`{{ url('admin/community-pages') }}/${pageId}/toggle-status`, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            'Content-Type': 'application/json',
        },
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('An error occurred while updating page status.');
    });
}

// View full image
function viewFullImage(imageUrl) {
    document.getElementById('modalImage').src = imageUrl;
    new bootstrap.Modal(document.getElementById('imageModal')).show();
}
</script>
@endpush