@extends('admin.layouts.admin')

@section('title', 'Edit Community Post')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1>Edit Community Post</h1>
    <div class="btn-group">
        <a href="{{ route('admin.community.show', $community) }}" class="btn btn-outline-info">
            <i class="fas fa-eye me-2"></i>View Post
        </a>
        <a href="{{ route('admin.community.index') }}" class="btn btn-outline-secondary">
            <i class="fas fa-arrow-left me-2"></i>Back to Community
        </a>
    </div>
</div>

<form action="{{ route('admin.community.update', $community) }}" method="POST" enctype="multipart/form-data">
    @csrf
    @method('PUT')
    
    <div class="row">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Post Details</h5>
                    
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="name" class="form-label">Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                   id="name" name="name" value="{{ old('name', $community->name) }}" required>
                            @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label for="location" class="form-label">Location <span class="text-danger">*</span></label>
                            <select class="form-select @error('location') is-invalid @enderror" id="location" name="location" required>
                                <option value="">Select Location</option>
                                <option value="Melbourne, VIC" {{ old('location', $community->location) == 'Melbourne, VIC' ? 'selected' : '' }}>Melbourne, VIC</option>
                                <option value="Sydney, NSW" {{ old('location', $community->location) == 'Sydney, NSW' ? 'selected' : '' }}>Sydney, NSW</option>
                                <option value="Brisbane, QLD" {{ old('location', $community->location) == 'Brisbane, QLD' ? 'selected' : '' }}>Brisbane, QLD</option>
                                <option value="Perth, WA" {{ old('location', $community->location) == 'Perth, WA' ? 'selected' : '' }}>Perth, WA</option>
                                <option value="Adelaide, SA" {{ old('location', $community->location) == 'Adelaide, SA' ? 'selected' : '' }}>Adelaide, SA</option>
                                <option value="Canberra, ACT" {{ old('location', $community->location) == 'Canberra, ACT' ? 'selected' : '' }}>Canberra, ACT</option>
                                <option value="Darwin, NT" {{ old('location', $community->location) == 'Darwin, NT' ? 'selected' : '' }}>Darwin, NT</option>
                                <option value="Hobart, TAS" {{ old('location', $community->location) == 'Hobart, TAS' ? 'selected' : '' }}>Hobart, TAS</option>
                                <option value="Gold Coast, QLD" {{ old('location', $community->location) == 'Gold Coast, QLD' ? 'selected' : '' }}>Gold Coast, QLD</option>
                                <option value="Newcastle, NSW" {{ old('location', $community->location) == 'Newcastle, NSW' ? 'selected' : '' }}>Newcastle, NSW</option>
                                <option value="Wollongong, NSW" {{ old('location', $community->location) == 'Wollongong, NSW' ? 'selected' : '' }}>Wollongong, NSW</option>
                                <option value="Other" {{ old('location', $community->location) == 'Other' ? 'selected' : '' }}>Other Australian City</option>
                            </select>
                            @error('location')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="caption" class="form-label">Caption <span class="text-danger">*</span></label>
                        <textarea class="form-control @error('caption') is-invalid @enderror" id="caption" 
                                  name="caption" rows="4" required>{{ old('caption', $community->caption) }}</textarea>
                        @error('caption')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Share the story behind this style.</div>
                    </div>

                    <div class="mb-3">
                        <label for="products_featured" class="form-label">Products Featured</label>
                        <input type="text" class="form-control @error('products_featured') is-invalid @enderror" 
                               id="products_featured" name="products_featured" value="{{ old('products_featured', $community->products_featured) }}" 
                               placeholder="e.g., Cultural Fusion Hoodie, Heritage Print Tee">
                        @error('products_featured')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">List the Edition By Punjab products featured in this post.</div>
                    </div>

                    <div class="mb-3">
                        <label for="instagram_handle" class="form-label">Instagram Handle</label>
                        <div class="input-group">
                            <span class="input-group-text">@</span>
                            <input type="text" class="form-control @error('instagram_handle') is-invalid @enderror" 
                                   id="instagram_handle" name="instagram_handle" value="{{ old('instagram_handle', $community->instagram_handle) }}" 
                                   placeholder="username">
                        </div>
                        @error('instagram_handle')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="likes" class="form-label">Likes</label>
                        <input type="number" class="form-control @error('likes') is-invalid @enderror" 
                               id="likes" name="likes" value="{{ old('likes', $community->likes) }}" min="0">
                        @error('likes')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Settings</h5>
                    
                    <div class="mb-3">
                        <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                        <select class="form-select @error('status') is-invalid @enderror" id="status" name="status" required>
                            <option value="pending" {{ old('status', $community->status) == 'pending' ? 'selected' : '' }}>Pending</option>
                            <option value="approved" {{ old('status', $community->status) == 'approved' ? 'selected' : '' }}>Approved</option>
                            <option value="rejected" {{ old('status', $community->status) == 'rejected' ? 'selected' : '' }}>Rejected</option>
                        </select>
                        @error('status')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        @if($community->approved_at)
                            <div class="form-text text-success">
                                <i class="fas fa-check-circle"></i> Approved on {{ $community->approved_at->format('M d, Y g:i A') }}
                            </div>
                        @endif
                    </div>

                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="featured" name="featured" value="1" 
                                   {{ old('featured', $community->featured) ? 'checked' : '' }}>
                            <label class="form-check-label" for="featured">
                                <strong>Featured Post</strong>
                            </label>
                        </div>
                        <div class="form-text">Featured posts appear prominently in the community gallery.</div>
                    </div>

                    <hr>

                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="consent_social" name="consent_social" value="1" 
                                   {{ old('consent_social', $community->consent_social) ? 'checked' : '' }}>
                            <label class="form-check-label" for="consent_social">
                                Social Media Consent
                            </label>
                        </div>
                    </div>

                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="consent_marketing" name="consent_marketing" value="1" 
                                   {{ old('consent_marketing', $community->consent_marketing) ? 'checked' : '' }}>
                            <label class="form-check-label" for="consent_marketing">
                                Marketing Consent
                            </label>
                        </div>
                    </div>

                    <div class="alert alert-info">
                        <small>
                            <strong>Submitted:</strong> {{ $community->created_at->format('M d, Y g:i A') }}<br>
                            <strong>Last Updated:</strong> {{ $community->updated_at->format('M d, Y g:i A') }}
                        </small>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Post Image</h5>
                    
                    @if($community->image_path)
                        <div class="mb-3">
                            <img src="{{ asset('images/' . $community->image_path) }}" 
                                 class="img-fluid rounded" alt="Current image">
                            <div class="form-text">Current image</div>
                        </div>
                    @endif
                    
                    <div class="mb-3">
                        <input type="file" class="form-control @error('image') is-invalid @enderror" 
                               id="image" name="image" accept="image/*">
                        @error('image')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">
                            {{ $community->image_path ? 'Upload a new image to replace the current one' : 'Upload an image' }} 
                            (max 10MB). JPG, PNG, GIF supported.
                        </div>
                    </div>

                    <div id="imagePreview" class="text-center" style="display: none;">
                        <img id="previewImg" src="" class="img-fluid rounded" style="max-height: 200px;">
                        <div class="form-text">New image preview</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="d-flex justify-content-end gap-2 mt-4">
        <a href="{{ route('admin.community.index') }}" class="btn btn-secondary">Cancel</a>
        <button type="submit" class="btn btn-primary">
            <i class="fas fa-save me-2"></i>Update Post
        </button>
    </div>
</form>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Image preview
    const imageInput = document.getElementById('image');
    const imagePreview = document.getElementById('imagePreview');
    const previewImg = document.getElementById('previewImg');

    imageInput.addEventListener('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                previewImg.src = e.target.result;
                imagePreview.style.display = 'block';
            }
            reader.readAsDataURL(file);
        } else {
            imagePreview.style.display = 'none';
        }
    });
});
</script>
@endpush