@extends('admin.layouts.admin')

@section('title', 'Discount Management')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1>Discount Campaigns</h1>
    <a href="{{ route('admin.discounts.create') }}" class="btn btn-primary">
        <i class="fas fa-plus me-2"></i>Create New Campaign
    </a>
</div>

<!-- Active Campaigns -->
<div class="card mb-4">
    <div class="card-header">
        <h5 class="mb-0">Active Campaigns</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Discount</th>
                        <th>Start Date</th>
                        <th>End Date</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($campaigns as $campaign)
                    <tr>
                        <td>{{ $campaign->name }}</td>
                        <td>{{ $campaign->discount_percentage }}%</td>
                        <td>{{ $campaign->starts_at->format('M d, Y H:i') }}</td>
                        <td>{{ $campaign->ends_at->format('M d, Y H:i') }}</td>
                        <td>
                            @if($campaign->isActive())
                                <span class="badge bg-success">Active</span>
                            @elseif($campaign->starts_at > now())
                                <span class="badge bg-info">Upcoming</span>
                            @else
                                <span class="badge bg-secondary">Ended</span>
                            @endif
                        </td>
                        <td>
                            <a href="{{ route('admin.discounts.edit', $campaign) }}" class="btn btn-sm btn-warning">
                                <i class="fas fa-edit"></i>
                            </a>
                            <form action="{{ route('admin.discounts.toggle', $campaign) }}" method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-sm btn-{{ $campaign->is_active ? 'danger' : 'success' }}">
                                    <i class="fas fa-{{ $campaign->is_active ? 'pause' : 'play' }}"></i>
                                </button>
                            </form>
                            <form action="{{ route('admin.discounts.destroy', $campaign) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="text-center">No campaigns found</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        {{ $campaigns->links() }}
    </div>
</div>

<!-- User Discounts -->
<div class="card">
    <div class="card-header">
        <h5 class="mb-0">Newsletter Subscriber Discounts</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Email</th>
                        <th>Discount Code</th>
                        <th>Percentage</th>
                        <th>Status</th>
                        <th>Used At</th>
                        <th>Expires At</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($userDiscounts as $discount)
                    <tr>
                        <td>{{ $discount->email }}</td>
                        <td><code>{{ $discount->discount_code }}</code></td>
                        <td>{{ $discount->discount_percentage }}%</td>
                        <td>
                            @if($discount->is_used)
                                <span class="badge bg-secondary">Used</span>
                            @elseif($discount->expires_at && $discount->expires_at < now())
                                <span class="badge bg-danger">Expired</span>
                            @else
                                <span class="badge bg-success">Active</span>
                            @endif
                        </td>
                        <td>{{ $discount->used_at ? $discount->used_at->format('M d, Y') : '-' }}</td>
                        <td>{{ $discount->expires_at ? $discount->expires_at->format('M d, Y') : 'Never' }}</td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="text-center">No user discounts found</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        {{ $userDiscounts->links() }}
    </div>
</div>
@endsection