<!-- resources/views/admin/inquiries/index.blade.php -->
@extends('admin.layouts.admin')

@section('title', 'Inquiries')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1>Inquiries</h1>
    <div>
        <span class="badge bg-warning">New: {{ $inquiries->where('status', 'new')->count() }}</span>
        <span class="badge bg-info">In Progress: {{ $inquiries->where('status', 'in_progress')->count() }}</span>
        <span class="badge bg-success">Completed: {{ $inquiries->where('status', 'completed')->count() }}</span>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Country</th>
                        <th>Subject</th>
                        <th>Product</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($inquiries as $inquiry)
                    <tr>
                        <td>{{ $inquiry->created_at->format('Y-m-d') }}</td>
                        <td>{{ $inquiry->name }}</td>
                        <td>{{ $inquiry->email }}</td>
                        <td>{{ $inquiry->country }}</td>
                        <td>{{ Str::limit($inquiry->subject, 30) }}</td>
                        <td>
                            @if($inquiry->product)
                                <a href="{{ route('product.detail', $inquiry->product->slug) }}" target="_blank">
                                    {{ $inquiry->product->name }}
                                </a>
                            @else
                                -
                            @endif
                        </td>
                        <td>
                            <span class="badge bg-{{ $inquiry->status == 'new' ? 'warning' : ($inquiry->status == 'in_progress' ? 'info' : 'success') }}">
                                {{ ucfirst(str_replace('_', ' ', $inquiry->status)) }}
                            </span>
                        </td>
                        <td>
                            <a href="{{ route('admin.inquiries.show', $inquiry) }}" class="btn btn-sm btn-primary">
                                <i class="fas fa-eye"></i>
                            </a>
                            <form action="{{ route('admin.inquiries.destroy', $inquiry) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center">No inquiries found</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        {{ $inquiries->links() }}
    </div>
</div>
@endsection