<!-- resources/views/admin/inquiries/show.blade.php -->
@extends('admin.layouts.admin')

@section('title', 'View Inquiry')

@section('content')
<div class="mb-4">
    <h1>Inquiry Details</h1>
</div>

<div class="row">
    <div class="col-lg-8">
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Message</h5>
            </div>
            <div class="card-body">
                <h6>Subject: {{ $inquiry->subject }}</h6>
                <hr>
                <p>{{ $inquiry->message }}</p>
                
                @if($inquiry->product)
                <hr>
                <div class="alert alert-info">
                    <strong>Related Product:</strong> 
                    <a href="{{ route('product.detail', $inquiry->product->slug) }}" target="_blank">
                        {{ $inquiry->product->name }}
                    </a>
                </div>
                @endif
            </div>
        </div>

        <!-- Reply Section -->
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Send Reply</h5>
            </div>
            <div class="card-body">
                <form action="mailto:{{ $inquiry->email }}" method="get">
                    <div class="mb-3">
                        <label class="form-label">To:</label>
                        <input type="text" class="form-control" value="{{ $inquiry->email }}" readonly>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Subject:</label>
                        <input type="text" name="subject" class="form-control" value="Re: {{ $inquiry->subject }}">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Message:</label>
                        <textarea name="body" class="form-control" rows="6">
Dear {{ $inquiry->name }},

Thank you for your inquiry regarding {{ $inquiry->product ? $inquiry->product->name : 'our products' }}.



Best regards,
{{ $companyInfo->company_name ?? 'Your Company' }}
                        </textarea>
                    </div>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-envelope me-2"></i>Open in Email Client
                    </button>
                </form>
            </div>
        </div>
    </div>

    <div class="col-lg-4">
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Contact Information</h5>
            </div>
            <div class="card-body">
                <p><strong>Name:</strong> {{ $inquiry->name }}</p>
                <p><strong>Email:</strong> <a href="mailto:{{ $inquiry->email }}">{{ $inquiry->email }}</a></p>
                <p><strong>Phone:</strong> {{ $inquiry->phone ?: 'Not provided' }}</p>
                <p><strong>Company:</strong> {{ $inquiry->company ?: 'Not provided' }}</p>
                <p><strong>Country:</strong> {{ $inquiry->country }}</p>
                <p><strong>Date:</strong> {{ $inquiry->created_at->format('F d, Y H:i') }}</p>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Update Status</h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.inquiries.status', $inquiry) }}" method="POST">
                    @csrf
                    @method('PATCH')
                    <div class="mb-3">
                        <label for="status" class="form-label">Status</label>
                        <select name="status" id="status" class="form-select">
                            <option value="new" {{ $inquiry->status == 'new' ? 'selected' : '' }}>New</option>
                            <option value="in_progress" {{ $inquiry->status == 'in_progress' ? 'selected' : '' }}>In Progress</option>
                            <option value="completed" {{ $inquiry->status == 'completed' ? 'selected' : '' }}>Completed</option>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary w-100">Update Status</button>
                </form>
            </div>
        </div>

        <div class="mt-3">
            <a href="{{ route('admin.inquiries.index') }}" class="btn btn-secondary w-100">
                <i class="fas fa-arrow-left me-2"></i>Back to Inquiries
            </a>
        </div>
    </div>
</div>
@endsection