@extends('admin.layouts.admin')

@section('title', 'Edit Instagram Post')

@section('content')
<div class="mb-4">
    <h1>Edit Instagram Post</h1>
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="{{ route('admin.instagram.index') }}">Instagram Feed</a></li>
            <li class="breadcrumb-item active">Edit</li>
        </ol>
    </nav>
</div>

<div class="row">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Post Details</h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.instagram.update', $feed) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')

                    <div class="mb-3">
                        <label for="image" class="form-label">Image</label>
                        <input type="file" 
                               class="form-control @error('image') is-invalid @enderror" 
                               id="image" 
                               name="image" 
                               accept="image/jpeg,image/png,image/jpg,image/webp">
                        @error('image')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="alert alert-info mt-2">
                            <i class="fas fa-info-circle me-2"></i>
                            <strong>Recommended size:</strong> {{ $sizeRecommendation }}
                            <br>
                            <small>Leave empty to keep current image. Square images work best. Max file size: 2MB</small>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="link" class="form-label">Instagram Post URL <span class="text-danger">*</span></label>
                        <input type="url" 
                               class="form-control @error('link') is-invalid @enderror" 
                               id="link" 
                               name="link" 
                               value="{{ old('link', $feed->link) }}"
                               placeholder="https://instagram.com/p/..."
                               required>
                        @error('link')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="form-text text-muted">
                            Enter the full URL of your Instagram post
                        </small>
                    </div>

                    <div class="mb-3">
                        <label for="caption" class="form-label">Caption (Optional)</label>
                        <textarea class="form-control @error('caption') is-invalid @enderror" 
                                  id="caption" 
                                  name="caption" 
                                  rows="3"
                                  maxlength="500"
                                  placeholder="Enter a short caption...">{{ old('caption', $feed->caption) }}</textarea>
                        @error('caption')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="form-text text-muted">
                            <span id="captionCount">{{ strlen($feed->caption ?? '') }}</span>/500 characters
                        </small>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="sort_order" class="form-label">Display Order</label>
                                <input type="number" 
                                       class="form-control @error('sort_order') is-invalid @enderror" 
                                       id="sort_order" 
                                       name="sort_order" 
                                       value="{{ old('sort_order', $feed->sort_order) }}"
                                       min="0">
                                @error('sort_order')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="form-text text-muted">Lower numbers appear first</small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Status</label>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" 
                                           type="checkbox" 
                                           id="is_active" 
                                           name="is_active" 
                                           value="1"
                                           {{ old('is_active', $feed->is_active) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="is_active">
                                        Active (Show on homepage)
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="d-flex justify-content-between">
                        <a href="{{ route('admin.instagram.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-2"></i>Cancel
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>Update Post
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Current Image</h5>
            </div>
            <div class="card-body">
                <div id="currentImage" class="mb-3">
                    <div style="width: 100%; aspect-ratio: 1; overflow: hidden; border-radius: 8px;">
                        <img src="{{ \App\Helpers\ImageHelper::getImageUrl($feed->image) }}" 
                             class="img-fluid" 
                             alt="Instagram post"
                             style="width: 100%; height: 100%; object-fit: cover;">
                    </div>
                    <a href="{{ $feed->link }}" target="_blank" class="btn btn-sm btn-outline-primary w-100 mt-2">
                        <i class="fas fa-external-link-alt me-2"></i>View on Instagram
                    </a>
                </div>
            </div>
        </div>
        
        <div class="card mt-3">
            <div class="card-header">
                <h5 class="mb-0">New Image Preview</h5>
            </div>
            <div class="card-body">
                <div id="imagePreview" class="text-center">
                    <i class="fab fa-instagram fa-3x text-muted"></i>
                    <p class="text-muted mt-2">Select a new image to preview</p>
                </div>
            </div>
        </div>
        
        <div class="card mt-3">
            <div class="card-header">
                <h5 class="mb-0">Tips</h5>
            </div>
            <div class="card-body">
                <ul class="mb-0 small">
                    <li>Use square images (1:1 ratio) for best results</li>
                    <li>Keep file size under 2MB</li>
                    <li>Use high-quality images</li>
                    <li>Link to your actual Instagram post</li>
                    <li>Update caption to keep it fresh</li>
                </ul>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
// Initialize character counter with current value
document.addEventListener('DOMContentLoaded', function() {
    const caption = document.getElementById('caption');
    document.getElementById('captionCount').textContent = caption.value.length;
});

// Character counter for caption
document.getElementById('caption').addEventListener('input', function() {
    document.getElementById('captionCount').textContent = this.value.length;
});

// Image preview
document.getElementById('image').addEventListener('change', function(e) {
    const file = e.target.files[0];
    const preview = document.getElementById('imagePreview');
    
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            preview.innerHTML = `
                <div style="width: 100%; aspect-ratio: 1; overflow: hidden; border-radius: 8px;">
                    <img src="${e.target.result}" class="img-fluid" alt="Preview" style="width: 100%; height: 100%; object-fit: cover;">
                </div>
                <p class="text-muted mt-2 small">New Image Preview</p>
            `;
        }
        reader.readAsDataURL(file);
    } else {
        preview.innerHTML = `
            <i class="fab fa-instagram fa-3x text-muted"></i>
            <p class="text-muted mt-2">Select a new image to preview</p>
        `;
    }
});
</script>
@endpush

@endsection