@extends('admin.layouts.admin')

@section('title', 'Instagram Feed Management')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1>Instagram Feed</h1>
    <a href="{{ route('admin.instagram.create') }}" class="btn btn-primary">
        <i class="fas fa-plus me-2"></i>Add New Post
    </a>
</div>

@if(session('success'))
<div class="alert alert-success alert-dismissible fade show">
    {{ session('success') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
@endif

<!-- Image Size Guidelines -->
<div class="card mb-4">
    <div class="card-header bg-info text-white">
        <h5 class="mb-0"><i class="fas fa-info-circle me-2"></i>Instagram Image Guidelines</h5>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-6">
                <h6><i class="fab fa-instagram me-2"></i>Recommended Size</h6>
                <p class="mb-0"><strong>{{ $sizeRecommendation }}</strong></p>
                <p class="text-muted small">Square images work best for consistent grid display</p>
            </div>
            <div class="col-md-6">
                <h6><i class="fas fa-link me-2"></i>Instagram Link Format</h6>
                <p class="mb-0">Example: https://instagram.com/p/ABC123xyz/</p>
                <p class="text-muted small">Copy the full URL from your Instagram post</p>
            </div>
        </div>
    </div>
</div>

<!-- Instagram Posts Grid -->
<div class="card">
    <div class="card-body">
        <div class="row g-3">
            @forelse($feeds as $feed)
            <div class="col-lg-3 col-md-4 col-sm-6">
                <div class="card h-100">
                    <img src="{{ \App\Helpers\ImageHelper::getImageUrl($feed->image) }}" 
                         class="card-img-top" 
                         alt="Instagram post"
                         style="height: 200px; object-fit: cover;">
                    <div class="card-body">
                        @if($feed->caption)
                        <p class="small text-muted mb-2">{{ Str::limit($feed->caption, 50) }}</p>
                        @endif
                        <div class="d-flex align-items-center mb-2">
                            <span class="badge bg-{{ $feed->is_active ? 'success' : 'secondary' }} me-2">
                                {{ $feed->is_active ? 'Active' : 'Inactive' }}
                            </span>
                            <span class="badge bg-info">Order: {{ $feed->sort_order }}</span>
                        </div>
                        <div class="btn-group w-100" role="group">
                            <a href="{{ $feed->link }}" target="_blank" class="btn btn-sm btn-outline-primary" title="View on Instagram">
                                <i class="fas fa-external-link-alt"></i>
                            </a>
                            <a href="{{ route('admin.instagram.edit', $feed) }}" class="btn btn-sm btn-warning" title="Edit">
                                <i class="fas fa-edit"></i>
                            </a>
                            <form action="{{ route('admin.instagram.toggleActive', $feed) }}" method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-sm btn-{{ $feed->is_active ? 'success' : 'secondary' }}" title="Toggle Status">
                                    <i class="fas fa-power-off"></i>
                                </button>
                            </form>
                            <form action="{{ route('admin.instagram.destroy', $feed) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger" 
                                        onclick="return confirm('Are you sure you want to delete this post?')"
                                        title="Delete">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            @empty
            <div class="col-12">
                <div class="text-center py-5">
                    <i class="fab fa-instagram fa-4x text-muted mb-3"></i>
                    <p class="text-muted">No Instagram posts yet.</p>
                    <a href="{{ route('admin.instagram.create') }}" class="btn btn-primary">
                        Add Your First Post
                    </a>
                </div>
            </div>
            @endforelse
        </div>
        
        <div class="mt-4">
            {{ $feeds->links('pagination::bootstrap-5') }}
        </div>
    </div>
</div>
@endsection