@extends('admin.layouts.admin')

@section('title', 'Legal Pages Management')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">Legal Pages Management</h1>
    <a href="{{ route('admin.legal-pages.create') }}" class="btn btn-primary">
        <i class="fas fa-plus"></i> Add New Legal Page
    </a>
</div>

<div class="card">
    <div class="card-body">
        @if($legalPages->count() > 0)
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Title</th>
                            <th>Slug</th>
                            <th>Status</th>
                            <th>Last Updated</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($legalPages as $page)
                            <tr>
                                <td>
                                    <strong>{{ $page->title }}</strong>
                                    @if($page->meta_description)
                                        <small class="d-block text-muted">{{ Str::limit($page->meta_description, 60) }}</small>
                                    @endif
                                </td>
                                <td>
                                    <code>{{ $page->slug }}</code>
                                </td>
                                <td>
                                    @if($page->is_active)
                                        <span class="badge bg-success">Active</span>
                                    @else
                                        <span class="badge bg-secondary">Inactive</span>
                                    @endif
                                </td>
                                <td>{{ $page->updated_at->format('M d, Y') }}</td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <a href="{{ route('admin.legal-pages.show', $page) }}" 
                                           class="btn btn-sm btn-outline-primary" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('admin.legal-pages.edit', $page) }}" 
                                           class="btn btn-sm btn-outline-secondary" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="{{ route('admin.legal-pages.toggle-status', $page) }}" 
                                              method="POST" style="display: inline;">
                                            @csrf
                                            @method('PATCH')
                                            <button type="submit" 
                                                    class="btn btn-sm {{ $page->is_active ? 'btn-outline-warning' : 'btn-outline-success' }}" 
                                                    title="{{ $page->is_active ? 'Deactivate' : 'Activate' }}">
                                                <i class="fas fa-{{ $page->is_active ? 'eye-slash' : 'eye' }}"></i>
                                            </button>
                                        </form>
                                        <form action="{{ route('admin.legal-pages.destroy', $page) }}" 
                                              method="POST" style="display: inline;"
                                              onsubmit="return confirm('Are you sure you want to delete this legal page?')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-outline-danger" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            
            <div class="d-flex justify-content-center">
                {{ $legalPages->links() }}
            </div>
        @else
            <div class="text-center py-5">
                <i class="fas fa-file-contract fa-3x text-muted mb-3"></i>
                <h5>No Legal Pages Found</h5>
                <p class="text-muted">Create your first legal page to get started.</p>
                <a href="{{ route('admin.legal-pages.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Add Legal Page
                </a>
            </div>
        @endif
    </div>
</div>
@endsection